/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.common.cache;

import conductor.org.elasticsearch.common.cache.Cache;
import conductor.org.elasticsearch.common.cache.RemovalListener;
import conductor.org.elasticsearch.common.unit.TimeValue;
import java.util.Objects;
import java.util.function.ToLongBiFunction;

public class CacheBuilder<K, V> {
    private long maximumWeight = -1L;
    private long expireAfterAccessNanos = -1L;
    private long expireAfterWriteNanos = -1L;
    private ToLongBiFunction<K, V> weigher;
    private RemovalListener<K, V> removalListener;

    public static <K, V> CacheBuilder<K, V> builder() {
        return new CacheBuilder<K, V>();
    }

    private CacheBuilder() {
    }

    public CacheBuilder<K, V> setMaximumWeight(long maximumWeight) {
        if (maximumWeight < 0L) {
            throw new IllegalArgumentException("maximumWeight < 0");
        }
        this.maximumWeight = maximumWeight;
        return this;
    }

    public CacheBuilder<K, V> setExpireAfterAccess(TimeValue expireAfterAccess) {
        Objects.requireNonNull(expireAfterAccess);
        long expireAfterAccessNanos = expireAfterAccess.getNanos();
        if (expireAfterAccessNanos <= 0L) {
            throw new IllegalArgumentException("expireAfterAccess <= 0");
        }
        this.expireAfterAccessNanos = expireAfterAccessNanos;
        return this;
    }

    public CacheBuilder<K, V> setExpireAfterWrite(TimeValue expireAfterWrite) {
        Objects.requireNonNull(expireAfterWrite);
        long expireAfterWriteNanos = expireAfterWrite.getNanos();
        if (expireAfterWriteNanos <= 0L) {
            throw new IllegalArgumentException("expireAfterWrite <= 0");
        }
        this.expireAfterWriteNanos = expireAfterWriteNanos;
        return this;
    }

    public CacheBuilder<K, V> weigher(ToLongBiFunction<K, V> weigher) {
        Objects.requireNonNull(weigher);
        this.weigher = weigher;
        return this;
    }

    public CacheBuilder<K, V> removalListener(RemovalListener<K, V> removalListener) {
        Objects.requireNonNull(removalListener);
        this.removalListener = removalListener;
        return this;
    }

    public Cache<K, V> build() {
        Cache<K, V> cache = new Cache<K, V>();
        if (this.maximumWeight != -1L) {
            cache.setMaximumWeight(this.maximumWeight);
        }
        if (this.expireAfterAccessNanos != -1L) {
            cache.setExpireAfterAccessNanos(this.expireAfterAccessNanos);
        }
        if (this.expireAfterWriteNanos != -1L) {
            cache.setExpireAfterWriteNanos(this.expireAfterWriteNanos);
        }
        if (this.weigher != null) {
            cache.setWeigher(this.weigher);
        }
        if (this.removalListener != null) {
            cache.setRemovalListener(this.removalListener);
        }
        return cache;
    }
}

