/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.common.inject.spi;

import conductor.org.elasticsearch.common.inject.Binder;
import conductor.org.elasticsearch.common.inject.ConfigurationException;
import conductor.org.elasticsearch.common.inject.TypeLiteral;
import conductor.org.elasticsearch.common.inject.spi.Element;
import conductor.org.elasticsearch.common.inject.spi.ElementVisitor;
import conductor.org.elasticsearch.common.inject.spi.InjectionPoint;
import java.util.Objects;
import java.util.Set;

public final class InjectionRequest<T>
implements Element {
    private final Object source;
    private final TypeLiteral<T> type;
    private final T instance;

    public InjectionRequest(Object source, TypeLiteral<T> type, T instance) {
        this.source = Objects.requireNonNull(source, "source");
        this.type = Objects.requireNonNull(type, "type");
        this.instance = Objects.requireNonNull(instance, "instance");
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    public T getInstance() {
        return this.instance;
    }

    public TypeLiteral<T> getType() {
        return this.type;
    }

    public Set<InjectionPoint> getInjectionPoints() throws ConfigurationException {
        return InjectionPoint.forInstanceMethodsAndFields(this.instance.getClass());
    }

    public <R> R acceptVisitor(ElementVisitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public void applyTo(Binder binder) {
        binder.withSource(this.getSource()).requestInjection(this.type, this.instance);
    }
}

