/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.common.inject.util;

import conductor.org.elasticsearch.common.inject.AbstractModule;
import conductor.org.elasticsearch.common.inject.Binder;
import conductor.org.elasticsearch.common.inject.Binding;
import conductor.org.elasticsearch.common.inject.Key;
import conductor.org.elasticsearch.common.inject.Module;
import conductor.org.elasticsearch.common.inject.PrivateBinder;
import conductor.org.elasticsearch.common.inject.Scope;
import conductor.org.elasticsearch.common.inject.spi.DefaultBindingScopingVisitor;
import conductor.org.elasticsearch.common.inject.spi.DefaultElementVisitor;
import conductor.org.elasticsearch.common.inject.spi.Element;
import conductor.org.elasticsearch.common.inject.spi.Elements;
import conductor.org.elasticsearch.common.inject.spi.PrivateElements;
import conductor.org.elasticsearch.common.inject.spi.ScopeBinding;
import conductor.org.elasticsearch.common.util.set.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class Modules {
    public static final Module EMPTY_MODULE = new Module(){

        @Override
        public void configure(Binder binder) {
        }
    };

    private Modules() {
    }

    public static OverriddenModuleBuilder override(Module ... modules) {
        return new RealOverriddenModuleBuilder(Arrays.asList(modules));
    }

    public static OverriddenModuleBuilder override(Iterable<? extends Module> modules) {
        return new RealOverriddenModuleBuilder(modules);
    }

    public static Module combine(Module ... modules) {
        return Modules.combine(Arrays.asList(modules));
    }

    public static Module combine(Iterable<? extends Module> modules) {
        final HashSet<? extends Module> modulesSet = Sets.newHashSet(modules);
        return new Module(){

            @Override
            public void configure(Binder binder) {
                binder = binder.skipSources(this.getClass());
                for (Module module : modulesSet) {
                    binder.install(module);
                }
            }
        };
    }

    private static class ModuleWriter
    extends DefaultElementVisitor<Void> {
        protected final Binder binder;

        ModuleWriter(Binder binder) {
            this.binder = binder;
        }

        @Override
        protected Void visitOther(Element element) {
            element.applyTo(this.binder);
            return null;
        }

        void writeAll(Iterable<? extends Element> elements) {
            for (Element element : elements) {
                element.acceptVisitor(this);
            }
        }
    }

    private static final class RealOverriddenModuleBuilder
    implements OverriddenModuleBuilder {
        private final Set<Module> baseModules;

        private RealOverriddenModuleBuilder(Iterable<? extends Module> baseModules) {
            HashSet<? extends Module> modules = Sets.newHashSet(baseModules);
            this.baseModules = Collections.unmodifiableSet(modules);
        }

        @Override
        public Module with(Module ... overrides) {
            return this.with(Arrays.asList(overrides));
        }

        @Override
        public Module with(final Iterable<? extends Module> overrides) {
            return new AbstractModule(){

                @Override
                public void configure() {
                    List<Element> elements = Elements.getElements(baseModules);
                    List<Element> overrideElements = Elements.getElements(overrides);
                    final HashSet overriddenKeys = new HashSet();
                    final HashSet overridesScopeAnnotations = new HashSet();
                    new ModuleWriter(this.binder()){

                        @Override
                        public <T> Void visit(Binding<T> binding) {
                            overriddenKeys.add(binding.getKey());
                            return (Void)super.visit(binding);
                        }

                        @Override
                        public Void visit(ScopeBinding scopeBinding) {
                            overridesScopeAnnotations.add(scopeBinding.getAnnotationType());
                            return (Void)super.visit(scopeBinding);
                        }

                        @Override
                        public Void visit(PrivateElements privateElements) {
                            overriddenKeys.addAll(privateElements.getExposedKeys());
                            return (Void)super.visit(privateElements);
                        }
                    }.writeAll(overrideElements);
                    final HashMap scopeInstancesInUse = new HashMap();
                    final ArrayList scopeBindings = new ArrayList();
                    new ModuleWriter(this.binder()){

                        @Override
                        public <T> Void visit(Binding<T> binding) {
                            if (!overriddenKeys.remove(binding.getKey())) {
                                super.visit(binding);
                                Scope scope = this.getScopeInstanceOrNull(binding);
                                if (scope != null) {
                                    scopeInstancesInUse.put(scope, binding.getSource());
                                }
                            }
                            return null;
                        }

                        @Override
                        public Void visit(PrivateElements privateElements) {
                            PrivateBinder privateBinder = this.binder.withSource(privateElements.getSource()).newPrivateBinder();
                            HashSet skippedExposes = new HashSet();
                            for (Key<?> key : privateElements.getExposedKeys()) {
                                if (overriddenKeys.remove(key)) {
                                    skippedExposes.add(key);
                                    continue;
                                }
                                privateBinder.withSource(privateElements.getExposedSource(key)).expose(key);
                            }
                            for (Element element : privateElements.getElements()) {
                                if (element instanceof Binding && skippedExposes.contains(((Binding)element).getKey())) continue;
                                element.applyTo(privateBinder);
                            }
                            return null;
                        }

                        @Override
                        public Void visit(ScopeBinding scopeBinding) {
                            scopeBindings.add(scopeBinding);
                            return null;
                        }
                    }.writeAll(elements);
                    new ModuleWriter(this.binder()){

                        @Override
                        public Void visit(ScopeBinding scopeBinding) {
                            if (!overridesScopeAnnotations.remove(scopeBinding.getAnnotationType())) {
                                super.visit(scopeBinding);
                            } else {
                                Object source = scopeInstancesInUse.get(scopeBinding.getScope());
                                if (source != null) {
                                    this.binder().withSource(source).addError("The scope for @%s is bound directly and cannot be overridden.", scopeBinding.getAnnotationType().getSimpleName());
                                }
                            }
                            return null;
                        }
                    }.writeAll(scopeBindings);
                }

                private Scope getScopeInstanceOrNull(Binding<?> binding) {
                    return binding.acceptScopingVisitor(new DefaultBindingScopingVisitor<Scope>(){

                        @Override
                        public Scope visitScope(Scope scope) {
                            return scope;
                        }
                    });
                }
            };
        }
    }

    public static interface OverriddenModuleBuilder {
        public Module with(Module ... var1);

        public Module with(Iterable<? extends Module> var1);
    }
}

