/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.common.util.concurrent;

import conductor.org.elasticsearch.common.Priority;
import java.util.concurrent.Callable;

public abstract class PrioritizedCallable<T>
implements Callable<T>,
Comparable<PrioritizedCallable> {
    private final Priority priority;

    public static <T> PrioritizedCallable<T> wrap(Callable<T> callable, Priority priority) {
        return new Wrapped(callable, priority);
    }

    protected PrioritizedCallable(Priority priority) {
        this.priority = priority;
    }

    @Override
    public int compareTo(PrioritizedCallable pc) {
        return this.priority.compareTo(pc.priority);
    }

    public Priority priority() {
        return this.priority;
    }

    static class Wrapped<T>
    extends PrioritizedCallable<T> {
        private final Callable<T> callable;

        private Wrapped(Callable<T> callable, Priority priority) {
            super(priority);
            this.callable = callable;
        }

        @Override
        public T call() throws Exception {
            return this.callable.call();
        }
    }
}

