/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.discovery.zen;

import conductor.org.apache.logging.log4j.message.ParameterizedMessage;
import conductor.org.elasticsearch.common.component.AbstractComponent;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.common.transport.TransportAddress;
import conductor.org.elasticsearch.discovery.zen.UnicastHostsProvider;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FileBasedUnicastHostsProvider
extends AbstractComponent
implements UnicastHostsProvider {
    public static final String UNICAST_HOSTS_FILE = "unicast_hosts.txt";
    private final Path unicastHostsFilePath;
    private final Path legacyUnicastHostsFilePath;

    public FileBasedUnicastHostsProvider(Settings settings, Path configFile) {
        super(settings);
        this.unicastHostsFilePath = configFile.resolve(UNICAST_HOSTS_FILE);
        this.legacyUnicastHostsFilePath = configFile.resolve("discovery-file").resolve(UNICAST_HOSTS_FILE);
    }

    private List<String> getHostsList() {
        if (Files.exists(this.unicastHostsFilePath, new LinkOption[0])) {
            return this.readFileContents(this.unicastHostsFilePath);
        }
        if (Files.exists(this.legacyUnicastHostsFilePath, new LinkOption[0])) {
            this.deprecationLogger.deprecated("Found dynamic hosts list at [{}] but this path is deprecated. This list should be at [{}] instead. Support for the deprecated path will be removed in future.", this.legacyUnicastHostsFilePath, this.unicastHostsFilePath);
            return this.readFileContents(this.legacyUnicastHostsFilePath);
        }
        this.logger.warn("expected, but did not find, a dynamic hosts list at [{}]", (Object)this.unicastHostsFilePath);
        return Collections.emptyList();
    }

    private List<String> readFileContents(Path path) {
        List<String> list;
        block8: {
            Stream<String> lines = Files.lines(path);
            try {
                list = lines.filter(line -> !line.startsWith("#")).collect(Collectors.toList());
                if (lines == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (lines != null) {
                        try {
                            lines.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    this.logger.warn(() -> new ParameterizedMessage("failed to read file [{}]", (Object)this.unicastHostsFilePath), (Throwable)e);
                    return Collections.emptyList();
                }
            }
            lines.close();
        }
        return list;
    }

    @Override
    public List<TransportAddress> buildDynamicHosts(UnicastHostsProvider.HostsResolver hostsResolver) {
        List<TransportAddress> transportAddresses = hostsResolver.resolveHosts(this.getHostsList(), 1);
        this.logger.debug("seed addresses: {}", (Object)transportAddresses);
        return transportAddresses;
    }
}

