/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.fielddata;

import conductor.org.apache.lucene.util.NumericUtils;
import conductor.org.elasticsearch.index.fielddata.AbstractNumericDocValues;
import conductor.org.elasticsearch.index.fielddata.NumericDoubleValues;
import java.io.IOException;

final class SortableLongBitsNumericDocValues
extends AbstractNumericDocValues {
    private int docID = -1;
    private final NumericDoubleValues values;

    SortableLongBitsNumericDocValues(NumericDoubleValues values) {
        this.values = values;
    }

    @Override
    public long longValue() throws IOException {
        return NumericUtils.doubleToSortableLong(this.values.doubleValue());
    }

    @Override
    public boolean advanceExact(int target) throws IOException {
        this.docID = target;
        return this.values.advanceExact(target);
    }

    @Override
    public int docID() {
        return this.docID;
    }

    public NumericDoubleValues getDoubleValues() {
        return this.values;
    }
}

