/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.fielddata.plain;

import conductor.org.apache.logging.log4j.Logger;
import conductor.org.apache.lucene.index.DirectoryReader;
import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.apache.lucene.index.OrdinalMap;
import conductor.org.apache.lucene.index.SortedSetDocValues;
import conductor.org.apache.lucene.search.SortField;
import conductor.org.apache.lucene.search.SortedSetSelector;
import conductor.org.apache.lucene.search.SortedSetSortField;
import conductor.org.elasticsearch.ElasticsearchException;
import conductor.org.elasticsearch.common.Nullable;
import conductor.org.elasticsearch.common.logging.Loggers;
import conductor.org.elasticsearch.index.IndexSettings;
import conductor.org.elasticsearch.index.fielddata.AtomicOrdinalsFieldData;
import conductor.org.elasticsearch.index.fielddata.IndexFieldData;
import conductor.org.elasticsearch.index.fielddata.IndexFieldDataCache;
import conductor.org.elasticsearch.index.fielddata.IndexOrdinalsFieldData;
import conductor.org.elasticsearch.index.fielddata.ScriptDocValues;
import conductor.org.elasticsearch.index.fielddata.fieldcomparator.BytesRefFieldComparatorSource;
import conductor.org.elasticsearch.index.fielddata.ordinals.GlobalOrdinalsBuilder;
import conductor.org.elasticsearch.index.fielddata.plain.DocValuesIndexFieldData;
import conductor.org.elasticsearch.index.fielddata.plain.SortedSetDVBytesAtomicFieldData;
import conductor.org.elasticsearch.indices.breaker.CircuitBreakerService;
import conductor.org.elasticsearch.search.MultiValueMode;
import java.io.IOException;
import java.util.function.Function;

public class SortedSetDVOrdinalsIndexFieldData
extends DocValuesIndexFieldData
implements IndexOrdinalsFieldData {
    private final IndexSettings indexSettings;
    private final IndexFieldDataCache cache;
    private final CircuitBreakerService breakerService;
    private final Function<SortedSetDocValues, ScriptDocValues<?>> scriptFunction;
    private static final Logger logger = Loggers.getLogger(SortedSetDVOrdinalsIndexFieldData.class);

    public SortedSetDVOrdinalsIndexFieldData(IndexSettings indexSettings, IndexFieldDataCache cache, String fieldName, CircuitBreakerService breakerService, Function<SortedSetDocValues, ScriptDocValues<?>> scriptFunction) {
        super(indexSettings.getIndex(), fieldName);
        this.indexSettings = indexSettings;
        this.cache = cache;
        this.breakerService = breakerService;
        this.scriptFunction = scriptFunction;
    }

    @Override
    public SortField sortField(@Nullable Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, boolean reverse) {
        BytesRefFieldComparatorSource source = new BytesRefFieldComparatorSource(this, missingValue, sortMode, nested);
        if (nested != null || sortMode != MultiValueMode.MAX && sortMode != MultiValueMode.MIN || !source.sortMissingLast(missingValue) && !source.sortMissingFirst(missingValue)) {
            return new SortField(this.getFieldName(), source, reverse);
        }
        SortedSetSortField sortField = new SortedSetSortField(this.fieldName, reverse, sortMode == MultiValueMode.MAX ? SortedSetSelector.Type.MAX : SortedSetSelector.Type.MIN);
        ((SortField)sortField).setMissingValue(source.sortMissingLast(missingValue) ^ reverse ? SortedSetSortField.STRING_LAST : SortedSetSortField.STRING_FIRST);
        return sortField;
    }

    @Override
    public AtomicOrdinalsFieldData load(LeafReaderContext context) {
        return new SortedSetDVBytesAtomicFieldData(context.reader(), this.fieldName, this.scriptFunction);
    }

    @Override
    public AtomicOrdinalsFieldData loadDirect(LeafReaderContext context) throws Exception {
        return this.load(context);
    }

    @Override
    public IndexOrdinalsFieldData loadGlobal(DirectoryReader indexReader) {
        if (indexReader.leaves().size() <= 1) {
            return this;
        }
        boolean fieldFound = false;
        for (LeafReaderContext context : indexReader.leaves()) {
            if (context.reader().getFieldInfos().fieldInfo(this.getFieldName()) == null) continue;
            fieldFound = true;
            break;
        }
        if (!fieldFound) {
            try {
                return GlobalOrdinalsBuilder.buildEmpty(this.indexSettings, indexReader, this);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            return this.cache.load(indexReader, this);
        }
        catch (Exception e) {
            if (e instanceof ElasticsearchException) {
                throw (ElasticsearchException)e;
            }
            throw new ElasticsearchException(e);
        }
    }

    @Override
    public IndexOrdinalsFieldData localGlobalDirect(DirectoryReader indexReader) throws Exception {
        return GlobalOrdinalsBuilder.build(indexReader, this, this.indexSettings, this.breakerService, logger, this.scriptFunction);
    }

    @Override
    public OrdinalMap getOrdinalMap() {
        return null;
    }
}

