/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.reindex;

import conductor.org.elasticsearch.ExceptionsHelper;
import conductor.org.elasticsearch.action.bulk.BulkItemResponse;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.index.reindex.BulkByScrollResponse;
import conductor.org.elasticsearch.index.reindex.ScrollableHitSource;
import conductor.org.elasticsearch.rest.BytesRestResponse;
import conductor.org.elasticsearch.rest.RestChannel;
import conductor.org.elasticsearch.rest.RestResponse;
import conductor.org.elasticsearch.rest.RestStatus;
import conductor.org.elasticsearch.rest.action.RestBuilderListener;
import java.util.Map;

public class BulkIndexByScrollResponseContentListener
extends RestBuilderListener<BulkByScrollResponse> {
    private final Map<String, String> params;

    public BulkIndexByScrollResponseContentListener(RestChannel channel, Map<String, String> params) {
        super(channel);
        this.params = params;
    }

    @Override
    public RestResponse buildResponse(BulkByScrollResponse response, XContentBuilder builder) throws Exception {
        builder.startObject();
        response.toXContent(builder, new ToXContent.DelegatingMapParams(this.params, this.channel.request()));
        builder.endObject();
        return new BytesRestResponse(this.getStatus(response), builder);
    }

    private RestStatus getStatus(BulkByScrollResponse response) {
        RestStatus status = RestStatus.OK;
        if (response.isTimedOut()) {
            status = RestStatus.REQUEST_TIMEOUT;
        }
        for (BulkItemResponse.Failure failure : response.getBulkFailures()) {
            if (failure.getStatus().getStatus() <= status.getStatus()) continue;
            status = failure.getStatus();
        }
        for (ScrollableHitSource.SearchFailure searchFailure : response.getSearchFailures()) {
            RestStatus failureStatus = ExceptionsHelper.status(searchFailure.getReason());
            if (failureStatus.getStatus() <= status.getStatus()) continue;
            status = failureStatus;
        }
        return status;
    }
}

