/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.reindex;

import conductor.org.apache.logging.log4j.Logger;
import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.action.FailedNodeException;
import conductor.org.elasticsearch.action.TaskOperationFailure;
import conductor.org.elasticsearch.action.admin.cluster.node.tasks.list.ListTasksResponse;
import conductor.org.elasticsearch.action.support.ActionFilters;
import conductor.org.elasticsearch.action.support.tasks.TransportTasksAction;
import conductor.org.elasticsearch.client.Client;
import conductor.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import conductor.org.elasticsearch.cluster.service.ClusterService;
import conductor.org.elasticsearch.common.inject.Inject;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.index.reindex.BulkByScrollTask;
import conductor.org.elasticsearch.index.reindex.LeaderBulkByScrollTaskState;
import conductor.org.elasticsearch.index.reindex.RethrottleAction;
import conductor.org.elasticsearch.index.reindex.RethrottleRequest;
import conductor.org.elasticsearch.tasks.TaskId;
import conductor.org.elasticsearch.tasks.TaskInfo;
import conductor.org.elasticsearch.threadpool.ThreadPool;
import conductor.org.elasticsearch.transport.TransportService;
import java.io.IOException;
import java.util.List;

public class TransportRethrottleAction
extends TransportTasksAction<BulkByScrollTask, RethrottleRequest, ListTasksResponse, TaskInfo> {
    private final Client client;

    @Inject
    public TransportRethrottleAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Client client) {
        super(settings, "cluster:admin/reindex/rethrottle", threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, RethrottleRequest::new, ListTasksResponse::new, "management");
        this.client = client;
    }

    @Override
    protected void taskOperation(RethrottleRequest request, BulkByScrollTask task, ActionListener<TaskInfo> listener) {
        TransportRethrottleAction.rethrottle(this.logger, this.clusterService.localNode().getId(), this.client, task, request.getRequestsPerSecond(), listener);
    }

    static void rethrottle(Logger logger, String localNodeId, Client client, BulkByScrollTask task, float newRequestsPerSecond, ActionListener<TaskInfo> listener) {
        if (task.isWorker()) {
            TransportRethrottleAction.rethrottleChildTask(logger, localNodeId, task, newRequestsPerSecond, listener);
            return;
        }
        if (task.isLeader()) {
            TransportRethrottleAction.rethrottleParentTask(logger, localNodeId, client, task, newRequestsPerSecond, listener);
            return;
        }
        throw new IllegalArgumentException("task [" + task.getId() + "] has not yet been initialized to the point where it knows how to rethrottle itself");
    }

    private static void rethrottleParentTask(Logger logger, String localNodeId, Client client, BulkByScrollTask task, float newRequestsPerSecond, ActionListener<TaskInfo> listener) {
        LeaderBulkByScrollTaskState leaderState = task.getLeaderState();
        int runningSubtasks = leaderState.runningSliceSubTasks();
        if (runningSubtasks > 0) {
            RethrottleRequest subRequest = new RethrottleRequest();
            subRequest.setRequestsPerSecond(newRequestsPerSecond / (float)runningSubtasks);
            subRequest.setParentTaskId(new TaskId(localNodeId, task.getId()));
            logger.debug("rethrottling children of task [{}] to [{}] requests per second", (Object)task.getId(), (Object)Float.valueOf(subRequest.getRequestsPerSecond()));
            client.execute(RethrottleAction.INSTANCE, subRequest, ActionListener.wrap(r -> {
                r.rethrowFailures("Rethrottle");
                listener.onResponse(task.taskInfoGivenSubtaskInfo(localNodeId, r.getTasks()));
            }, listener::onFailure));
        } else {
            logger.debug("children of task [{}] are already finished, nothing to rethrottle", (Object)task.getId());
            listener.onResponse(task.taskInfo(localNodeId, true));
        }
    }

    private static void rethrottleChildTask(Logger logger, String localNodeId, BulkByScrollTask task, float newRequestsPerSecond, ActionListener<TaskInfo> listener) {
        logger.debug("rethrottling local task [{}] to [{}] requests per second", (Object)task.getId(), (Object)Float.valueOf(newRequestsPerSecond));
        task.getWorkerState().rethrottle(newRequestsPerSecond);
        listener.onResponse(task.taskInfo(localNodeId, true));
    }

    @Override
    protected TaskInfo readTaskResponse(StreamInput in) throws IOException {
        return new TaskInfo(in);
    }

    @Override
    protected ListTasksResponse newResponse(RethrottleRequest request, List<TaskInfo> tasks, List<TaskOperationFailure> taskOperationFailures, List<FailedNodeException> failedNodeExceptions) {
        return new ListTasksResponse(tasks, taskOperationFailures, failedNodeExceptions);
    }
}

