/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.shard;

import conductor.com.carrotsearch.hppc.ObjectLongMap;
import conductor.org.apache.logging.log4j.Logger;
import conductor.org.apache.lucene.index.CheckIndex;
import conductor.org.apache.lucene.index.IndexOptions;
import conductor.org.apache.lucene.index.SegmentInfos;
import conductor.org.apache.lucene.index.Term;
import conductor.org.apache.lucene.search.Query;
import conductor.org.apache.lucene.search.QueryCachingPolicy;
import conductor.org.apache.lucene.search.ReferenceManager;
import conductor.org.apache.lucene.search.Sort;
import conductor.org.apache.lucene.search.UsageTrackingQueryCachingPolicy;
import conductor.org.apache.lucene.store.AlreadyClosedException;
import conductor.org.apache.lucene.util.BytesRef;
import conductor.org.apache.lucene.util.ThreadInterruptedException;
import conductor.org.elasticsearch.Assertions;
import conductor.org.elasticsearch.ElasticsearchException;
import conductor.org.elasticsearch.ExceptionsHelper;
import conductor.org.elasticsearch.Version;
import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.action.admin.indices.flush.FlushRequest;
import conductor.org.elasticsearch.action.admin.indices.forcemerge.ForceMergeRequest;
import conductor.org.elasticsearch.action.admin.indices.upgrade.post.UpgradeRequest;
import conductor.org.elasticsearch.cluster.metadata.IndexMetaData;
import conductor.org.elasticsearch.cluster.metadata.MappingMetaData;
import conductor.org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import conductor.org.elasticsearch.cluster.routing.RecoverySource;
import conductor.org.elasticsearch.cluster.routing.ShardRouting;
import conductor.org.elasticsearch.common.Booleans;
import conductor.org.elasticsearch.common.CheckedRunnable;
import conductor.org.elasticsearch.common.Nullable;
import conductor.org.elasticsearch.common.collect.Tuple;
import conductor.org.elasticsearch.common.io.stream.BytesStreamOutput;
import conductor.org.elasticsearch.common.lease.Releasable;
import conductor.org.elasticsearch.common.lease.Releasables;
import conductor.org.elasticsearch.common.lucene.Lucene;
import conductor.org.elasticsearch.common.metrics.CounterMetric;
import conductor.org.elasticsearch.common.metrics.MeanMetric;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.common.unit.TimeValue;
import conductor.org.elasticsearch.common.util.BigArrays;
import conductor.org.elasticsearch.common.util.concurrent.AbstractRunnable;
import conductor.org.elasticsearch.common.util.concurrent.AsyncIOProcessor;
import conductor.org.elasticsearch.common.xcontent.XContentHelper;
import conductor.org.elasticsearch.core.internal.io.IOUtils;
import conductor.org.elasticsearch.index.Index;
import conductor.org.elasticsearch.index.IndexModule;
import conductor.org.elasticsearch.index.IndexNotFoundException;
import conductor.org.elasticsearch.index.IndexService;
import conductor.org.elasticsearch.index.IndexSettings;
import conductor.org.elasticsearch.index.VersionType;
import conductor.org.elasticsearch.index.cache.IndexCache;
import conductor.org.elasticsearch.index.cache.bitset.ShardBitsetFilterCache;
import conductor.org.elasticsearch.index.cache.request.ShardRequestCache;
import conductor.org.elasticsearch.index.codec.CodecService;
import conductor.org.elasticsearch.index.engine.CommitStats;
import conductor.org.elasticsearch.index.engine.Engine;
import conductor.org.elasticsearch.index.engine.EngineConfig;
import conductor.org.elasticsearch.index.engine.EngineException;
import conductor.org.elasticsearch.index.engine.EngineFactory;
import conductor.org.elasticsearch.index.engine.RefreshFailedEngineException;
import conductor.org.elasticsearch.index.engine.Segment;
import conductor.org.elasticsearch.index.engine.SegmentsStats;
import conductor.org.elasticsearch.index.fielddata.FieldDataStats;
import conductor.org.elasticsearch.index.fielddata.ShardFieldData;
import conductor.org.elasticsearch.index.flush.FlushStats;
import conductor.org.elasticsearch.index.get.GetStats;
import conductor.org.elasticsearch.index.get.ShardGetService;
import conductor.org.elasticsearch.index.mapper.DocumentMapper;
import conductor.org.elasticsearch.index.mapper.DocumentMapperForType;
import conductor.org.elasticsearch.index.mapper.MapperParsingException;
import conductor.org.elasticsearch.index.mapper.MapperService;
import conductor.org.elasticsearch.index.mapper.Mapping;
import conductor.org.elasticsearch.index.mapper.ParsedDocument;
import conductor.org.elasticsearch.index.mapper.RootObjectMapper;
import conductor.org.elasticsearch.index.mapper.SourceToParse;
import conductor.org.elasticsearch.index.mapper.Uid;
import conductor.org.elasticsearch.index.merge.MergeStats;
import conductor.org.elasticsearch.index.recovery.RecoveryStats;
import conductor.org.elasticsearch.index.refresh.RefreshStats;
import conductor.org.elasticsearch.index.search.stats.SearchStats;
import conductor.org.elasticsearch.index.search.stats.ShardSearchStats;
import conductor.org.elasticsearch.index.seqno.ReplicationTracker;
import conductor.org.elasticsearch.index.seqno.SeqNoStats;
import conductor.org.elasticsearch.index.shard.AbstractIndexShardComponent;
import conductor.org.elasticsearch.index.shard.DocsStats;
import conductor.org.elasticsearch.index.shard.GlobalCheckpointListeners;
import conductor.org.elasticsearch.index.shard.IllegalIndexShardStateException;
import conductor.org.elasticsearch.index.shard.IndexEventListener;
import conductor.org.elasticsearch.index.shard.IndexSearcherWrapper;
import conductor.org.elasticsearch.index.shard.IndexShardClosedException;
import conductor.org.elasticsearch.index.shard.IndexShardNotRecoveringException;
import conductor.org.elasticsearch.index.shard.IndexShardNotStartedException;
import conductor.org.elasticsearch.index.shard.IndexShardOperationPermits;
import conductor.org.elasticsearch.index.shard.IndexShardRecoveringException;
import conductor.org.elasticsearch.index.shard.IndexShardRelocatedException;
import conductor.org.elasticsearch.index.shard.IndexShardStartedException;
import conductor.org.elasticsearch.index.shard.IndexShardState;
import conductor.org.elasticsearch.index.shard.IndexingOperationListener;
import conductor.org.elasticsearch.index.shard.IndexingStats;
import conductor.org.elasticsearch.index.shard.InternalIndexingStats;
import conductor.org.elasticsearch.index.shard.LocalShardSnapshot;
import conductor.org.elasticsearch.index.shard.PrimaryReplicaSyncer;
import conductor.org.elasticsearch.index.shard.RefreshListeners;
import conductor.org.elasticsearch.index.shard.ReplicationGroup;
import conductor.org.elasticsearch.index.shard.SearchOperationListener;
import conductor.org.elasticsearch.index.shard.ShardId;
import conductor.org.elasticsearch.index.shard.ShardPath;
import conductor.org.elasticsearch.index.shard.ShardStateMetaData;
import conductor.org.elasticsearch.index.shard.StoreRecovery;
import conductor.org.elasticsearch.index.similarity.SimilarityService;
import conductor.org.elasticsearch.index.store.Store;
import conductor.org.elasticsearch.index.store.StoreFileMetaData;
import conductor.org.elasticsearch.index.store.StoreStats;
import conductor.org.elasticsearch.index.translog.Translog;
import conductor.org.elasticsearch.index.translog.TranslogConfig;
import conductor.org.elasticsearch.index.translog.TranslogStats;
import conductor.org.elasticsearch.index.warmer.ShardIndexWarmerService;
import conductor.org.elasticsearch.index.warmer.WarmerStats;
import conductor.org.elasticsearch.indices.IndexingMemoryController;
import conductor.org.elasticsearch.indices.IndicesService;
import conductor.org.elasticsearch.indices.TypeMissingException;
import conductor.org.elasticsearch.indices.breaker.CircuitBreakerService;
import conductor.org.elasticsearch.indices.cluster.IndicesClusterStateService;
import conductor.org.elasticsearch.indices.recovery.PeerRecoveryTargetService;
import conductor.org.elasticsearch.indices.recovery.RecoveryFailedException;
import conductor.org.elasticsearch.indices.recovery.RecoveryState;
import conductor.org.elasticsearch.repositories.RepositoriesService;
import conductor.org.elasticsearch.repositories.Repository;
import conductor.org.elasticsearch.rest.RestStatus;
import conductor.org.elasticsearch.search.suggest.completion.CompletionStats;
import conductor.org.elasticsearch.threadpool.ThreadPool;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.nio.channels.ClosedByInterruptException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class IndexShard
extends AbstractIndexShardComponent
implements IndicesClusterStateService.Shard {
    private final ThreadPool threadPool;
    private final MapperService mapperService;
    private final IndexCache indexCache;
    private final Store store;
    private final InternalIndexingStats internalIndexingStats;
    private final ShardSearchStats searchStats = new ShardSearchStats();
    private final ShardGetService getService;
    private final ShardIndexWarmerService shardWarmerService;
    private final ShardRequestCache requestCacheStats;
    private final ShardFieldData shardFieldData;
    private final ShardBitsetFilterCache shardBitsetFilterCache;
    private final Object mutex = new Object();
    private final String checkIndexOnStartup;
    private final CodecService codecService;
    private final Engine.Warmer warmer;
    private final SimilarityService similarityService;
    private final TranslogConfig translogConfig;
    private final IndexEventListener indexEventListener;
    private final QueryCachingPolicy cachingPolicy;
    private final Supplier<Sort> indexSortSupplier;
    final CircuitBreakerService circuitBreakerService;
    private final SearchOperationListener searchOperationListener;
    private final GlobalCheckpointListeners globalCheckpointListeners;
    private final ReplicationTracker replicationTracker;
    protected volatile ShardRouting shardRouting;
    protected volatile IndexShardState state;
    protected volatile long pendingPrimaryTerm;
    protected volatile long operationPrimaryTerm;
    protected final AtomicReference<Engine> currentEngineReference = new AtomicReference();
    final EngineFactory engineFactory;
    private final IndexingOperationListener indexingOperationListeners;
    private final Runnable globalCheckpointSyncer;
    @Nullable
    private RecoveryState recoveryState;
    private final RecoveryStats recoveryStats = new RecoveryStats();
    private final MeanMetric refreshMetric = new MeanMetric();
    private final MeanMetric flushMetric = new MeanMetric();
    private final CounterMetric periodicFlushMetric = new CounterMetric();
    private final ShardEventListener shardEventListener = new ShardEventListener();
    private final ShardPath path;
    private final IndexShardOperationPermits indexShardOperationPermits;
    private static final EnumSet<IndexShardState> readAllowedStates = EnumSet.of(IndexShardState.STARTED, IndexShardState.POST_RECOVERY);
    private static final EnumSet<IndexShardState> writeAllowedStates = EnumSet.of(IndexShardState.RECOVERING, IndexShardState.POST_RECOVERY, IndexShardState.STARTED);
    private final IndexSearcherWrapper searcherWrapper;
    private final AtomicBoolean active = new AtomicBoolean();
    private final RefreshListeners refreshListeners;
    private final AtomicBoolean primaryReplicaResyncInProgress = new AtomicBoolean();
    private final AsyncIOProcessor<Translog.Location> translogSyncProcessor = new AsyncIOProcessor<Translog.Location>(this.logger, 1024){

        @Override
        protected void write(List<Tuple<Translog.Location, Consumer<Exception>>> candidates) throws IOException {
            try {
                IndexShard.this.getEngine().ensureTranslogSynced(candidates.stream().map(Tuple::v1));
            }
            catch (AlreadyClosedException alreadyClosedException) {
            }
            catch (IOException ex) {
                IndexShard.this.logger.debug("failed to sync translog", (Throwable)ex);
                throw ex;
            }
        }
    };
    private final AtomicBoolean flushOrRollRunning = new AtomicBoolean();

    Runnable getGlobalCheckpointSyncer() {
        return this.globalCheckpointSyncer;
    }

    public IndexShard(ShardRouting shardRouting, IndexSettings indexSettings, ShardPath path, Store store, Supplier<Sort> indexSortSupplier, IndexCache indexCache, MapperService mapperService, SimilarityService similarityService, @Nullable EngineFactory engineFactory, IndexEventListener indexEventListener, IndexSearcherWrapper indexSearcherWrapper, ThreadPool threadPool, BigArrays bigArrays, Engine.Warmer warmer, List<SearchOperationListener> searchOperationListener, List<IndexingOperationListener> listeners, Runnable globalCheckpointSyncer, CircuitBreakerService circuitBreakerService) throws IOException {
        super(shardRouting.shardId(), indexSettings);
        assert (shardRouting.initializing());
        this.shardRouting = shardRouting;
        Settings settings = indexSettings.getSettings();
        this.codecService = new CodecService(mapperService, this.logger);
        this.warmer = warmer;
        this.similarityService = similarityService;
        Objects.requireNonNull(store, "Store must be provided to the index shard");
        this.engineFactory = Objects.requireNonNull(engineFactory);
        this.store = store;
        this.indexSortSupplier = indexSortSupplier;
        this.indexEventListener = indexEventListener;
        this.threadPool = threadPool;
        this.mapperService = mapperService;
        this.indexCache = indexCache;
        this.internalIndexingStats = new InternalIndexingStats();
        ArrayList<IndexingOperationListener> listenersList = new ArrayList<IndexingOperationListener>(listeners);
        listenersList.add(this.internalIndexingStats);
        this.indexingOperationListeners = new IndexingOperationListener.CompositeListener(listenersList, this.logger);
        this.globalCheckpointSyncer = globalCheckpointSyncer;
        ArrayList<SearchOperationListener> searchListenersList = new ArrayList<SearchOperationListener>(searchOperationListener);
        searchListenersList.add(this.searchStats);
        this.searchOperationListener = new SearchOperationListener.CompositeListener(searchListenersList, this.logger);
        this.getService = new ShardGetService(indexSettings, this, mapperService);
        this.shardWarmerService = new ShardIndexWarmerService(this.shardId, indexSettings);
        this.requestCacheStats = new ShardRequestCache();
        this.shardFieldData = new ShardFieldData();
        this.shardBitsetFilterCache = new ShardBitsetFilterCache(this.shardId, indexSettings);
        this.state = IndexShardState.CREATED;
        this.path = path;
        this.circuitBreakerService = circuitBreakerService;
        this.logger.debug("state: [CREATED]");
        this.checkIndexOnStartup = indexSettings.getValue(IndexSettings.INDEX_CHECK_ON_STARTUP);
        if ("fix".equals(this.checkIndexOnStartup)) {
            this.deprecationLogger.deprecated("Setting [index.shard.check_on_startup] is set to deprecated value [fix], which has no effect and will not be accepted in future", new Object[0]);
        }
        this.translogConfig = new TranslogConfig(this.shardId, this.shardPath().resolveTranslog(), indexSettings, bigArrays);
        String aId = shardRouting.allocationId().getId();
        this.globalCheckpointListeners = new GlobalCheckpointListeners(this.shardId, threadPool.executor("listener"), threadPool.scheduler(), this.logger);
        this.replicationTracker = new ReplicationTracker(this.shardId, aId, indexSettings, -2L, this.globalCheckpointListeners::globalCheckpointUpdated);
        this.cachingPolicy = IndexModule.INDEX_QUERY_CACHE_EVERYTHING_SETTING.get(settings) != false ? new QueryCachingPolicy(){

            @Override
            public void onUse(Query query) {
            }

            @Override
            public boolean shouldCache(Query query) {
                return true;
            }
        } : new UsageTrackingQueryCachingPolicy();
        this.indexShardOperationPermits = new IndexShardOperationPermits(this.shardId, this.logger, threadPool);
        this.searcherWrapper = indexSearcherWrapper;
        this.operationPrimaryTerm = this.pendingPrimaryTerm = indexSettings.getIndexMetaData().primaryTerm(this.shardId.id());
        this.refreshListeners = this.buildRefreshListeners();
        IndexShard.persistMetadata(path, indexSettings, shardRouting, null, this.logger);
    }

    public ThreadPool getThreadPool() {
        return this.threadPool;
    }

    public Store store() {
        return this.store;
    }

    public Sort getIndexSort() {
        return this.indexSortSupplier.get();
    }

    public ShardGetService getService() {
        return this.getService;
    }

    public ShardBitsetFilterCache shardBitsetFilterCache() {
        return this.shardBitsetFilterCache;
    }

    public MapperService mapperService() {
        return this.mapperService;
    }

    public SearchOperationListener getSearchOperationListener() {
        return this.searchOperationListener;
    }

    public ShardIndexWarmerService warmerService() {
        return this.shardWarmerService;
    }

    public ShardRequestCache requestCache() {
        return this.requestCacheStats;
    }

    public ShardFieldData fieldData() {
        return this.shardFieldData;
    }

    public long getPendingPrimaryTerm() {
        return this.pendingPrimaryTerm;
    }

    public long getOperationPrimaryTerm() {
        return this.operationPrimaryTerm;
    }

    @Override
    public ShardRouting routingEntry() {
        return this.shardRouting;
    }

    public QueryCachingPolicy getQueryCachingPolicy() {
        return this.cachingPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateShardState(ShardRouting newRouting, long newPrimaryTerm, BiConsumer<IndexShard, ActionListener<PrimaryReplicaSyncer.ResyncTask>> primaryReplicaSyncer, long applyingClusterStateVersion, Set<String> inSyncAllocationIds, IndexShardRoutingTable routingTable, Set<String> pre60AllocationIds) throws IOException {
        ShardRouting currentRouting;
        Object object = this.mutex;
        synchronized (object) {
            currentRouting = this.shardRouting;
            if (!newRouting.shardId().equals(this.shardId())) {
                throw new IllegalArgumentException("Trying to set a routing entry with shardId " + newRouting.shardId() + " on a shard with shardId " + this.shardId());
            }
            if (!(currentRouting == null || newRouting.isSameAllocation(currentRouting))) {
                throw new IllegalArgumentException("Trying to set a routing entry with a different allocation. Current " + currentRouting + ", new " + newRouting);
            }
            if (currentRouting != null && currentRouting.primary() && !newRouting.primary()) {
                throw new IllegalArgumentException("illegal state: trying to move shard from primary mode to replica mode. Current " + currentRouting + ", new " + newRouting);
            }
            if (newRouting.primary()) {
                this.replicationTracker.updateFromMaster(applyingClusterStateVersion, inSyncAllocationIds, routingTable, pre60AllocationIds);
            }
            if (this.state == IndexShardState.POST_RECOVERY && newRouting.active()) {
                assert (!currentRouting.active()) : "we are in POST_RECOVERY, but our shard routing is active " + currentRouting;
                assert (!currentRouting.isRelocationTarget() || !currentRouting.primary() || this.recoveryState.getSourceNode().getVersion().before(Version.V_6_0_0_alpha1) || this.replicationTracker.isPrimaryMode()) : "a primary relocation is completed by the master, but primary mode is not active " + currentRouting;
                this.changeState(IndexShardState.STARTED, "global state is [" + (Object)((Object)newRouting.state()) + "]");
            } else if (currentRouting.primary() && currentRouting.relocating() && this.replicationTracker.isRelocated() && (!newRouting.relocating() || !newRouting.equalsIgnoringMetaData(currentRouting))) {
                throw new IndexShardRelocatedException(this.shardId(), "Shard is marked as relocated, cannot safely move to state " + (Object)((Object)newRouting.state()));
            }
            assert (!newRouting.active() || this.state == IndexShardState.STARTED || this.state == IndexShardState.CLOSED) : "routing is active, but local shard state isn't. routing: " + newRouting + ", local state: " + (Object)((Object)this.state);
            IndexShard.persistMetadata(this.path, this.indexSettings, newRouting, currentRouting, this.logger);
            CountDownLatch shardStateUpdated = new CountDownLatch(1);
            if (newRouting.primary()) {
                if (newPrimaryTerm == this.pendingPrimaryTerm) {
                    if (currentRouting.initializing() && newRouting.active()) {
                        if (!currentRouting.isRelocationTarget()) {
                            this.replicationTracker.activatePrimaryMode(this.getLocalCheckpoint());
                        } else if (this.recoveryState.getSourceNode().getVersion().before(Version.V_6_0_0_alpha1)) {
                            this.replicationTracker.activatePrimaryMode(this.getLocalCheckpoint());
                            this.getEngine().flush(false, true);
                            if (this.getMaxSeqNoOfUpdatesOrDeletes() == -2L) {
                                assert (this.indexSettings.getIndexVersionCreated().before(Version.V_6_5_0));
                                this.getEngine().advanceMaxSeqNoOfUpdatesOrDeletes(this.seqNoStats().getMaxSeqNo());
                            }
                        }
                    }
                } else {
                    assert (!currentRouting.primary()) : "term is only increased as part of primary promotion";
                    assert (!newRouting.initializing()) : "a started primary shard should never update its term; shard " + newRouting + ", current term [" + this.pendingPrimaryTerm + "], new term [" + newPrimaryTerm + "]";
                    assert (newPrimaryTerm > this.pendingPrimaryTerm) : "primary terms can only go up; current term [" + this.pendingPrimaryTerm + "], new term [" + newPrimaryTerm + "]";
                    boolean resyncStarted = this.primaryReplicaResyncInProgress.compareAndSet(false, true);
                    if (!resyncStarted) {
                        throw new IllegalStateException("cannot start resync while it's already in progress");
                    }
                    this.bumpPrimaryTerm(newPrimaryTerm, () -> {
                        shardStateUpdated.await();
                        assert (this.pendingPrimaryTerm == newPrimaryTerm) : "shard term changed on primary. expected [" + newPrimaryTerm + "] but was [" + this.pendingPrimaryTerm + "], current routing: " + currentRouting + ", new routing: " + newRouting;
                        assert (this.operationPrimaryTerm == newPrimaryTerm);
                        try {
                            this.replicationTracker.activatePrimaryMode(this.getLocalCheckpoint());
                            Engine engine = this.getEngine();
                            if (this.getMaxSeqNoOfUpdatesOrDeletes() == -2L) {
                                assert (this.indexSettings.getIndexVersionCreated().before(Version.V_6_5_0));
                                engine.advanceMaxSeqNoOfUpdatesOrDeletes(this.seqNoStats().getMaxSeqNo());
                            }
                            engine.restoreLocalHistoryFromTranslog((resettingEngine, snapshot) -> this.runTranslogRecovery(resettingEngine, snapshot, Engine.Operation.Origin.LOCAL_RESET, () -> {}));
                            if (this.indexSettings.getIndexVersionCreated().onOrBefore(Version.V_6_0_0_alpha1)) {
                                engine.flush(false, true);
                            }
                            engine.rollTranslogGeneration();
                            engine.fillSeqNoGaps(newPrimaryTerm);
                            this.replicationTracker.updateLocalCheckpoint(currentRouting.allocationId().getId(), this.getLocalCheckpoint());
                            primaryReplicaSyncer.accept(this, new ActionListener<PrimaryReplicaSyncer.ResyncTask>(){

                                @Override
                                public void onResponse(PrimaryReplicaSyncer.ResyncTask resyncTask) {
                                    IndexShard.this.logger.info("primary-replica resync completed with {} operations", (Object)resyncTask.getResyncedOperations());
                                    boolean resyncCompleted = IndexShard.this.primaryReplicaResyncInProgress.compareAndSet(true, false);
                                    assert (resyncCompleted) : "primary-replica resync finished but was not started";
                                }

                                @Override
                                public void onFailure(Exception e) {
                                    boolean resyncCompleted = IndexShard.this.primaryReplicaResyncInProgress.compareAndSet(true, false);
                                    assert (resyncCompleted) : "primary-replica resync finished but was not started";
                                    if (IndexShard.this.state != IndexShardState.CLOSED) {
                                        IndexShard.this.failShard("exception during primary-replica resync", e);
                                    }
                                }
                            });
                        }
                        catch (AlreadyClosedException alreadyClosedException) {
                            // empty catch block
                        }
                    });
                }
            }
            this.shardRouting = newRouting;
            assert (!this.shardRouting.primary() || !this.shardRouting.started() || this.indexShardOperationPermits.isBlocked() || this.replicationTracker.isPrimaryMode()) : "a started primary with non-pending operation term must be in primary mode " + this.shardRouting;
            shardStateUpdated.countDown();
        }
        if (currentRouting != null && !currentRouting.active() && newRouting.active()) {
            this.indexEventListener.afterIndexShardStarted(this);
        }
        if (!newRouting.equals(currentRouting)) {
            this.indexEventListener.shardRoutingChanged(this, currentRouting, newRouting);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexShardState markAsRecovering(String reason, RecoveryState recoveryState) throws IndexShardStartedException, IndexShardRelocatedException, IndexShardRecoveringException, IndexShardClosedException {
        Object object = this.mutex;
        synchronized (object) {
            if (this.state == IndexShardState.CLOSED) {
                throw new IndexShardClosedException(this.shardId);
            }
            if (this.state == IndexShardState.STARTED) {
                throw new IndexShardStartedException(this.shardId);
            }
            if (this.state == IndexShardState.RECOVERING) {
                throw new IndexShardRecoveringException(this.shardId);
            }
            if (this.state == IndexShardState.POST_RECOVERY) {
                throw new IndexShardRecoveringException(this.shardId);
            }
            this.recoveryState = recoveryState;
            return this.changeState(IndexShardState.RECOVERING, reason);
        }
    }

    public void relocated(Consumer<ReplicationTracker.PrimaryContext> consumer) throws IllegalIndexShardStateException, InterruptedException {
        assert (this.shardRouting.primary()) : "only primaries can be marked as relocated: " + this.shardRouting;
        try {
            this.indexShardOperationPermits.blockOperations(30L, TimeUnit.MINUTES, () -> {
                assert (this.indexShardOperationPermits.getActiveOperationsCount() == 0) : "in-flight operations in progress while moving shard state to relocated";
                this.verifyRelocatingState();
                ReplicationTracker.PrimaryContext primaryContext = this.replicationTracker.startRelocationHandoff();
                try {
                    consumer.accept(primaryContext);
                    Object object = this.mutex;
                    synchronized (object) {
                        this.verifyRelocatingState();
                        this.replicationTracker.completeRelocationHandoff();
                    }
                }
                catch (Exception e) {
                    try {
                        this.replicationTracker.abortRelocationHandoff();
                    }
                    catch (Exception inner) {
                        e.addSuppressed(inner);
                    }
                    throw e;
                }
            });
        }
        catch (TimeoutException e) {
            this.logger.warn("timed out waiting for relocation hand-off to complete");
            this.failShard("timed out waiting for relocation hand-off to complete", null);
            throw new IndexShardClosedException(this.shardId(), "timed out waiting for relocation hand-off to complete");
        }
    }

    private void verifyRelocatingState() {
        if (this.state != IndexShardState.STARTED) {
            throw new IndexShardNotStartedException(this.shardId, this.state);
        }
        if (!this.shardRouting.relocating()) {
            throw new IllegalIndexShardStateException(this.shardId, IndexShardState.STARTED, ": shard is no longer relocating " + this.shardRouting, new Object[0]);
        }
        if (this.primaryReplicaResyncInProgress.get()) {
            throw new IllegalIndexShardStateException(this.shardId, IndexShardState.STARTED, ": primary relocation is forbidden while primary-replica resync is in progress " + this.shardRouting, new Object[0]);
        }
    }

    @Override
    public IndexShardState state() {
        return this.state;
    }

    private IndexShardState changeState(IndexShardState newState, String reason) {
        assert (Thread.holdsLock(this.mutex));
        this.logger.debug("state: [{}]->[{}], reason [{}]", (Object)this.state, (Object)newState, (Object)reason);
        IndexShardState previousState = this.state;
        this.state = newState;
        this.indexEventListener.indexShardStateChanged(this, previousState, newState, reason);
        return previousState;
    }

    public Engine.IndexResult applyIndexOperationOnPrimary(long version, VersionType versionType, SourceToParse sourceToParse, long autoGeneratedTimestamp, boolean isRetry) throws IOException {
        return this.applyIndexOperation(-2L, this.operationPrimaryTerm, version, versionType, autoGeneratedTimestamp, isRetry, Engine.Operation.Origin.PRIMARY, sourceToParse);
    }

    public Engine.IndexResult applyIndexOperationOnReplica(long seqNo, long version, VersionType versionType, long autoGeneratedTimeStamp, boolean isRetry, SourceToParse sourceToParse) throws IOException {
        return this.applyIndexOperation(seqNo, this.operationPrimaryTerm, version, versionType, autoGeneratedTimeStamp, isRetry, Engine.Operation.Origin.REPLICA, sourceToParse);
    }

    private Engine.IndexResult applyIndexOperation(long seqNo, long opPrimaryTerm, long version, VersionType versionType, long autoGeneratedTimeStamp, boolean isRetry, Engine.Operation.Origin origin, SourceToParse sourceToParse) throws IOException {
        Engine.Index operation;
        assert (opPrimaryTerm <= this.operationPrimaryTerm) : "op term [ " + opPrimaryTerm + " ] > shard term [" + this.operationPrimaryTerm + "]";
        assert (versionType.validateVersionForWrites(version));
        this.ensureWriteAllowed(origin);
        try {
            operation = IndexShard.prepareIndex(this.docMapper(sourceToParse.type()), this.indexSettings.getIndexVersionCreated(), sourceToParse, seqNo, opPrimaryTerm, version, versionType, origin, autoGeneratedTimeStamp, isRetry);
            Mapping update = operation.parsedDoc().dynamicMappingsUpdate();
            if (update != null) {
                return new Engine.IndexResult(update);
            }
        }
        catch (Exception e) {
            this.verifyNotClosed(e);
            return new Engine.IndexResult(e, version, opPrimaryTerm, seqNo);
        }
        return this.index(this.getEngine(), operation);
    }

    public static Engine.Index prepareIndex(DocumentMapperForType docMapper, Version indexCreatedVersion, SourceToParse source, long seqNo, long primaryTerm, long version, VersionType versionType, Engine.Operation.Origin origin, long autoGeneratedIdTimestamp, boolean isRetry) {
        long startTime = System.nanoTime();
        ParsedDocument doc = docMapper.getDocumentMapper().parse(source);
        if (docMapper.getMapping() != null) {
            doc.addDynamicMappingsUpdate(docMapper.getMapping());
        }
        Term uid = indexCreatedVersion.onOrAfter(Version.V_6_0_0_beta1) ? new Term("_id", Uid.encodeId(doc.id())) : (docMapper.getDocumentMapper().idFieldMapper().fieldType().indexOptions() != IndexOptions.NONE ? new Term("_id", doc.id()) : new Term("_uid", Uid.createUidAsBytes(doc.type(), doc.id())));
        return new Engine.Index(uid, doc, seqNo, primaryTerm, version, versionType, origin, startTime, autoGeneratedIdTimestamp, isRetry);
    }

    private Engine.IndexResult index(Engine engine, Engine.Index index) throws IOException {
        Engine.IndexResult result;
        this.active.set(true);
        index = this.indexingOperationListeners.preIndex(this.shardId, index);
        try {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("index [{}][{}] (seq# [{}])", (Object)index.type(), (Object)index.id(), (Object)index.seqNo());
            }
            result = engine.index(index);
        }
        catch (Exception e) {
            this.indexingOperationListeners.postIndex(this.shardId, index, e);
            throw e;
        }
        this.indexingOperationListeners.postIndex(this.shardId, index, result);
        return result;
    }

    public Engine.NoOpResult markSeqNoAsNoop(long seqNo, String reason) throws IOException {
        return this.markSeqNoAsNoop(seqNo, this.operationPrimaryTerm, reason, Engine.Operation.Origin.REPLICA);
    }

    private Engine.NoOpResult markSeqNoAsNoop(long seqNo, long opPrimaryTerm, String reason, Engine.Operation.Origin origin) throws IOException {
        assert (opPrimaryTerm <= this.operationPrimaryTerm) : "op term [ " + opPrimaryTerm + " ] > shard term [" + this.operationPrimaryTerm + "]";
        long startTime = System.nanoTime();
        this.ensureWriteAllowed(origin);
        Engine.NoOp noOp = new Engine.NoOp(seqNo, opPrimaryTerm, origin, startTime, reason);
        return this.noOp(this.getEngine(), noOp);
    }

    private Engine.NoOpResult noOp(Engine engine, Engine.NoOp noOp) {
        this.active.set(true);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("noop (seq# [{}])", (Object)noOp.seqNo());
        }
        return engine.noOp(noOp);
    }

    public Engine.IndexResult getFailedIndexResult(Exception e, long version) {
        return new Engine.IndexResult(e, version, this.operationPrimaryTerm);
    }

    public Engine.DeleteResult getFailedDeleteResult(Exception e, long version) {
        return new Engine.DeleteResult(e, version, this.operationPrimaryTerm);
    }

    public Engine.DeleteResult applyDeleteOperationOnPrimary(long version, String type, String id, VersionType versionType) throws IOException {
        return this.applyDeleteOperation(-2L, this.operationPrimaryTerm, version, type, id, versionType, Engine.Operation.Origin.PRIMARY);
    }

    public Engine.DeleteResult applyDeleteOperationOnReplica(long seqNo, long version, String type, String id, VersionType versionType) throws IOException {
        return this.applyDeleteOperation(seqNo, this.operationPrimaryTerm, version, type, id, versionType, Engine.Operation.Origin.REPLICA);
    }

    private Engine.DeleteResult applyDeleteOperation(long seqNo, long opPrimaryTerm, long version, String type, String id, VersionType versionType, Engine.Operation.Origin origin) throws IOException {
        assert (opPrimaryTerm <= this.operationPrimaryTerm) : "op term [ " + opPrimaryTerm + " ] > shard term [" + this.operationPrimaryTerm + "]";
        assert (versionType.validateVersionForWrites(version));
        this.ensureWriteAllowed(origin);
        if (this.indexSettings().isSingleType()) {
            try {
                Mapping update = this.docMapper(type).getMapping();
                if (update != null) {
                    return new Engine.DeleteResult(update);
                }
            }
            catch (MapperParsingException | TypeMissingException | IllegalArgumentException e) {
                return new Engine.DeleteResult(e, version, this.operationPrimaryTerm, seqNo, false);
            }
        }
        Term uid = this.extractUidForDelete(type, id);
        Engine.Delete delete = IndexShard.prepareDelete(type, id, uid, seqNo, opPrimaryTerm, version, versionType, origin);
        return this.delete(this.getEngine(), delete);
    }

    private static Engine.Delete prepareDelete(String type, String id, Term uid, long seqNo, long primaryTerm, long version, VersionType versionType, Engine.Operation.Origin origin) {
        long startTime = System.nanoTime();
        return new Engine.Delete(type, id, uid, seqNo, primaryTerm, version, versionType, origin, startTime);
    }

    private Term extractUidForDelete(String type, String id) {
        if (this.indexSettings.getIndexVersionCreated().onOrAfter(Version.V_6_0_0_beta1)) {
            assert (this.indexSettings.isSingleType());
            BytesRef idBytes = Uid.encodeId(id);
            return new Term("_id", idBytes);
        }
        if (this.indexSettings.isSingleType()) {
            return new Term("_id", id);
        }
        return new Term("_uid", Uid.createUidAsBytes(type, id));
    }

    private Engine.DeleteResult delete(Engine engine, Engine.Delete delete) throws IOException {
        Engine.DeleteResult result;
        this.active.set(true);
        delete = this.indexingOperationListeners.preDelete(this.shardId, delete);
        try {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("delete [{}] (seq no [{}])", (Object)delete.uid().text(), (Object)delete.seqNo());
            }
            result = engine.delete(delete);
        }
        catch (Exception e) {
            this.indexingOperationListeners.postDelete(this.shardId, delete, e);
            throw e;
        }
        this.indexingOperationListeners.postDelete(this.shardId, delete, result);
        return result;
    }

    public Engine.GetResult get(Engine.Get get) {
        this.readAllowed();
        return this.getEngine().get(get, this::acquireSearcher);
    }

    public void refresh(String source) {
        this.verifyNotClosed();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("refresh with source [{}]", (Object)source);
        }
        this.getEngine().refresh(source);
    }

    public long getWritingBytes() {
        Engine engine = this.getEngineOrNull();
        if (engine == null) {
            return 0L;
        }
        return engine.getWritingBytes();
    }

    public RefreshStats refreshStats() {
        int listeners = this.refreshListeners.pendingCount();
        return new RefreshStats(this.refreshMetric.count(), TimeUnit.NANOSECONDS.toMillis(this.refreshMetric.sum()), listeners);
    }

    public FlushStats flushStats() {
        return new FlushStats(this.flushMetric.count(), this.periodicFlushMetric.count(), TimeUnit.NANOSECONDS.toMillis(this.flushMetric.sum()));
    }

    public DocsStats docStats() {
        this.readAllowed();
        return this.getEngine().docStats();
    }

    public CommitStats commitStats() {
        return this.getEngine().commitStats();
    }

    public SeqNoStats seqNoStats() {
        return this.getEngine().getSeqNoStats(this.replicationTracker.getGlobalCheckpoint());
    }

    public IndexingStats indexingStats(String ... types) {
        long throttleTimeInMillis;
        boolean throttled;
        Engine engine = this.getEngineOrNull();
        if (engine == null) {
            throttled = false;
            throttleTimeInMillis = 0L;
        } else {
            throttled = engine.isThrottled();
            throttleTimeInMillis = engine.getIndexThrottleTimeInMillis();
        }
        return this.internalIndexingStats.stats(throttled, throttleTimeInMillis, types);
    }

    public SearchStats searchStats(String ... groups) {
        return this.searchStats.stats(groups);
    }

    public GetStats getStats() {
        return this.getService.stats();
    }

    public StoreStats storeStats() {
        try {
            return this.store.stats();
        }
        catch (IOException e) {
            this.failShard("Failing shard because of exception during storeStats", e);
            throw new ElasticsearchException("io exception while building 'store stats'", (Throwable)e, new Object[0]);
        }
    }

    public MergeStats mergeStats() {
        Engine engine = this.getEngineOrNull();
        if (engine == null) {
            return new MergeStats();
        }
        return engine.getMergeStats();
    }

    public SegmentsStats segmentStats(boolean includeSegmentFileSizes) {
        SegmentsStats segmentsStats = this.getEngine().segmentsStats(includeSegmentFileSizes);
        segmentsStats.addBitsetMemoryInBytes(this.shardBitsetFilterCache.getMemorySizeInBytes());
        return segmentsStats;
    }

    public WarmerStats warmerStats() {
        return this.shardWarmerService.stats();
    }

    public FieldDataStats fieldDataStats(String ... fields) {
        return this.shardFieldData.stats(fields);
    }

    public TranslogStats translogStats() {
        return this.getEngine().getTranslogStats();
    }

    public CompletionStats completionStats(String ... fields) {
        this.readAllowed();
        try {
            CompletionStats stats = this.getEngine().completionStats(fields);
            return stats;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Engine.SyncedFlushResult syncFlush(String syncId, Engine.CommitId expectedCommitId) {
        this.verifyNotClosed();
        this.logger.trace("trying to sync flush. sync id [{}]. expected commit id [{}]]", (Object)syncId, (Object)expectedCommitId);
        Engine engine = this.getEngine();
        if (engine.isRecovering()) {
            throw new IllegalIndexShardStateException(this.shardId(), this.state, "syncFlush is only allowed if the engine is not recovery from translog", new Object[0]);
        }
        return engine.syncFlush(syncId, expectedCommitId);
    }

    public Engine.CommitId flush(FlushRequest request) {
        boolean waitIfOngoing = request.waitIfOngoing();
        boolean force = request.force();
        this.logger.trace("flush with {}", (Object)request);
        this.verifyNotClosed();
        Engine engine = this.getEngine();
        if (engine.isRecovering()) {
            throw new IllegalIndexShardStateException(this.shardId(), this.state, "flush is only allowed if the engine is not recovery from translog", new Object[0]);
        }
        long time = System.nanoTime();
        Engine.CommitId commitId = engine.flush(force, waitIfOngoing);
        engine.refresh("flush");
        this.flushMetric.inc(System.nanoTime() - time);
        return commitId;
    }

    public void trimTranslog() {
        this.verifyNotClosed();
        Engine engine = this.getEngine();
        engine.trimUnreferencedTranslogFiles();
    }

    private void rollTranslogGeneration() {
        Engine engine = this.getEngine();
        engine.rollTranslogGeneration();
    }

    public void forceMerge(ForceMergeRequest forceMerge) throws IOException {
        this.verifyActive();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("force merge with {}", (Object)forceMerge);
        }
        Engine engine = this.getEngine();
        engine.forceMerge(forceMerge.flush(), forceMerge.maxNumSegments(), forceMerge.onlyExpungeDeletes(), false, false);
        if (forceMerge.flush()) {
            engine.refresh("force_merge");
        }
    }

    public conductor.org.apache.lucene.util.Version upgrade(UpgradeRequest upgrade) throws IOException {
        this.verifyActive();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("upgrade with {}", (Object)upgrade);
        }
        conductor.org.apache.lucene.util.Version previousVersion = this.minimumCompatibleVersion();
        Engine engine = this.getEngine();
        engine.forceMerge(true, Integer.MAX_VALUE, false, true, upgrade.upgradeOnlyAncientSegments());
        engine.refresh("upgrade");
        conductor.org.apache.lucene.util.Version version = this.minimumCompatibleVersion();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("upgraded segments for {} from version {} to version {}", (Object)this.shardId, (Object)previousVersion, (Object)version);
        }
        return version;
    }

    public conductor.org.apache.lucene.util.Version minimumCompatibleVersion() {
        conductor.org.apache.lucene.util.Version luceneVersion = null;
        for (Segment segment : this.getEngine().segments(false)) {
            if (luceneVersion != null && !luceneVersion.onOrAfter(segment.getVersion())) continue;
            luceneVersion = segment.getVersion();
        }
        return luceneVersion == null ? this.indexSettings.getIndexVersionCreated().luceneVersion : luceneVersion;
    }

    public Engine.IndexCommitRef acquireLastIndexCommit(boolean flushFirst) throws EngineException {
        IndexShardState state = this.state;
        if (state == IndexShardState.STARTED || state == IndexShardState.CLOSED) {
            return this.getEngine().acquireLastIndexCommit(flushFirst);
        }
        throw new IllegalIndexShardStateException(this.shardId, state, "snapshot is not allowed", new Object[0]);
    }

    public Engine.IndexCommitRef acquireSafeIndexCommit() throws EngineException {
        IndexShardState state = this.state;
        if (state == IndexShardState.STARTED || state == IndexShardState.CLOSED) {
            return this.getEngine().acquireSafeIndexCommit();
        }
        throw new IllegalIndexShardStateException(this.shardId, state, "snapshot is not allowed", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Store.MetadataSnapshot snapshotStoreMetadata() throws IOException {
        Engine engine;
        Object object;
        Engine.IndexCommitRef indexCommit;
        block6: {
            Store.MetadataSnapshot metadataSnapshot;
            indexCommit = null;
            this.store.incRef();
            try {
                object = this.mutex;
                // MONITORENTER : object
                engine = this.getEngineOrNull();
                if (engine != null) break block6;
                metadataSnapshot = this.store.getMetadata(null, true);
                // MONITOREXIT : object
                this.store.decRef();
            }
            catch (Throwable throwable) {
                this.store.decRef();
                IOUtils.close(indexCommit);
                throw throwable;
            }
            IOUtils.close(indexCommit);
            return metadataSnapshot;
        }
        // MONITOREXIT : object
        indexCommit = engine.acquireLastIndexCommit(false);
        object = this.store.getMetadata(indexCommit.getIndexCommit());
        this.store.decRef();
        IOUtils.close(indexCommit);
        return object;
    }

    public void failShard(String reason, @Nullable Exception e) {
        this.getEngine().failEngine(reason, e);
    }

    public Engine.Searcher acquireSearcher(String source) {
        return this.acquireSearcher(source, Engine.SearcherScope.EXTERNAL);
    }

    private Engine.Searcher acquireSearcher(String source, Engine.SearcherScope scope) {
        Engine.Searcher searcher;
        block6: {
            this.readAllowed();
            Engine engine = this.getEngine();
            Engine.Searcher searcher2 = engine.acquireSearcher(source, scope);
            boolean success = false;
            try {
                Engine.Searcher wrappedSearcher;
                Engine.Searcher searcher3 = wrappedSearcher = this.searcherWrapper == null ? searcher2 : this.searcherWrapper.wrap(searcher2);
                assert (wrappedSearcher != null);
                success = true;
                searcher = wrappedSearcher;
                if (success) break block6;
            }
            catch (IOException ex) {
                try {
                    throw new ElasticsearchException("failed to wrap searcher", (Throwable)ex, new Object[0]);
                }
                catch (Throwable throwable) {
                    if (!success) {
                        Releasables.close(success, searcher2);
                    }
                    throw throwable;
                }
            }
            Releasables.close(success, searcher2);
        }
        return searcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(String reason, boolean flushEngine) throws IOException {
        Object object = this.mutex;
        synchronized (object) {
            try {
                this.changeState(IndexShardState.CLOSED, reason);
            }
            catch (Throwable throwable) {
                Engine engine = this.currentEngineReference.getAndSet(null);
                try {
                    if (engine != null && flushEngine) {
                        engine.flushAndClose();
                    }
                }
                catch (Throwable throwable2) {
                    IOUtils.close(engine, this.globalCheckpointListeners, this.refreshListeners);
                    this.indexShardOperationPermits.close();
                    throw throwable2;
                }
                IOUtils.close(engine, this.globalCheckpointListeners, this.refreshListeners);
                this.indexShardOperationPermits.close();
                throw throwable;
            }
            Engine engine = this.currentEngineReference.getAndSet(null);
            try {
                if (engine != null && flushEngine) {
                    engine.flushAndClose();
                }
            }
            catch (Throwable throwable) {
                IOUtils.close(engine, this.globalCheckpointListeners, this.refreshListeners);
                this.indexShardOperationPermits.close();
                throw throwable;
            }
            IOUtils.close(engine, this.globalCheckpointListeners, this.refreshListeners);
            this.indexShardOperationPermits.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexShard postRecovery(String reason) throws IndexShardStartedException, IndexShardRelocatedException, IndexShardClosedException {
        Object object = this.mutex;
        synchronized (object) {
            if (this.state == IndexShardState.CLOSED) {
                throw new IndexShardClosedException(this.shardId);
            }
            if (this.state == IndexShardState.STARTED) {
                throw new IndexShardStartedException(this.shardId);
            }
            this.getEngine().refresh("post_recovery");
            this.recoveryState.setStage(RecoveryState.Stage.DONE);
            this.changeState(IndexShardState.POST_RECOVERY, reason);
        }
        return this;
    }

    public void prepareForIndexRecovery() {
        if (this.state != IndexShardState.RECOVERING) {
            throw new IndexShardNotRecoveringException(this.shardId, this.state);
        }
        this.recoveryState.setStage(RecoveryState.Stage.INDEX);
        assert (this.currentEngineReference.get() == null);
    }

    public void trimOperationOfPreviousPrimaryTerms(long aboveSeqNo) {
        this.getEngine().trimOperationsFromTranslog(this.operationPrimaryTerm, aboveSeqNo);
    }

    public long getMaxSeenAutoIdTimestamp() {
        return this.getEngine().getMaxSeenAutoIdTimestamp();
    }

    public void updateMaxUnsafeAutoIdTimestamp(long maxSeenAutoIdTimestampFromPrimary) {
        this.getEngine().updateMaxUnsafeAutoIdTimestamp(maxSeenAutoIdTimestampFromPrimary);
    }

    public Engine.Result applyTranslogOperation(Translog.Operation operation, Engine.Operation.Origin origin) throws IOException {
        Engine.Result result;
        switch (operation.opType()) {
            case INDEX: {
                Translog.Index index = (Translog.Index)operation;
                result = this.applyIndexOperation(index.seqNo(), index.primaryTerm(), index.version(), index.versionType().versionTypeForReplicationAndRecovery(), index.getAutoGeneratedIdTimestamp(), true, origin, SourceToParse.source(this.shardId.getIndexName(), index.type(), index.id(), index.source(), XContentHelper.xContentType(index.source())).routing(index.routing()).parent(index.parent()));
                break;
            }
            case DELETE: {
                Translog.Delete delete = (Translog.Delete)operation;
                result = this.applyDeleteOperation(delete.seqNo(), delete.primaryTerm(), delete.version(), delete.type(), delete.id(), delete.versionType().versionTypeForReplicationAndRecovery(), origin);
                break;
            }
            case NO_OP: {
                Translog.NoOp noOp = (Translog.NoOp)operation;
                result = this.markSeqNoAsNoop(noOp.seqNo(), noOp.primaryTerm(), noOp.reason(), origin);
                break;
            }
            default: {
                throw new IllegalStateException("No operation defined for [" + operation + "]");
            }
        }
        return result;
    }

    int runTranslogRecovery(Engine engine, Translog.Snapshot snapshot, Engine.Operation.Origin origin, Runnable onOperationRecovered) throws IOException {
        Translog.Operation operation;
        int opsRecovered = 0;
        while ((operation = snapshot.next()) != null) {
            try {
                this.logger.trace("[translog] recover op {}", (Object)operation);
                Engine.Result result = this.applyTranslogOperation(operation, origin);
                switch (result.getResultType()) {
                    case FAILURE: {
                        throw result.getFailure();
                    }
                    case MAPPING_UPDATE_REQUIRED: {
                        throw new IllegalArgumentException("unexpected mapping update: " + result.getRequiredMappingUpdate());
                    }
                    case SUCCESS: {
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Unknown result type [" + (Object)((Object)result.getResultType()) + "]"));
                    }
                }
                ++opsRecovered;
                onOperationRecovered.run();
            }
            catch (Exception e) {
                if (ExceptionsHelper.status(e) == RestStatus.BAD_REQUEST) {
                    this.logger.info("ignoring recovery of a corrupt translog entry", (Throwable)e);
                    continue;
                }
                throw ExceptionsHelper.convertToRuntime(e);
            }
        }
        return opsRecovered;
    }

    public void openEngineAndRecoverFromTranslog() throws IOException {
        RecoveryState.Translog translogRecoveryStats = this.recoveryState.getTranslog();
        Engine.TranslogRecoveryRunner translogRecoveryRunner = (engine, snapshot) -> {
            translogRecoveryStats.totalOperations(snapshot.totalOperations());
            translogRecoveryStats.totalOperationsOnStart(snapshot.totalOperations());
            return this.runTranslogRecovery(engine, snapshot, Engine.Operation.Origin.LOCAL_TRANSLOG_RECOVERY, translogRecoveryStats::incrementRecoveredOperations);
        };
        this.innerOpenEngineAndTranslog();
        Engine engine2 = this.getEngine();
        engine2.initializeMaxSeqNoOfUpdatesOrDeletes();
        engine2.recoverFromTranslog(translogRecoveryRunner, Long.MAX_VALUE);
    }

    public void openEngineAndSkipTranslogRecovery() throws IOException {
        this.innerOpenEngineAndTranslog();
        this.getEngine().skipTranslogRecovery();
    }

    private void innerOpenEngineAndTranslog() throws IOException {
        if (this.state != IndexShardState.RECOVERING) {
            throw new IndexShardNotRecoveringException(this.shardId, this.state);
        }
        this.recoveryState.setStage(RecoveryState.Stage.VERIFY_INDEX);
        if (Booleans.isTrue(this.checkIndexOnStartup) || "checksum".equals(this.checkIndexOnStartup)) {
            try {
                this.checkIndex();
            }
            catch (IOException ex) {
                throw new RecoveryFailedException(this.recoveryState, "check index failed", (Throwable)ex);
            }
        }
        this.recoveryState.setStage(RecoveryState.Stage.TRANSLOG);
        EngineConfig config = this.newEngineConfig();
        config.setEnableGcDeletes(false);
        String translogUUID = this.store.readLastCommittedSegmentsInfo().getUserData().get("translog_uuid");
        long globalCheckpoint = Translog.readGlobalCheckpoint(this.translogConfig.getTranslogPath(), translogUUID);
        this.replicationTracker.updateGlobalCheckpointOnReplica(globalCheckpoint, "read from translog checkpoint");
        this.trimUnsafeCommits();
        this.createNewEngine(config);
        this.verifyNotClosed();
        this.active.set(true);
        this.assertSequenceNumbersInCommit();
        assert (this.recoveryState.getStage() == RecoveryState.Stage.TRANSLOG) : "TRANSLOG stage expected but was: " + (Object)((Object)this.recoveryState.getStage());
    }

    private void trimUnsafeCommits() throws IOException {
        assert (this.currentEngineReference.get() == null) : "engine is running";
        String translogUUID = this.store.readLastCommittedSegmentsInfo().getUserData().get("translog_uuid");
        long globalCheckpoint = Translog.readGlobalCheckpoint(this.translogConfig.getTranslogPath(), translogUUID);
        long minRetainedTranslogGen = Translog.readMinTranslogGeneration(this.translogConfig.getTranslogPath(), translogUUID);
        this.assertMaxUnsafeAutoIdInCommit();
        this.store.trimUnsafeCommits(globalCheckpoint, minRetainedTranslogGen, this.indexSettings.getIndexVersionCreated());
    }

    private boolean assertSequenceNumbersInCommit() throws IOException {
        Map<String, String> userData = SegmentInfos.readLatestCommit(this.store.directory()).getUserData();
        assert (userData.containsKey("local_checkpoint")) : "commit point doesn't contains a local checkpoint";
        assert (userData.containsKey("max_seq_no")) : "commit point doesn't contains a maximum sequence number";
        assert (userData.containsKey("history_uuid")) : "commit point doesn't contains a history uuid";
        assert (userData.get("history_uuid").equals(this.getHistoryUUID())) : "commit point history uuid [" + userData.get("history_uuid") + "] is different than engine [" + this.getHistoryUUID() + "]";
        return true;
    }

    private boolean assertMaxUnsafeAutoIdInCommit() throws IOException {
        Map<String, String> userData = SegmentInfos.readLatestCommit(this.store.directory()).getUserData();
        if (this.indexSettings.getIndexVersionCreated().onOrAfter(Version.V_5_5_0)) assert (userData.containsKey("max_unsafe_auto_id_timestamp")) : "opening index which was created post 5.5.0 but max_unsafe_auto_id_timestamp is not found in commit";
        return true;
    }

    protected void onNewEngine(Engine newEngine) {
        this.refreshListeners.setCurrentRefreshLocationSupplier(newEngine::getTranslogLastWriteLocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performRecoveryRestart() throws IOException {
        Object object = this.mutex;
        synchronized (object) {
            if (this.state != IndexShardState.RECOVERING) {
                throw new IndexShardNotRecoveringException(this.shardId, this.state);
            }
            assert (this.refreshListeners.pendingCount() == 0) : "we can't restart with pending listeners";
            Engine engine = this.currentEngineReference.getAndSet(null);
            IOUtils.close(engine);
            this.recoveryState().setStage(RecoveryState.Stage.INIT);
        }
    }

    public RecoveryStats recoveryStats() {
        return this.recoveryStats;
    }

    @Override
    public RecoveryState recoveryState() {
        return this.recoveryState;
    }

    public void finalizeRecovery() {
        this.recoveryState().setStage(RecoveryState.Stage.FINALIZE);
        Engine engine = this.getEngine();
        engine.refresh("recovery_finalization");
        engine.config().setEnableGcDeletes(true);
    }

    public boolean ignoreRecoveryAttempt() {
        IndexShardState state = this.state();
        return state == IndexShardState.POST_RECOVERY || state == IndexShardState.RECOVERING || state == IndexShardState.STARTED || state == IndexShardState.CLOSED;
    }

    public void readAllowed() throws IllegalIndexShardStateException {
        IndexShardState state = this.state;
        if (!readAllowedStates.contains((Object)state)) {
            throw new IllegalIndexShardStateException(this.shardId, state, "operations only allowed when shard state is one of " + readAllowedStates.toString(), new Object[0]);
        }
    }

    public boolean isReadAllowed() {
        return readAllowedStates.contains((Object)this.state);
    }

    private void ensureWriteAllowed(Engine.Operation.Origin origin) throws IllegalIndexShardStateException {
        IndexShardState state = this.state;
        if (origin.isRecovery()) {
            if (state != IndexShardState.RECOVERING) {
                throw new IllegalIndexShardStateException(this.shardId, state, "operation only allowed when recovering, origin [" + (Object)((Object)origin) + "]", new Object[0]);
            }
        } else {
            if (origin == Engine.Operation.Origin.PRIMARY) {
                assert (this.assertPrimaryMode());
            } else if (origin == Engine.Operation.Origin.REPLICA) {
                assert (this.assertReplicationTarget());
            } else {
                assert (origin == Engine.Operation.Origin.LOCAL_RESET);
                assert (this.getActiveOperationsCount() == 0) : "Ongoing writes [" + this.getActiveOperations() + "]";
            }
            if (!writeAllowedStates.contains((Object)state)) {
                throw new IllegalIndexShardStateException(this.shardId, state, "operation only allowed when shard state is one of " + writeAllowedStates + ", origin [" + (Object)((Object)origin) + "]", new Object[0]);
            }
        }
    }

    private boolean assertPrimaryMode() {
        assert (this.shardRouting.primary() && this.replicationTracker.isPrimaryMode()) : "shard " + this.shardRouting + " is not a primary shard in primary mode";
        return true;
    }

    private boolean assertReplicationTarget() {
        assert (!this.replicationTracker.isPrimaryMode()) : "shard " + this.shardRouting + " in primary mode cannot be a replication target";
        return true;
    }

    private void verifyNotClosed() throws IllegalIndexShardStateException {
        this.verifyNotClosed(null);
    }

    private void verifyNotClosed(Exception suppressed) throws IllegalIndexShardStateException {
        IndexShardState state = this.state;
        if (state == IndexShardState.CLOSED) {
            IndexShardClosedException exc = new IndexShardClosedException(this.shardId, "operation only allowed when not closed");
            if (suppressed != null) {
                exc.addSuppressed(suppressed);
            }
            throw exc;
        }
    }

    protected final void verifyActive() throws IllegalIndexShardStateException {
        IndexShardState state = this.state;
        if (state != IndexShardState.STARTED) {
            throw new IllegalIndexShardStateException(this.shardId, state, "operation only allowed when shard is active", new Object[0]);
        }
    }

    public long getIndexBufferRAMBytesUsed() {
        Engine engine = this.getEngineOrNull();
        if (engine == null) {
            return 0L;
        }
        try {
            return engine.getIndexBufferRAMBytesUsed();
        }
        catch (AlreadyClosedException ex) {
            return 0L;
        }
    }

    public void addShardFailureCallback(Consumer<ShardFailure> onShardFailure) {
        this.shardEventListener.delegates.add(onShardFailure);
    }

    public void checkIdle(long inactiveTimeNS) {
        boolean wasActive;
        Engine engineOrNull = this.getEngineOrNull();
        if (engineOrNull != null && System.nanoTime() - engineOrNull.getLastWriteNanos() >= inactiveTimeNS && (wasActive = this.active.getAndSet(false))) {
            this.logger.debug("shard is now inactive");
            try {
                this.indexEventListener.onShardInactive(this);
            }
            catch (Exception e) {
                this.logger.warn("failed to notify index event listener", (Throwable)e);
            }
        }
    }

    public boolean isActive() {
        return this.active.get();
    }

    public ShardPath shardPath() {
        return this.path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean recoverFromLocalShards(BiConsumer<String, MappingMetaData> mappingUpdateConsumer, List<IndexShard> localShards) throws IOException {
        assert (this.shardRouting.primary()) : "recover from local shards only makes sense if the shard is a primary shard";
        assert (this.recoveryState.getRecoverySource().getType() == RecoverySource.Type.LOCAL_SHARDS) : "invalid recovery type: " + this.recoveryState.getRecoverySource();
        ArrayList<LocalShardSnapshot> snapshots = new ArrayList<LocalShardSnapshot>();
        try {
            for (IndexShard shard : localShards) {
                snapshots.add(new LocalShardSnapshot(shard));
            }
            assert (this.shardRouting.primary()) : "recover from local shards only makes sense if the shard is a primary shard";
            StoreRecovery storeRecovery = new StoreRecovery(this.shardId, this.logger);
            boolean bl = storeRecovery.recoverFromLocalShards(mappingUpdateConsumer, this, snapshots);
            return bl;
        }
        finally {
            IOUtils.close(snapshots);
        }
    }

    public boolean recoverFromStore() {
        assert (this.shardRouting.primary()) : "recover from store only makes sense if the shard is a primary shard";
        assert (this.shardRouting.initializing()) : "can only start recovery on initializing shard";
        StoreRecovery storeRecovery = new StoreRecovery(this.shardId, this.logger);
        return storeRecovery.recoverFromStore(this);
    }

    public boolean restoreFromRepository(Repository repository) {
        assert (this.shardRouting.primary()) : "recover from store only makes sense if the shard is a primary shard";
        assert (this.recoveryState.getRecoverySource().getType() == RecoverySource.Type.SNAPSHOT) : "invalid recovery type: " + this.recoveryState.getRecoverySource();
        StoreRecovery storeRecovery = new StoreRecovery(this.shardId, this.logger);
        return storeRecovery.recoverFromRepository(this, repository);
    }

    boolean shouldPeriodicallyFlush() {
        Engine engine = this.getEngineOrNull();
        if (engine != null) {
            try {
                return engine.shouldPeriodicallyFlush();
            }
            catch (AlreadyClosedException alreadyClosedException) {
                // empty catch block
            }
        }
        return false;
    }

    boolean shouldRollTranslogGeneration() {
        Engine engine = this.getEngineOrNull();
        if (engine != null) {
            try {
                return engine.shouldRollTranslogGeneration();
            }
            catch (AlreadyClosedException alreadyClosedException) {
                // empty catch block
            }
        }
        return false;
    }

    public void onSettingsChanged() {
        Engine engineOrNull = this.getEngineOrNull();
        if (engineOrNull != null) {
            engineOrNull.onSettingsChanged();
        }
    }

    public Closeable acquireRetentionLockForPeerRecovery() {
        return this.getEngine().acquireRetentionLockForPeerRecovery();
    }

    public int estimateNumberOfHistoryOperations(String source, long startingSeqNo) throws IOException {
        return this.getEngine().estimateNumberOfHistoryOperations(source, this.mapperService, startingSeqNo);
    }

    public Translog.Snapshot getHistoryOperations(String source, long startingSeqNo) throws IOException {
        return this.getEngine().readHistoryOperations(source, this.mapperService, startingSeqNo);
    }

    public boolean hasCompleteHistoryOperations(String source, long startingSeqNo) throws IOException {
        return this.getEngine().hasCompleteOperationHistory(source, this.mapperService, startingSeqNo);
    }

    public Translog.Snapshot newChangesSnapshot(String source, long fromSeqNo, long toSeqNo, boolean requiredFullRange) throws IOException {
        return this.getEngine().newChangesSnapshot(source, this.mapperService, fromSeqNo, toSeqNo, requiredFullRange);
    }

    public List<Segment> segments(boolean verbose) {
        return this.getEngine().segments(verbose);
    }

    public void flushAndCloseEngine() throws IOException {
        this.getEngine().flushAndClose();
    }

    public String getHistoryUUID() {
        return this.getEngine().getHistoryUUID();
    }

    public IndexEventListener getIndexEventListener() {
        return this.indexEventListener;
    }

    public void activateThrottling() {
        try {
            this.getEngine().activateThrottling();
        }
        catch (AlreadyClosedException alreadyClosedException) {
            // empty catch block
        }
    }

    public void deactivateThrottling() {
        try {
            this.getEngine().deactivateThrottling();
        }
        catch (AlreadyClosedException alreadyClosedException) {
            // empty catch block
        }
    }

    private void handleRefreshException(Exception e) {
        if (!(e instanceof AlreadyClosedException)) {
            if (e instanceof RefreshFailedEngineException) {
                RefreshFailedEngineException rfee = (RefreshFailedEngineException)e;
                if (!(rfee.getCause() instanceof InterruptedException || rfee.getCause() instanceof ClosedByInterruptException || rfee.getCause() instanceof ThreadInterruptedException || this.state == IndexShardState.CLOSED)) {
                    this.logger.warn("Failed to perform engine refresh", (Throwable)e);
                }
            } else if (this.state != IndexShardState.CLOSED) {
                this.logger.warn("Failed to perform engine refresh", (Throwable)e);
            }
        }
    }

    public void writeIndexingBuffer() {
        try {
            Engine engine = this.getEngine();
            engine.writeIndexingBuffer();
        }
        catch (Exception e) {
            this.handleRefreshException(e);
        }
    }

    public void updateLocalCheckpointForShard(String allocationId, long checkpoint) {
        assert (this.assertPrimaryMode());
        this.verifyNotClosed();
        this.replicationTracker.updateLocalCheckpoint(allocationId, checkpoint);
    }

    public void updateGlobalCheckpointForShard(String allocationId, long globalCheckpoint) {
        assert (this.assertPrimaryMode());
        this.verifyNotClosed();
        this.replicationTracker.updateGlobalCheckpointForShard(allocationId, globalCheckpoint);
    }

    public void addGlobalCheckpointListener(long waitingForGlobalCheckpoint, GlobalCheckpointListeners.GlobalCheckpointListener listener, TimeValue timeout) {
        this.globalCheckpointListeners.add(waitingForGlobalCheckpoint, listener, timeout);
    }

    public void waitForOpsToComplete(long seqNo) throws InterruptedException {
        this.getEngine().waitForOpsToComplete(seqNo);
    }

    public void initiateTracking(String allocationId) {
        assert (this.assertPrimaryMode());
        this.replicationTracker.initiateTracking(allocationId);
    }

    public void markAllocationIdAsInSync(String allocationId, long localCheckpoint) throws InterruptedException {
        assert (this.assertPrimaryMode());
        this.replicationTracker.markAllocationIdAsInSync(allocationId, localCheckpoint);
    }

    public long getLocalCheckpoint() {
        return this.getEngine().getLocalCheckpoint();
    }

    public long getGlobalCheckpoint() {
        return this.replicationTracker.getGlobalCheckpoint();
    }

    public long getLastSyncedGlobalCheckpoint() {
        return this.getEngine().getLastSyncedGlobalCheckpoint();
    }

    public ObjectLongMap<String> getInSyncGlobalCheckpoints() {
        assert (this.assertPrimaryMode());
        this.verifyNotClosed();
        return this.replicationTracker.getInSyncGlobalCheckpoints();
    }

    public void maybeSyncGlobalCheckpoint(String reason) {
        this.verifyNotClosed();
        assert (this.shardRouting.primary()) : "only call maybeSyncGlobalCheckpoint on primary shard";
        if (!this.replicationTracker.isPrimaryMode()) {
            return;
        }
        assert (this.assertPrimaryMode());
        SeqNoStats stats = this.getEngine().getSeqNoStats(this.replicationTracker.getGlobalCheckpoint());
        if (stats.getMaxSeqNo() == stats.getGlobalCheckpoint()) {
            ObjectLongMap<String> globalCheckpoints = this.getInSyncGlobalCheckpoints();
            String allocationId = this.routingEntry().allocationId().getId();
            assert (globalCheckpoints.containsKey(allocationId));
            long globalCheckpoint = globalCheckpoints.get(allocationId);
            boolean syncNeeded = StreamSupport.stream(globalCheckpoints.values().spliterator(), false).anyMatch(v -> v.value < globalCheckpoint);
            if (syncNeeded) {
                this.logger.trace("syncing global checkpoint for [{}]", (Object)reason);
                this.globalCheckpointSyncer.run();
            }
        }
    }

    public ReplicationGroup getReplicationGroup() {
        assert (this.assertPrimaryMode());
        this.verifyNotClosed();
        return this.replicationTracker.getReplicationGroup();
    }

    public void updateGlobalCheckpointOnReplica(long globalCheckpoint, String reason) {
        assert (this.assertReplicationTarget());
        long localCheckpoint = this.getLocalCheckpoint();
        if (globalCheckpoint > localCheckpoint) {
            assert (this.state() != IndexShardState.POST_RECOVERY && this.state() != IndexShardState.STARTED) : "supposedly in-sync shard copy received a global checkpoint [" + globalCheckpoint + "] that is higher than its local checkpoint [" + localCheckpoint + "]";
            return;
        }
        this.replicationTracker.updateGlobalCheckpointOnReplica(globalCheckpoint, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activateWithPrimaryContext(ReplicationTracker.PrimaryContext primaryContext) {
        assert (this.shardRouting.primary() && this.shardRouting.isRelocationTarget()) : "only primary relocation target can update allocation IDs from primary context: " + this.shardRouting;
        assert (primaryContext.getCheckpointStates().containsKey(this.routingEntry().allocationId().getId()) && this.getLocalCheckpoint() == primaryContext.getCheckpointStates().get(this.routingEntry().allocationId().getId()).getLocalCheckpoint());
        Object object = this.mutex;
        synchronized (object) {
            this.replicationTracker.activateWithPrimaryContext(primaryContext);
            if (this.getMaxSeqNoOfUpdatesOrDeletes() == -2L) {
                assert (this.indexSettings.getIndexVersionCreated().before(Version.V_6_5_0));
                this.getEngine().advanceMaxSeqNoOfUpdatesOrDeletes(this.seqNoStats().getMaxSeqNo());
            }
        }
    }

    public boolean pendingInSync() {
        assert (this.assertPrimaryMode());
        return this.replicationTracker.pendingInSync();
    }

    public void noopUpdate(String type) {
        this.internalIndexingStats.noopUpdate(type);
    }

    void checkIndex() throws IOException {
        if (this.store.tryIncRef()) {
            try {
                this.doCheckIndex();
            }
            catch (IOException e) {
                this.store.markStoreCorrupted(e);
                throw e;
            }
            finally {
                this.store.decRef();
            }
        }
    }

    private void doCheckIndex() throws IOException {
        long timeNS = System.nanoTime();
        if (!Lucene.indexExists(this.store.directory())) {
            return;
        }
        BytesStreamOutput os = new BytesStreamOutput();
        PrintStream out = new PrintStream((OutputStream)os, false, StandardCharsets.UTF_8.name());
        if ("checksum".equals(this.checkIndexOnStartup)) {
            IOException corrupt = null;
            Store.MetadataSnapshot metadata = this.snapshotStoreMetadata();
            for (Map.Entry<String, StoreFileMetaData> entry : metadata.asMap().entrySet()) {
                try {
                    Store.checkIntegrity(entry.getValue(), this.store.directory());
                    out.println("checksum passed: " + entry.getKey());
                }
                catch (IOException exc) {
                    out.println("checksum failed: " + entry.getKey());
                    exc.printStackTrace(out);
                    corrupt = exc;
                }
            }
            out.flush();
            if (corrupt != null) {
                this.logger.warn("check index [failure]\n{}", (Object)os.bytes().utf8ToString());
                throw corrupt;
            }
        } else {
            CheckIndex.Status status = this.store.checkIndex(out);
            out.flush();
            if (!status.clean) {
                if (this.state == IndexShardState.CLOSED) {
                    return;
                }
                this.logger.warn("check index [failure]\n{}", (Object)os.bytes().utf8ToString());
                throw new IOException("index check failure");
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("check index [success]\n{}", (Object)os.bytes().utf8ToString());
        }
        this.recoveryState.getVerifyIndex().checkIndexTime(Math.max(0L, TimeValue.nsecToMSec(System.nanoTime() - timeNS)));
    }

    Engine getEngine() {
        Engine engine = this.getEngineOrNull();
        if (engine == null) {
            throw new AlreadyClosedException("engine is closed");
        }
        return engine;
    }

    protected Engine getEngineOrNull() {
        return this.currentEngineReference.get();
    }

    public void startRecovery(RecoveryState recoveryState, PeerRecoveryTargetService recoveryTargetService, PeerRecoveryTargetService.RecoveryListener recoveryListener, RepositoriesService repositoriesService, BiConsumer<String, MappingMetaData> mappingUpdateConsumer, IndicesService indicesService) {
        assert (recoveryState.getRecoverySource().equals(this.shardRouting.recoverySource()));
        switch (recoveryState.getRecoverySource().getType()) {
            case EMPTY_STORE: 
            case EXISTING_STORE: {
                this.markAsRecovering("from store", recoveryState);
                this.threadPool.generic().execute(() -> {
                    try {
                        if (this.recoverFromStore()) {
                            recoveryListener.onRecoveryDone(recoveryState);
                        }
                    }
                    catch (Exception e) {
                        recoveryListener.onRecoveryFailure(recoveryState, new RecoveryFailedException(recoveryState, null, (Throwable)e), true);
                    }
                });
                break;
            }
            case PEER: {
                try {
                    this.markAsRecovering("from " + recoveryState.getSourceNode(), recoveryState);
                    recoveryTargetService.startRecovery(this, recoveryState.getSourceNode(), recoveryListener);
                }
                catch (Exception e) {
                    this.failShard("corrupted preexisting index", e);
                    recoveryListener.onRecoveryFailure(recoveryState, new RecoveryFailedException(recoveryState, null, (Throwable)e), true);
                }
                break;
            }
            case SNAPSHOT: {
                this.markAsRecovering("from snapshot", recoveryState);
                RecoverySource.SnapshotRecoverySource recoverySource = (RecoverySource.SnapshotRecoverySource)recoveryState.getRecoverySource();
                this.threadPool.generic().execute(() -> {
                    try {
                        Repository repository = repositoriesService.repository(recoverySource.snapshot().getRepository());
                        if (this.restoreFromRepository(repository)) {
                            recoveryListener.onRecoveryDone(recoveryState);
                        }
                    }
                    catch (Exception e) {
                        recoveryListener.onRecoveryFailure(recoveryState, new RecoveryFailedException(recoveryState, null, (Throwable)e), true);
                    }
                });
                break;
            }
            case LOCAL_SHARDS: {
                int numShards;
                Set<Object> requiredShards;
                IndexMetaData indexMetaData = this.indexSettings().getIndexMetaData();
                Index resizeSourceIndex = indexMetaData.getResizeSourceIndex();
                ArrayList<IndexShard> startedShards = new ArrayList<IndexShard>();
                IndexService sourceIndexService = indicesService.indexService(resizeSourceIndex);
                if (sourceIndexService != null) {
                    requiredShards = IndexMetaData.selectRecoverFromShards(this.shardId().id(), sourceIndexService.getMetaData(), indexMetaData.getNumberOfShards());
                    for (IndexShard shard : sourceIndexService) {
                        if (shard.state() != IndexShardState.STARTED || !requiredShards.contains(shard.shardId())) continue;
                        startedShards.add(shard);
                    }
                    numShards = requiredShards.size();
                } else {
                    numShards = -1;
                    requiredShards = Collections.emptySet();
                }
                if (numShards == startedShards.size()) {
                    assert (!requiredShards.isEmpty());
                    this.markAsRecovering("from local shards", recoveryState);
                    this.threadPool.generic().execute(() -> {
                        try {
                            if (this.recoverFromLocalShards(mappingUpdateConsumer, startedShards.stream().filter(s -> requiredShards.contains(s.shardId())).collect(Collectors.toList()))) {
                                recoveryListener.onRecoveryDone(recoveryState);
                            }
                        }
                        catch (Exception e) {
                            recoveryListener.onRecoveryFailure(recoveryState, new RecoveryFailedException(recoveryState, null, (Throwable)e), true);
                        }
                    });
                    break;
                }
                RuntimeException e = numShards == -1 ? new IndexNotFoundException(resizeSourceIndex) : new IllegalStateException("not all required shards of index " + resizeSourceIndex + " are started yet, expected " + numShards + " found " + startedShards.size() + " can't recover shard " + this.shardId());
                throw e;
            }
            default: {
                throw new IllegalArgumentException("Unknown recovery source " + recoveryState.getRecoverySource());
            }
        }
    }

    public boolean isRelocatedPrimary() {
        assert (this.shardRouting.primary()) : "only call isRelocatedPrimary on primary shard";
        return this.replicationTracker.isRelocated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Engine createNewEngine(EngineConfig config) {
        Object object = this.mutex;
        synchronized (object) {
            this.verifyNotClosed();
            assert (this.currentEngineReference.get() == null);
            Engine engine = this.newEngine(config);
            this.onNewEngine(engine);
            this.currentEngineReference.set(engine);
        }
        Engine engine = this.getEngineOrNull();
        if (engine != null) {
            engine.onSettingsChanged();
        }
        return engine;
    }

    protected Engine newEngine(EngineConfig config) {
        return this.engineFactory.newReadWriteEngine(config);
    }

    private static void persistMetadata(ShardPath shardPath, IndexSettings indexSettings, ShardRouting newRouting, @Nullable ShardRouting currentRouting, Logger logger) throws IOException {
        assert (newRouting != null) : "newRouting must not be null";
        ShardId shardId = newRouting.shardId();
        if (currentRouting == null || currentRouting.primary() != newRouting.primary() || !currentRouting.allocationId().equals(newRouting.allocationId())) {
            assert (currentRouting == null || currentRouting.isSameAllocation(newRouting));
            String writeReason = currentRouting == null ? "initial state with allocation id [" + newRouting.allocationId() + "]" : "routing changed from " + currentRouting + " to " + newRouting;
            logger.trace("{} writing shard state, reason [{}]", (Object)shardId, (Object)writeReason);
            ShardStateMetaData newShardStateMetadata = new ShardStateMetaData(newRouting.primary(), indexSettings.getUUID(), newRouting.allocationId());
            ShardStateMetaData.FORMAT.write(newShardStateMetadata, shardPath.getShardStatePath());
        } else {
            logger.trace("{} skip writing shard state, has been written before", (Object)shardId);
        }
    }

    private DocumentMapperForType docMapper(String type) {
        return this.mapperService.documentMapperWithAutoCreate(type);
    }

    private EngineConfig newEngineConfig() {
        Sort indexSort = this.indexSortSupplier.get();
        return new EngineConfig(this.shardId, this.shardRouting.allocationId().getId(), this.threadPool, this.indexSettings, this.warmer, this.store, this.indexSettings.getMergePolicy(), this.mapperService.indexAnalyzer(), this.similarityService.similarity(this.mapperService), this.codecService, this.shardEventListener, this.indexCache.query(), this.cachingPolicy, this.translogConfig, IndexingMemoryController.SHARD_INACTIVE_TIME_SETTING.get(this.indexSettings.getSettings()), Collections.singletonList(this.refreshListeners), Collections.singletonList(new RefreshMetricUpdater(this.refreshMetric)), indexSort, this.circuitBreakerService, this.replicationTracker, () -> this.operationPrimaryTerm, this.tombstoneDocSupplier());
    }

    public void acquirePrimaryOperationPermit(ActionListener<Releasable> onPermitAcquired, String executorOnDelay, Object debugInfo) {
        this.verifyNotClosed();
        assert (this.shardRouting.primary()) : "acquirePrimaryOperationPermit should only be called on primary shard: " + this.shardRouting;
        this.indexShardOperationPermits.acquire(onPermitAcquired, executorOnDelay, false, debugInfo);
    }

    private <E extends Exception> void bumpPrimaryTerm(long newPrimaryTerm, CheckedRunnable<E> onBlocked) {
        assert (Thread.holdsLock(this.mutex));
        assert (newPrimaryTerm > this.pendingPrimaryTerm);
        assert (this.operationPrimaryTerm <= this.pendingPrimaryTerm);
        CountDownLatch termUpdated = new CountDownLatch(1);
        this.indexShardOperationPermits.asyncBlockOperations(30L, TimeUnit.MINUTES, () -> {
            assert (this.operationPrimaryTerm <= this.pendingPrimaryTerm);
            termUpdated.await();
            if (this.operationPrimaryTerm < newPrimaryTerm) {
                this.operationPrimaryTerm = newPrimaryTerm;
                onBlocked.run();
            }
        }, e -> {
            try {
                this.failShard("exception during primary term transition", (Exception)e);
            }
            catch (AlreadyClosedException alreadyClosedException) {
                // empty catch block
            }
        });
        this.pendingPrimaryTerm = newPrimaryTerm;
        termUpdated.countDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireReplicaOperationPermit(final long opPrimaryTerm, final long globalCheckpoint, final long maxSeqNoOfUpdatesOrDeletes, final ActionListener<Releasable> onPermitAcquired, String executorOnDelay, Object debugInfo) {
        this.verifyNotClosed();
        if (opPrimaryTerm > this.pendingPrimaryTerm) {
            Object object = this.mutex;
            synchronized (object) {
                if (opPrimaryTerm > this.pendingPrimaryTerm) {
                    IndexShardState shardState = this.state();
                    if (shardState != IndexShardState.POST_RECOVERY && shardState != IndexShardState.STARTED) {
                        throw new IndexShardNotStartedException(this.shardId, shardState);
                    }
                    if (opPrimaryTerm > this.pendingPrimaryTerm) {
                        this.bumpPrimaryTerm(opPrimaryTerm, () -> {
                            this.updateGlobalCheckpointOnReplica(globalCheckpoint, "primary term transition");
                            long currentGlobalCheckpoint = this.getGlobalCheckpoint();
                            long maxSeqNo = this.seqNoStats().getMaxSeqNo();
                            this.logger.info("detected new primary with primary term [{}], global checkpoint [{}], max_seq_no [{}]", (Object)opPrimaryTerm, (Object)currentGlobalCheckpoint, (Object)maxSeqNo);
                            if (currentGlobalCheckpoint < maxSeqNo) {
                                this.resetEngineToGlobalCheckpoint();
                            } else {
                                this.getEngine().rollTranslogGeneration();
                            }
                        });
                    }
                }
            }
        }
        assert (opPrimaryTerm <= this.pendingPrimaryTerm) : "operation primary term [" + opPrimaryTerm + "] should be at most [" + this.pendingPrimaryTerm + "]";
        this.indexShardOperationPermits.acquire(new ActionListener<Releasable>(){

            @Override
            public void onResponse(Releasable releasable) {
                if (opPrimaryTerm < IndexShard.this.operationPrimaryTerm) {
                    releasable.close();
                    String message = String.format(Locale.ROOT, "%s operation primary term [%d] is too old (current [%d])", IndexShard.this.shardId, opPrimaryTerm, IndexShard.this.operationPrimaryTerm);
                    onPermitAcquired.onFailure(new IllegalStateException(message));
                } else {
                    assert (IndexShard.this.assertReplicationTarget());
                    try {
                        IndexShard.this.updateGlobalCheckpointOnReplica(globalCheckpoint, "operation");
                        IndexShard.this.advanceMaxSeqNoOfUpdatesOrDeletes(maxSeqNoOfUpdatesOrDeletes);
                    }
                    catch (Exception e) {
                        releasable.close();
                        onPermitAcquired.onFailure(e);
                        return;
                    }
                    onPermitAcquired.onResponse(releasable);
                }
            }

            @Override
            public void onFailure(Exception e) {
                onPermitAcquired.onFailure(e);
            }
        }, executorOnDelay, true, debugInfo);
    }

    public int getActiveOperationsCount() {
        return this.indexShardOperationPermits.getActiveOperationsCount();
    }

    public List<String> getActiveOperations() {
        return this.indexShardOperationPermits.getActiveOperations();
    }

    public final void sync(Translog.Location location, Consumer<Exception> syncListener) {
        this.verifyNotClosed();
        this.translogSyncProcessor.put(location, syncListener);
    }

    public void sync() throws IOException {
        this.verifyNotClosed();
        this.getEngine().syncTranslog();
    }

    public boolean isSyncNeeded() {
        return this.getEngine().isTranslogSyncNeeded();
    }

    public Translog.Durability getTranslogDurability() {
        return this.indexSettings.getTranslogDurability();
    }

    public void afterWriteOperation() {
        if ((this.shouldPeriodicallyFlush() || this.shouldRollTranslogGeneration()) && this.flushOrRollRunning.compareAndSet(false, true)) {
            if (this.shouldPeriodicallyFlush()) {
                this.logger.debug("submitting async flush request");
                AbstractRunnable flush = new AbstractRunnable(){

                    @Override
                    public void onFailure(Exception e) {
                        if (IndexShard.this.state != IndexShardState.CLOSED) {
                            IndexShard.this.logger.warn("failed to flush index", (Throwable)e);
                        }
                    }

                    @Override
                    protected void doRun() throws IOException {
                        IndexShard.this.flush(new FlushRequest(new String[0]));
                        IndexShard.this.periodicFlushMetric.inc();
                    }

                    @Override
                    public void onAfter() {
                        IndexShard.this.flushOrRollRunning.compareAndSet(true, false);
                        IndexShard.this.afterWriteOperation();
                    }
                };
                this.threadPool.executor("flush").execute(flush);
            } else if (this.shouldRollTranslogGeneration()) {
                this.logger.debug("submitting async roll translog generation request");
                AbstractRunnable roll = new AbstractRunnable(){

                    @Override
                    public void onFailure(Exception e) {
                        if (IndexShard.this.state != IndexShardState.CLOSED) {
                            IndexShard.this.logger.warn("failed to roll translog generation", (Throwable)e);
                        }
                    }

                    @Override
                    protected void doRun() throws Exception {
                        IndexShard.this.rollTranslogGeneration();
                    }

                    @Override
                    public void onAfter() {
                        IndexShard.this.flushOrRollRunning.compareAndSet(true, false);
                        IndexShard.this.afterWriteOperation();
                    }
                };
                this.threadPool.executor("flush").execute(roll);
            } else {
                this.flushOrRollRunning.compareAndSet(true, false);
            }
        }
    }

    private RefreshListeners buildRefreshListeners() {
        return new RefreshListeners(this.indexSettings::getMaxRefreshListeners, () -> this.refresh("too_many_listeners"), this.threadPool.executor("listener")::execute, this.logger, this.threadPool.getThreadContext());
    }

    EngineFactory getEngineFactory() {
        return this.engineFactory;
    }

    ReplicationTracker getReplicationTracker() {
        return this.replicationTracker;
    }

    public boolean isRefreshNeeded() {
        return this.getEngine().refreshNeeded() || this.refreshListeners != null && this.refreshListeners.refreshNeeded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRefreshListener(Translog.Location location, Consumer<Boolean> listener) {
        boolean readAllowed;
        if (this.isReadAllowed()) {
            readAllowed = true;
        } else {
            Object object = this.mutex;
            synchronized (object) {
                readAllowed = this.isReadAllowed();
            }
        }
        if (readAllowed) {
            this.refreshListeners.addOrNotify(location, listener);
        } else {
            listener.accept(false);
        }
    }

    private EngineConfig.TombstoneDocSupplier tombstoneDocSupplier() {
        RootObjectMapper.Builder noopRootMapper = new RootObjectMapper.Builder("__noop");
        final DocumentMapper noopDocumentMapper = new DocumentMapper.Builder(noopRootMapper, this.mapperService).build(this.mapperService);
        return new EngineConfig.TombstoneDocSupplier(){

            @Override
            public ParsedDocument newDeleteTombstoneDoc(String type, String id) {
                return IndexShard.this.docMapper(type).getDocumentMapper().createDeleteTombstoneDoc(IndexShard.this.shardId.getIndexName(), type, id);
            }

            @Override
            public ParsedDocument newNoopTombstoneDoc(String reason) {
                return noopDocumentMapper.createNoopTombstoneDoc(IndexShard.this.shardId.getIndexName(), reason);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetEngineToGlobalCheckpoint() throws IOException {
        Engine newEngine;
        assert (this.getActiveOperationsCount() == 0) : "Ongoing writes [" + this.getActiveOperations() + "]";
        this.sync();
        long globalCheckpoint = this.getGlobalCheckpoint();
        Object object = this.mutex;
        synchronized (object) {
            this.verifyNotClosed();
            IOUtils.close(new Closeable[]{this.currentEngineReference.getAndSet(null)});
            this.trimUnsafeCommits();
            newEngine = this.createNewEngine(this.newEngineConfig());
            this.active.set(true);
        }
        newEngine.advanceMaxSeqNoOfUpdatesOrDeletes(globalCheckpoint);
        Engine.TranslogRecoveryRunner translogRunner = (engine, snapshot) -> this.runTranslogRecovery(engine, snapshot, Engine.Operation.Origin.LOCAL_RESET, () -> {});
        newEngine.recoverFromTranslog(translogRunner, globalCheckpoint);
    }

    public long getMaxSeqNoOfUpdatesOrDeletes() {
        return this.getEngine().getMaxSeqNoOfUpdatesOrDeletes();
    }

    public void advanceMaxSeqNoOfUpdatesOrDeletes(long seqNo) {
        assert (seqNo != -2L || this.getMaxSeqNoOfUpdatesOrDeletes() == -2L) : "replica has max_seq_no_of_updates=" + this.getMaxSeqNoOfUpdatesOrDeletes() + " but primary does not";
        this.getEngine().advanceMaxSeqNoOfUpdatesOrDeletes(seqNo);
        assert (seqNo <= this.getMaxSeqNoOfUpdatesOrDeletes()) : this.getMaxSeqNoOfUpdatesOrDeletes() + " < " + seqNo;
    }

    private static class RefreshMetricUpdater
    implements ReferenceManager.RefreshListener {
        private final MeanMetric refreshMetric;
        private long currentRefreshStartTime;
        private Thread callingThread = null;

        private RefreshMetricUpdater(MeanMetric refreshMetric) {
            this.refreshMetric = refreshMetric;
        }

        @Override
        public void beforeRefresh() throws IOException {
            if (Assertions.ENABLED) {
                assert (this.callingThread == null) : "beforeRefresh was called by " + this.callingThread.getName() + " without a corresponding call to afterRefresh";
                this.callingThread = Thread.currentThread();
            }
            this.currentRefreshStartTime = System.nanoTime();
        }

        @Override
        public void afterRefresh(boolean didRefresh) throws IOException {
            if (Assertions.ENABLED) {
                assert (this.callingThread != null) : "afterRefresh called but not beforeRefresh";
                assert (this.callingThread == Thread.currentThread()) : "beforeRefreshed called by a different thread. current [" + Thread.currentThread().getName() + "], thread that called beforeRefresh [" + this.callingThread.getName() + "]";
                this.callingThread = null;
            }
            this.refreshMetric.inc(System.nanoTime() - this.currentRefreshStartTime);
        }
    }

    public static final class ShardFailure {
        public final ShardRouting routing;
        public final String reason;
        @Nullable
        public final Exception cause;

        public ShardFailure(ShardRouting routing, String reason, @Nullable Exception cause) {
            this.routing = routing;
            this.reason = reason;
            this.cause = cause;
        }
    }

    class ShardEventListener
    implements Engine.EventListener {
        private final CopyOnWriteArrayList<Consumer<ShardFailure>> delegates = new CopyOnWriteArrayList();

        ShardEventListener() {
        }

        @Override
        public void onFailedEngine(String reason, @Nullable Exception failure) {
            ShardFailure shardFailure = new ShardFailure(IndexShard.this.shardRouting, reason, failure);
            for (Consumer<ShardFailure> listener : this.delegates) {
                try {
                    listener.accept(shardFailure);
                }
                catch (Exception inner) {
                    inner.addSuppressed(failure);
                    IndexShard.this.logger.warn("exception while notifying engine failure", (Throwable)inner);
                }
            }
        }
    }
}

