/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.shard;

import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.io.stream.Streamable;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.ToXContentFragment;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.index.Index;
import java.io.IOException;

public class ShardId
implements Streamable,
Comparable<ShardId>,
ToXContentFragment {
    private Index index;
    private int shardId;
    private int hashCode;

    private ShardId() {
    }

    public ShardId(Index index, int shardId) {
        this.index = index;
        this.shardId = shardId;
        this.hashCode = this.computeHashCode();
    }

    public ShardId(String index, String indexUUID, int shardId) {
        this(new Index(index, indexUUID), shardId);
    }

    public Index getIndex() {
        return this.index;
    }

    public String getIndexName() {
        return this.index.getName();
    }

    public int id() {
        return this.shardId;
    }

    public int getId() {
        return this.id();
    }

    public String toString() {
        return "[" + this.index.getName() + "][" + this.shardId + "]";
    }

    public static ShardId fromString(String shardIdString) {
        int splitPosition = shardIdString.indexOf("][");
        if (splitPosition <= 0 || shardIdString.charAt(0) != '[' || shardIdString.charAt(shardIdString.length() - 1) != ']') {
            throw new IllegalArgumentException("Unexpected shardId string format, expected [indexName][shardId] but got " + shardIdString);
        }
        String indexName = shardIdString.substring(1, splitPosition);
        int shardId = Integer.parseInt(shardIdString.substring(splitPosition + 2, shardIdString.length() - 1));
        return new ShardId(new Index(indexName, "_na_"), shardId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShardId shardId1 = (ShardId)o;
        return this.shardId == shardId1.shardId && this.index.equals(shardId1.index);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int result = this.index != null ? this.index.hashCode() : 0;
        result = 31 * result + this.shardId;
        return result;
    }

    public static ShardId readShardId(StreamInput in) throws IOException {
        ShardId shardId = new ShardId();
        shardId.readFrom(in);
        return shardId;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.index = new Index(in);
        this.shardId = in.readVInt();
        this.hashCode = this.computeHashCode();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.index.writeTo(out);
        out.writeVInt(this.shardId);
    }

    @Override
    public int compareTo(ShardId o) {
        if (o.getId() == this.shardId) {
            int compare = this.index.getName().compareTo(o.getIndex().getName());
            if (compare != 0) {
                return compare;
            }
            return this.index.getUUID().compareTo(o.getIndex().getUUID());
        }
        return Integer.compare(this.shardId, o.getId());
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.value(this.toString());
    }
}

