/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.snapshots.blobstore;

import conductor.org.elasticsearch.index.snapshots.blobstore.BlobStoreIndexShardSnapshot;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SnapshotFiles {
    private final String snapshot;
    private final List<BlobStoreIndexShardSnapshot.FileInfo> indexFiles;
    private Map<String, BlobStoreIndexShardSnapshot.FileInfo> physicalFiles = null;

    public String snapshot() {
        return this.snapshot;
    }

    public SnapshotFiles(String snapshot, List<BlobStoreIndexShardSnapshot.FileInfo> indexFiles) {
        this.snapshot = snapshot;
        this.indexFiles = indexFiles;
    }

    public List<BlobStoreIndexShardSnapshot.FileInfo> indexFiles() {
        return this.indexFiles;
    }

    public boolean containPhysicalIndexFile(String physicalName) {
        return this.findPhysicalIndexFile(physicalName) != null;
    }

    public BlobStoreIndexShardSnapshot.FileInfo findPhysicalIndexFile(String physicalName) {
        if (this.physicalFiles == null) {
            HashMap<String, BlobStoreIndexShardSnapshot.FileInfo> files = new HashMap<String, BlobStoreIndexShardSnapshot.FileInfo>();
            for (BlobStoreIndexShardSnapshot.FileInfo fileInfo : this.indexFiles) {
                files.put(fileInfo.physicalName(), fileInfo);
            }
            this.physicalFiles = files;
        }
        return this.physicalFiles.get(physicalName);
    }
}

