/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.join.aggregations;

import conductor.org.apache.lucene.index.IndexReader;
import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.apache.lucene.index.SortedSetDocValues;
import conductor.org.apache.lucene.search.ConstantScoreScorer;
import conductor.org.apache.lucene.search.DocIdSetIterator;
import conductor.org.apache.lucene.search.Query;
import conductor.org.apache.lucene.search.Scorer;
import conductor.org.apache.lucene.search.Weight;
import conductor.org.apache.lucene.util.Bits;
import conductor.org.elasticsearch.common.ParseField;
import conductor.org.elasticsearch.common.lease.Releasables;
import conductor.org.elasticsearch.common.lucene.Lucene;
import conductor.org.elasticsearch.common.util.LongArray;
import conductor.org.elasticsearch.common.util.LongObjectPagedHashMap;
import conductor.org.elasticsearch.join.aggregations.InternalChildren;
import conductor.org.elasticsearch.search.aggregations.Aggregator;
import conductor.org.elasticsearch.search.aggregations.AggregatorFactories;
import conductor.org.elasticsearch.search.aggregations.InternalAggregation;
import conductor.org.elasticsearch.search.aggregations.LeafBucketCollector;
import conductor.org.elasticsearch.search.aggregations.bucket.BucketsAggregator;
import conductor.org.elasticsearch.search.aggregations.bucket.SingleBucketAggregator;
import conductor.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import conductor.org.elasticsearch.search.aggregations.support.ValuesSource;
import conductor.org.elasticsearch.search.internal.SearchContext;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class ParentToChildrenAggregator
extends BucketsAggregator
implements SingleBucketAggregator {
    static final ParseField TYPE_FIELD = new ParseField("type", new String[0]);
    private final Weight childFilter;
    private final Weight parentFilter;
    private final ValuesSource.Bytes.WithOrdinals valuesSource;
    private final LongArray parentOrdToBuckets;
    private final LongObjectPagedHashMap<long[]> parentOrdToOtherBuckets;
    private boolean multipleBucketsPerParentOrd = false;

    public ParentToChildrenAggregator(String name, AggregatorFactories factories, SearchContext context, Aggregator parent, Query childFilter, Query parentFilter, ValuesSource.Bytes.WithOrdinals valuesSource, long maxOrd, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        super(name, factories, context, parent, pipelineAggregators, metaData);
        this.childFilter = context.searcher().createNormalizedWeight(childFilter, false);
        this.parentFilter = context.searcher().createNormalizedWeight(parentFilter, false);
        this.parentOrdToBuckets = context.bigArrays().newLongArray(maxOrd, false);
        this.parentOrdToBuckets.fill(0L, maxOrd, -1L);
        this.parentOrdToOtherBuckets = new LongObjectPagedHashMap(context.bigArrays());
        this.valuesSource = valuesSource;
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) throws IOException {
        return new InternalChildren(this.name, this.bucketDocCount(owningBucketOrdinal), this.bucketAggregations(owningBucketOrdinal), this.pipelineAggregators(), this.metaData());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalChildren(this.name, 0L, this.buildEmptySubAggregations(), this.pipelineAggregators(), this.metaData());
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        if (this.valuesSource == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final SortedSetDocValues globalOrdinals = this.valuesSource.globalOrdinalsValues(ctx);
        final Bits parentDocs = Lucene.asSequentialAccessBits(ctx.reader().maxDoc(), this.parentFilter.scorerSupplier(ctx));
        return new LeafBucketCollector(){

            @Override
            public void collect(int docId, long bucket) throws IOException {
                if (parentDocs.get(docId) && globalOrdinals.advanceExact(docId)) {
                    long globalOrdinal = globalOrdinals.nextOrd();
                    assert (globalOrdinals.nextOrd() == -1L);
                    if (globalOrdinal != -1L) {
                        if (ParentToChildrenAggregator.this.parentOrdToBuckets.get(globalOrdinal) == -1L) {
                            ParentToChildrenAggregator.this.parentOrdToBuckets.set(globalOrdinal, bucket);
                        } else {
                            long[] bucketOrds = (long[])ParentToChildrenAggregator.this.parentOrdToOtherBuckets.get(globalOrdinal);
                            if (bucketOrds != null) {
                                bucketOrds = Arrays.copyOf(bucketOrds, bucketOrds.length + 1);
                                bucketOrds[bucketOrds.length - 1] = bucket;
                                ParentToChildrenAggregator.this.parentOrdToOtherBuckets.put(globalOrdinal, bucketOrds);
                            } else {
                                ParentToChildrenAggregator.this.parentOrdToOtherBuckets.put(globalOrdinal, new long[]{bucket});
                            }
                            ParentToChildrenAggregator.this.multipleBucketsPerParentOrd = true;
                        }
                    }
                }
            }
        };
    }

    @Override
    protected void doPostCollection() throws IOException {
        IndexReader indexReader = this.context().searcher().getIndexReader();
        for (LeafReaderContext ctx : indexReader.leaves()) {
            Scorer childDocsScorer = this.childFilter.scorer(ctx);
            if (childDocsScorer == null) continue;
            DocIdSetIterator childDocsIter = childDocsScorer.iterator();
            LeafBucketCollector sub = this.collectableSubAggregators.getLeafCollector(ctx);
            SortedSetDocValues globalOrdinals = this.valuesSource.globalOrdinalsValues(ctx);
            sub.setScorer(new ConstantScoreScorer(null, 1.0f, childDocsIter));
            Bits liveDocs = ctx.reader().getLiveDocs();
            int docId = childDocsIter.nextDoc();
            while (docId != Integer.MAX_VALUE) {
                if ((liveDocs == null || liveDocs.get(docId)) && globalOrdinals.advanceExact(docId)) {
                    long globalOrdinal = globalOrdinals.nextOrd();
                    assert (globalOrdinals.nextOrd() == -1L);
                    long bucketOrd = this.parentOrdToBuckets.get(globalOrdinal);
                    if (bucketOrd != -1L) {
                        long[] otherBucketOrds;
                        this.collectBucket(sub, docId, bucketOrd);
                        if (this.multipleBucketsPerParentOrd && (otherBucketOrds = this.parentOrdToOtherBuckets.get(globalOrdinal)) != null) {
                            for (long otherBucketOrd : otherBucketOrds) {
                                this.collectBucket(sub, docId, otherBucketOrd);
                            }
                        }
                    }
                }
                docId = childDocsIter.nextDoc();
            }
        }
    }

    @Override
    protected void doClose() {
        Releasables.close(this.parentOrdToBuckets, this.parentOrdToOtherBuckets);
    }
}

