/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.node;

import conductor.org.elasticsearch.Build;
import conductor.org.elasticsearch.Version;
import conductor.org.elasticsearch.action.admin.cluster.node.info.NodeInfo;
import conductor.org.elasticsearch.action.admin.cluster.node.stats.NodeStats;
import conductor.org.elasticsearch.action.admin.indices.stats.CommonStatsFlags;
import conductor.org.elasticsearch.action.search.SearchTransportService;
import conductor.org.elasticsearch.cluster.service.ClusterService;
import conductor.org.elasticsearch.common.Nullable;
import conductor.org.elasticsearch.common.component.AbstractComponent;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.common.settings.SettingsFilter;
import conductor.org.elasticsearch.core.internal.io.IOUtils;
import conductor.org.elasticsearch.discovery.Discovery;
import conductor.org.elasticsearch.http.HttpServerTransport;
import conductor.org.elasticsearch.indices.IndicesService;
import conductor.org.elasticsearch.indices.breaker.CircuitBreakerService;
import conductor.org.elasticsearch.ingest.IngestService;
import conductor.org.elasticsearch.monitor.MonitorService;
import conductor.org.elasticsearch.node.ResponseCollectorService;
import conductor.org.elasticsearch.plugins.PluginsService;
import conductor.org.elasticsearch.script.ScriptService;
import conductor.org.elasticsearch.threadpool.ThreadPool;
import conductor.org.elasticsearch.transport.TransportService;
import java.io.Closeable;
import java.io.IOException;

public class NodeService
extends AbstractComponent
implements Closeable {
    private final ThreadPool threadPool;
    private final MonitorService monitorService;
    private final TransportService transportService;
    private final IndicesService indicesService;
    private final PluginsService pluginService;
    private final CircuitBreakerService circuitBreakerService;
    private final IngestService ingestService;
    private final SettingsFilter settingsFilter;
    private final ScriptService scriptService;
    private final HttpServerTransport httpServerTransport;
    private final ResponseCollectorService responseCollectorService;
    private final SearchTransportService searchTransportService;
    private final Discovery discovery;

    NodeService(Settings settings, ThreadPool threadPool, MonitorService monitorService, Discovery discovery, TransportService transportService, IndicesService indicesService, PluginsService pluginService, CircuitBreakerService circuitBreakerService, ScriptService scriptService, @Nullable HttpServerTransport httpServerTransport, IngestService ingestService, ClusterService clusterService, SettingsFilter settingsFilter, ResponseCollectorService responseCollectorService, SearchTransportService searchTransportService) {
        super(settings);
        this.threadPool = threadPool;
        this.monitorService = monitorService;
        this.transportService = transportService;
        this.indicesService = indicesService;
        this.discovery = discovery;
        this.pluginService = pluginService;
        this.circuitBreakerService = circuitBreakerService;
        this.httpServerTransport = httpServerTransport;
        this.ingestService = ingestService;
        this.settingsFilter = settingsFilter;
        this.scriptService = scriptService;
        this.responseCollectorService = responseCollectorService;
        this.searchTransportService = searchTransportService;
        clusterService.addStateApplier(ingestService);
    }

    public NodeInfo info(boolean settings, boolean os, boolean process, boolean jvm, boolean threadPool, boolean transport, boolean http, boolean plugin, boolean ingest, boolean indices) {
        return new NodeInfo(Version.CURRENT, Build.CURRENT, this.transportService.getLocalNode(), settings ? this.settingsFilter.filter(this.settings) : null, os ? this.monitorService.osService().info() : null, process ? this.monitorService.processService().info() : null, jvm ? this.monitorService.jvmService().info() : null, threadPool ? this.threadPool.info() : null, transport ? this.transportService.info() : null, http ? (this.httpServerTransport == null ? null : this.httpServerTransport.info()) : null, plugin ? (this.pluginService == null ? null : this.pluginService.info()) : null, ingest ? (this.ingestService == null ? null : this.ingestService.info()) : null, indices ? this.indicesService.getTotalIndexingBufferBytes() : null);
    }

    public NodeStats stats(CommonStatsFlags indices, boolean os, boolean process, boolean jvm, boolean threadPool, boolean fs, boolean transport, boolean http, boolean circuitBreaker, boolean script, boolean discoveryStats, boolean ingest, boolean adaptiveSelection) {
        return new NodeStats(this.transportService.getLocalNode(), System.currentTimeMillis(), indices.anySet() ? this.indicesService.stats(true, indices) : null, os ? this.monitorService.osService().stats() : null, process ? this.monitorService.processService().stats() : null, jvm ? this.monitorService.jvmService().stats() : null, threadPool ? this.threadPool.stats() : null, fs ? this.monitorService.fsService().stats() : null, transport ? this.transportService.stats() : null, http ? (this.httpServerTransport == null ? null : this.httpServerTransport.stats()) : null, circuitBreaker ? this.circuitBreakerService.stats() : null, script ? this.scriptService.stats() : null, discoveryStats ? this.discovery.stats() : null, ingest ? this.ingestService.stats() : null, adaptiveSelection ? this.responseCollectorService.getAdaptiveStats(this.searchTransportService.getPendingSearchRequests()) : null);
    }

    public IngestService getIngestService() {
        return this.ingestService;
    }

    public MonitorService getMonitorService() {
        return this.monitorService;
    }

    @Override
    public void close() throws IOException {
        IOUtils.close(new Closeable[]{this.indicesService});
    }
}

