/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.persistent;

import conductor.org.elasticsearch.common.component.AbstractComponent;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.persistent.PersistentTaskParams;
import conductor.org.elasticsearch.persistent.PersistentTasksExecutor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class PersistentTasksExecutorRegistry
extends AbstractComponent {
    private final Map<String, PersistentTasksExecutor<?>> taskExecutors;

    public PersistentTasksExecutorRegistry(Settings settings, Collection<PersistentTasksExecutor<?>> taskExecutors) {
        super(settings);
        HashMap map = new HashMap();
        for (PersistentTasksExecutor<?> executor : taskExecutors) {
            map.put(executor.getTaskName(), executor);
        }
        this.taskExecutors = Collections.unmodifiableMap(map);
    }

    public <Params extends PersistentTaskParams> PersistentTasksExecutor<Params> getPersistentTaskExecutorSafe(String taskName) {
        PersistentTasksExecutor<?> executor = this.taskExecutors.get(taskName);
        if (executor == null) {
            throw new IllegalStateException("Unknown persistent executor [" + taskName + "]");
        }
        return executor;
    }
}

