/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.rest.action.admin.cluster;

import conductor.org.elasticsearch.action.admin.cluster.shards.ClusterSearchShardsRequest;
import conductor.org.elasticsearch.action.admin.cluster.shards.ClusterSearchShardsResponse;
import conductor.org.elasticsearch.action.support.IndicesOptions;
import conductor.org.elasticsearch.client.Requests;
import conductor.org.elasticsearch.client.node.NodeClient;
import conductor.org.elasticsearch.common.Strings;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.rest.BaseRestHandler;
import conductor.org.elasticsearch.rest.RestChannel;
import conductor.org.elasticsearch.rest.RestController;
import conductor.org.elasticsearch.rest.RestRequest;
import conductor.org.elasticsearch.rest.action.RestToXContentListener;
import java.io.IOException;

public class RestClusterSearchShardsAction
extends BaseRestHandler {
    public RestClusterSearchShardsAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.GET, "/_search_shards", this);
        controller.registerHandler(RestRequest.Method.POST, "/_search_shards", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_search_shards", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_search_shards", this);
    }

    @Override
    public String getName() {
        return "cluster_search_shards_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String[] indices = Strings.splitStringByCommaToArray(request.param("index"));
        ClusterSearchShardsRequest clusterSearchShardsRequest = Requests.clusterSearchShardsRequest(indices);
        clusterSearchShardsRequest.local(request.paramAsBoolean("local", clusterSearchShardsRequest.local()));
        clusterSearchShardsRequest.routing(request.param("routing"));
        clusterSearchShardsRequest.preference(request.param("preference"));
        clusterSearchShardsRequest.indicesOptions(IndicesOptions.fromRequest(request, clusterSearchShardsRequest.indicesOptions()));
        return channel -> client.admin().cluster().searchShards(clusterSearchShardsRequest, new RestToXContentListener<ClusterSearchShardsResponse>((RestChannel)channel));
    }
}

