/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.aggregations;

import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.search.aggregations.AggregationBuilder;
import conductor.org.elasticsearch.search.aggregations.AggregatorFactories;
import conductor.org.elasticsearch.search.aggregations.AggregatorFactory;
import conductor.org.elasticsearch.search.aggregations.PipelineAggregationBuilder;
import conductor.org.elasticsearch.search.internal.SearchContext;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;

public abstract class AbstractAggregationBuilder<AB extends AbstractAggregationBuilder<AB>>
extends AggregationBuilder {
    protected Map<String, Object> metaData;

    public AbstractAggregationBuilder(String name) {
        super(name);
    }

    protected AbstractAggregationBuilder(AbstractAggregationBuilder<AB> clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metaData) {
        super(clone, factoriesBuilder);
        this.metaData = metaData;
    }

    protected AbstractAggregationBuilder(StreamInput in) throws IOException {
        super(in.readString());
        this.factoriesBuilder = new AggregatorFactories.Builder(in);
        this.metaData = in.readMap();
    }

    @Override
    public final void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        this.factoriesBuilder.writeTo(out);
        out.writeMap(this.metaData);
        this.doWriteTo(out);
    }

    protected abstract void doWriteTo(StreamOutput var1) throws IOException;

    public AB subAggregation(AggregationBuilder aggregation) {
        if (aggregation == null) {
            throw new IllegalArgumentException("[aggregation] must not be null: [" + this.name + "]");
        }
        this.factoriesBuilder.addAggregator(aggregation);
        return (AB)this;
    }

    public AB subAggregation(PipelineAggregationBuilder aggregation) {
        if (aggregation == null) {
            throw new IllegalArgumentException("[aggregation] must not be null: [" + this.name + "]");
        }
        this.factoriesBuilder.addPipelineAggregator(aggregation);
        return (AB)this;
    }

    public AB subAggregations(AggregatorFactories.Builder subFactories) {
        if (subFactories == null) {
            throw new IllegalArgumentException("[subFactories] must not be null: [" + this.name + "]");
        }
        this.factoriesBuilder = subFactories;
        return (AB)this;
    }

    public AB setMetaData(Map<String, Object> metaData) {
        if (metaData == null) {
            throw new IllegalArgumentException("[metaData] must not be null: [" + this.name + "]");
        }
        this.metaData = metaData;
        return (AB)this;
    }

    @Override
    public Map<String, Object> getMetaData() {
        return this.metaData == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.metaData);
    }

    @Override
    public final String getWriteableName() {
        return this.getType();
    }

    @Override
    public final AggregatorFactory<?> build(SearchContext context, AggregatorFactory<?> parent) throws IOException {
        AggregatorFactory<?> factory = this.doBuild(context, parent, this.factoriesBuilder);
        return factory;
    }

    protected abstract AggregatorFactory<?> doBuild(SearchContext var1, AggregatorFactory<?> var2, AggregatorFactories.Builder var3) throws IOException;

    @Override
    public final XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.name);
        if (this.metaData != null) {
            builder.field("meta", this.metaData);
        }
        builder.field(this.getType());
        this.internalXContent(builder, params);
        if (this.factoriesBuilder != null && this.factoriesBuilder.count() > 0) {
            builder.field("aggregations");
            this.factoriesBuilder.toXContent(builder, params);
        }
        return builder.endObject();
    }

    protected abstract XContentBuilder internalXContent(XContentBuilder var1, ToXContent.Params var2) throws IOException;

    public int hashCode() {
        return Objects.hash(this.factoriesBuilder, this.metaData, this.name, this.doHashCode());
    }

    protected abstract int doHashCode();

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractAggregationBuilder other = (AbstractAggregationBuilder)obj;
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (!Objects.equals(this.metaData, other.metaData)) {
            return false;
        }
        if (!Objects.equals(this.factoriesBuilder, other.factoriesBuilder)) {
            return false;
        }
        return this.doEquals(obj);
    }

    protected abstract boolean doEquals(Object var1);
}

