/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.aggregations.bucket.histogram;

import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.apache.lucene.index.SortedNumericDocValues;
import conductor.org.apache.lucene.util.CollectionUtil;
import conductor.org.elasticsearch.common.Nullable;
import conductor.org.elasticsearch.common.lease.Releasables;
import conductor.org.elasticsearch.common.rounding.Rounding;
import conductor.org.elasticsearch.common.util.LongHash;
import conductor.org.elasticsearch.search.DocValueFormat;
import conductor.org.elasticsearch.search.aggregations.Aggregator;
import conductor.org.elasticsearch.search.aggregations.AggregatorFactories;
import conductor.org.elasticsearch.search.aggregations.BucketOrder;
import conductor.org.elasticsearch.search.aggregations.InternalAggregation;
import conductor.org.elasticsearch.search.aggregations.InternalOrder;
import conductor.org.elasticsearch.search.aggregations.LeafBucketCollector;
import conductor.org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import conductor.org.elasticsearch.search.aggregations.bucket.BucketsAggregator;
import conductor.org.elasticsearch.search.aggregations.bucket.histogram.ExtendedBounds;
import conductor.org.elasticsearch.search.aggregations.bucket.histogram.InternalDateHistogram;
import conductor.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import conductor.org.elasticsearch.search.aggregations.support.ValuesSource;
import conductor.org.elasticsearch.search.internal.SearchContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

class DateHistogramAggregator
extends BucketsAggregator {
    private final ValuesSource.Numeric valuesSource;
    private final DocValueFormat formatter;
    private final Rounding rounding;
    private final Rounding shardRounding;
    private final BucketOrder order;
    private final boolean keyed;
    private final long minDocCount;
    private final ExtendedBounds extendedBounds;
    private final LongHash bucketOrds;
    private long offset;

    DateHistogramAggregator(String name, AggregatorFactories factories, Rounding rounding, Rounding shardRounding, long offset, BucketOrder order, boolean keyed, long minDocCount, @Nullable ExtendedBounds extendedBounds, @Nullable ValuesSource.Numeric valuesSource, DocValueFormat formatter, SearchContext aggregationContext, Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        super(name, factories, aggregationContext, parent, pipelineAggregators, metaData);
        this.rounding = rounding;
        this.shardRounding = shardRounding;
        this.offset = offset;
        this.order = InternalOrder.validate(order, this);
        this.keyed = keyed;
        this.minDocCount = minDocCount;
        this.extendedBounds = extendedBounds;
        this.valuesSource = valuesSource;
        this.formatter = formatter;
        this.bucketOrds = new LongHash(1L, aggregationContext.bigArrays());
    }

    @Override
    public boolean needsScores() {
        return this.valuesSource != null && this.valuesSource.needsScores() || super.needsScores();
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, final LeafBucketCollector sub) throws IOException {
        if (this.valuesSource == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final SortedNumericDocValues values = this.valuesSource.longValues(ctx);
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                assert (bucket == 0L);
                if (values.advanceExact(doc)) {
                    int valuesCount = values.docValueCount();
                    long previousRounded = Long.MIN_VALUE;
                    for (int i = 0; i < valuesCount; ++i) {
                        long value = values.nextValue();
                        long rounded = DateHistogramAggregator.this.shardRounding.round(value - DateHistogramAggregator.this.offset) + DateHistogramAggregator.this.offset;
                        assert (rounded >= previousRounded);
                        if (rounded == previousRounded) continue;
                        long bucketOrd = DateHistogramAggregator.this.bucketOrds.add(rounded);
                        if (bucketOrd < 0L) {
                            bucketOrd = -1L - bucketOrd;
                            DateHistogramAggregator.this.collectExistingBucket(sub, doc, bucketOrd);
                        } else {
                            DateHistogramAggregator.this.collectBucket(sub, doc, bucketOrd);
                        }
                        previousRounded = rounded;
                    }
                }
            }
        };
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) throws IOException {
        assert (owningBucketOrdinal == 0L);
        this.consumeBucketsAndMaybeBreak((int)this.bucketOrds.size());
        ArrayList<InternalDateHistogram.Bucket> buckets = new ArrayList<InternalDateHistogram.Bucket>((int)this.bucketOrds.size());
        for (long i = 0L; i < this.bucketOrds.size(); ++i) {
            buckets.add(new InternalDateHistogram.Bucket(this.bucketOrds.get(i), this.bucketDocCount(i), this.keyed, this.formatter, this.bucketAggregations(i)));
        }
        CollectionUtil.introSort(buckets, BucketOrder.key(true).comparator(this));
        InternalDateHistogram.EmptyBucketInfo emptyBucketInfo = this.minDocCount == 0L ? new InternalDateHistogram.EmptyBucketInfo(this.rounding, this.buildEmptySubAggregations(), this.extendedBounds) : null;
        return new InternalDateHistogram(this.name, buckets, this.order, this.minDocCount, this.offset, emptyBucketInfo, this.formatter, this.keyed, this.pipelineAggregators(), this.metaData());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        InternalDateHistogram.EmptyBucketInfo emptyBucketInfo = this.minDocCount == 0L ? new InternalDateHistogram.EmptyBucketInfo(this.rounding, this.buildEmptySubAggregations(), this.extendedBounds) : null;
        return new InternalDateHistogram(this.name, Collections.emptyList(), this.order, this.minDocCount, this.offset, emptyBucketInfo, this.formatter, this.keyed, this.pipelineAggregators(), this.metaData());
    }

    @Override
    public void doClose() {
        Releasables.close(this.bucketOrds);
    }
}

