/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.aggregations.metrics.cardinality;

import conductor.org.elasticsearch.common.xcontent.ObjectParser;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import conductor.org.elasticsearch.search.aggregations.Aggregation;
import conductor.org.elasticsearch.search.aggregations.ParsedAggregation;
import conductor.org.elasticsearch.search.aggregations.metrics.cardinality.Cardinality;
import java.io.IOException;

public class ParsedCardinality
extends ParsedAggregation
implements Cardinality {
    private long cardinalityValue;
    private static final ObjectParser<ParsedCardinality, Void> PARSER = new ObjectParser(ParsedCardinality.class.getSimpleName(), true, ParsedCardinality::new);

    @Override
    public String getValueAsString() {
        return Double.toString(this.cardinalityValue);
    }

    @Override
    public double value() {
        return this.getValue();
    }

    @Override
    public long getValue() {
        return this.cardinalityValue;
    }

    @Override
    public String getType() {
        return "cardinality";
    }

    public static ParsedCardinality fromXContent(XContentParser parser, String name) {
        ParsedCardinality cardinality = PARSER.apply(parser, null);
        cardinality.setName(name);
        return cardinality;
    }

    @Override
    protected XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(Aggregation.CommonFields.VALUE.getPreferredName(), this.cardinalityValue);
        return builder;
    }

    static {
        ParsedCardinality.declareAggregationFields(PARSER);
        PARSER.declareLong((agg, value) -> {
            agg.cardinalityValue = value;
        }, Aggregation.CommonFields.VALUE);
    }
}

