/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.aggregations.pipeline.bucketsort;

import conductor.org.elasticsearch.common.ParseField;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import conductor.org.elasticsearch.common.xcontent.ObjectParser;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import conductor.org.elasticsearch.search.aggregations.AggregationBuilder;
import conductor.org.elasticsearch.search.aggregations.AggregatorFactory;
import conductor.org.elasticsearch.search.aggregations.PipelineAggregationBuilder;
import conductor.org.elasticsearch.search.aggregations.pipeline.AbstractPipelineAggregationBuilder;
import conductor.org.elasticsearch.search.aggregations.pipeline.BucketHelpers;
import conductor.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import conductor.org.elasticsearch.search.aggregations.pipeline.bucketsort.BucketSortPipelineAggregator;
import conductor.org.elasticsearch.search.builder.SearchSourceBuilder;
import conductor.org.elasticsearch.search.sort.FieldSortBuilder;
import conductor.org.elasticsearch.search.sort.SortBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class BucketSortPipelineAggregationBuilder
extends AbstractPipelineAggregationBuilder<BucketSortPipelineAggregationBuilder> {
    public static final String NAME = "bucket_sort";
    private static final ParseField FROM = new ParseField("from", new String[0]);
    private static final ParseField SIZE = new ParseField("size", new String[0]);
    public static final ConstructingObjectParser<BucketSortPipelineAggregationBuilder, String> PARSER = new ConstructingObjectParser<BucketSortPipelineAggregationBuilder, String>("bucket_sort", false, (a, context) -> new BucketSortPipelineAggregationBuilder((String)context, (List)a[0]));
    private List<FieldSortBuilder> sorts = Collections.emptyList();
    private int from = 0;
    private Integer size;
    private BucketHelpers.GapPolicy gapPolicy = BucketHelpers.GapPolicy.SKIP;

    public BucketSortPipelineAggregationBuilder(String name, List<FieldSortBuilder> sorts) {
        super(name, NAME, sorts == null ? new String[]{} : (String[])sorts.stream().map(s -> s.getFieldName()).toArray(String[]::new));
        this.sorts = sorts == null ? Collections.emptyList() : sorts;
    }

    public BucketSortPipelineAggregationBuilder(StreamInput in) throws IOException {
        super(in, NAME);
        this.sorts = in.readList(FieldSortBuilder::new);
        this.from = in.readVInt();
        this.size = in.readOptionalVInt();
        this.gapPolicy = BucketHelpers.GapPolicy.readFrom(in);
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeList(this.sorts);
        out.writeVInt(this.from);
        out.writeOptionalVInt(this.size);
        this.gapPolicy.writeTo(out);
    }

    public BucketSortPipelineAggregationBuilder from(int from) {
        if (from < 0) {
            throw new IllegalArgumentException("[" + FROM.getPreferredName() + "] must be a non-negative integer: [" + from + "]");
        }
        this.from = from;
        return this;
    }

    public BucketSortPipelineAggregationBuilder size(Integer size) {
        if (size != null && size <= 0) {
            throw new IllegalArgumentException("[" + SIZE.getPreferredName() + "] must be a positive integer: [" + size + "]");
        }
        this.size = size;
        return this;
    }

    public BucketSortPipelineAggregationBuilder gapPolicy(BucketHelpers.GapPolicy gapPolicy) {
        if (gapPolicy == null) {
            throw new IllegalArgumentException("[" + PipelineAggregator.Parser.GAP_POLICY.getPreferredName() + "] must not be null: [" + this.name + "]");
        }
        this.gapPolicy = gapPolicy;
        return this;
    }

    @Override
    protected PipelineAggregator createInternal(Map<String, Object> metaData) throws IOException {
        return new BucketSortPipelineAggregator(this.name, this.sorts, this.from, this.size, this.gapPolicy, metaData);
    }

    @Override
    public void doValidate(AggregatorFactory<?> parent, Collection<AggregationBuilder> aggFactories, Collection<PipelineAggregationBuilder> pipelineAggregatoractories) {
        if (this.sorts.isEmpty() && this.size == null && this.from == 0) {
            throw new IllegalStateException("[" + this.name + "] is configured to perform nothing. Please set either of " + Arrays.asList(SearchSourceBuilder.SORT_FIELD.getPreferredName(), SIZE.getPreferredName(), FROM.getPreferredName()) + " to use " + NAME);
        }
    }

    @Override
    protected XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(SearchSourceBuilder.SORT_FIELD.getPreferredName(), this.sorts);
        builder.field(FROM.getPreferredName(), this.from);
        if (this.size != null) {
            builder.field(SIZE.getPreferredName(), this.size);
        }
        builder.field(PipelineAggregator.Parser.GAP_POLICY.getPreferredName(), (Object)this.gapPolicy);
        return builder;
    }

    public static BucketSortPipelineAggregationBuilder parse(String reducerName, XContentParser parser) throws IOException {
        return PARSER.parse(parser, reducerName);
    }

    @Override
    protected boolean overrideBucketsPath() {
        return true;
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(new Object[]{this.sorts, this.from, this.size, this.gapPolicy});
    }

    @Override
    protected boolean doEquals(Object obj) {
        BucketSortPipelineAggregationBuilder other = (BucketSortPipelineAggregationBuilder)obj;
        return Objects.equals(this.sorts, other.sorts) && Objects.equals(this.from, other.from) && Objects.equals(this.size, other.size) && Objects.equals((Object)this.gapPolicy, (Object)other.gapPolicy);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    static {
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> {
            List<SortBuilder<?>> sorts = SortBuilder.fromXContent(p);
            ArrayList<FieldSortBuilder> fieldSorts = new ArrayList<FieldSortBuilder>(sorts.size());
            for (SortBuilder<?> sort : sorts) {
                if (!(sort instanceof FieldSortBuilder)) {
                    throw new IllegalArgumentException("[bucket_sort] only supports field based sorting; incompatible sort: [" + sort + "]");
                }
                fieldSorts.add((FieldSortBuilder)sort);
            }
            return fieldSorts;
        }, SearchSourceBuilder.SORT_FIELD, ObjectParser.ValueType.OBJECT_ARRAY);
        PARSER.declareInt(BucketSortPipelineAggregationBuilder::from, FROM);
        PARSER.declareInt(BucketSortPipelineAggregationBuilder::size, SIZE);
        PARSER.declareField(BucketSortPipelineAggregationBuilder::gapPolicy, p -> {
            if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                return BucketHelpers.GapPolicy.parse(p.text().toLowerCase(Locale.ROOT), p.getTokenLocation());
            }
            throw new IllegalArgumentException("Unsupported token [" + (Object)((Object)p.currentToken()) + "]");
        }, PipelineAggregator.Parser.GAP_POLICY, ObjectParser.ValueType.STRING);
    }
}

