/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.lookup;

import conductor.org.apache.lucene.index.LeafReader;
import conductor.org.elasticsearch.ElasticsearchParseException;
import conductor.org.elasticsearch.common.Nullable;
import conductor.org.elasticsearch.index.fieldvisitor.SingleFieldsVisitor;
import conductor.org.elasticsearch.index.mapper.MappedFieldType;
import conductor.org.elasticsearch.index.mapper.MapperService;
import conductor.org.elasticsearch.search.lookup.FieldLookup;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LeafFieldsLookup
implements Map {
    private final MapperService mapperService;
    private final boolean singleType;
    @Nullable
    private final String[] types;
    private final LeafReader reader;
    private int docId = -1;
    private final Map<String, FieldLookup> cachedFieldData = new HashMap<String, FieldLookup>();
    private final SingleFieldsVisitor fieldVisitor;

    LeafFieldsLookup(MapperService mapperService, @Nullable String[] types, LeafReader reader) {
        this.mapperService = mapperService;
        this.singleType = mapperService.getIndexSettings().isSingleType();
        this.types = types;
        this.reader = reader;
        this.fieldVisitor = new SingleFieldsVisitor(null);
    }

    public void setDocument(int docId) {
        if (this.docId == docId) {
            return;
        }
        this.docId = docId;
        this.clearCache();
    }

    public Object get(Object key) {
        return this.loadFieldData(key.toString());
    }

    @Override
    public boolean containsKey(Object key) {
        try {
            this.loadFieldData(key.toString());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException();
    }

    public Set keySet() {
        throw new UnsupportedOperationException();
    }

    public Collection values() {
        throw new UnsupportedOperationException();
    }

    public Set entrySet() {
        throw new UnsupportedOperationException();
    }

    public Object put(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    private FieldLookup loadFieldData(String name) {
        FieldLookup data = this.cachedFieldData.get(name);
        if (data == null) {
            MappedFieldType fieldType = this.mapperService.fullName(name);
            if (fieldType == null) {
                throw new IllegalArgumentException("No field found for [" + name + "] in mapping with types " + Arrays.toString(this.types));
            }
            data = new FieldLookup(fieldType);
            this.cachedFieldData.put(name, data);
        }
        if (data.fields() == null) {
            String fieldName;
            String lookupField = fieldName = data.fieldType().name();
            if (this.singleType && "_uid".equals(fieldName)) {
                lookupField = "_id";
            }
            this.fieldVisitor.reset(lookupField);
            try {
                this.reader.document(this.docId, this.fieldVisitor);
                this.fieldVisitor.postProcess(this.mapperService);
                List<Object> storedFields = this.fieldVisitor.fields().get(fieldName);
                data.fields(Collections.singletonMap(fieldName, storedFields));
            }
            catch (IOException e) {
                throw new ElasticsearchParseException("failed to load field [{}]", (Throwable)e, name);
            }
        }
        return data;
    }

    private void clearCache() {
        for (Map.Entry<String, FieldLookup> entry : this.cachedFieldData.entrySet()) {
            entry.getValue().clear();
        }
    }
}

