/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.elasticsearch.es6;

import com.netflix.conductor.elasticsearch.ElasticSearchConfiguration;
import com.netflix.conductor.elasticsearch.EmbeddedElasticSearch;
import com.netflix.conductor.elasticsearch.EmbeddedElasticSearchProvider;
import com.netflix.conductor.elasticsearch.es6.EmbeddedElasticSearchV6;
import java.util.Optional;
import javax.inject.Inject;

public class EmbeddedElasticSearchV6Provider
implements EmbeddedElasticSearchProvider {
    private final ElasticSearchConfiguration configuration;

    @Inject
    public EmbeddedElasticSearchV6Provider(ElasticSearchConfiguration configuration) {
        this.configuration = configuration;
    }

    public Optional<EmbeddedElasticSearch> get() {
        return this.isEmbedded() ? Optional.of(new EmbeddedElasticSearchV6(this.configuration.getEmbeddedClusterName(), this.configuration.getEmbeddedHost(), this.configuration.getEmbeddedPort())) : Optional.empty();
    }

    private boolean isEmbedded() {
        return this.configuration.getElasticSearchInstanceType().equals((Object)ElasticSearchConfiguration.ElasticSearchInstanceType.MEMORY);
    }
}

