/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.analysis.commongrams;

import conductor.org.apache.lucene.analysis.CharArraySet;
import conductor.org.apache.lucene.analysis.TokenFilter;
import conductor.org.apache.lucene.analysis.TokenStream;
import conductor.org.apache.lucene.analysis.commongrams.CommonGramsFilter;
import conductor.org.apache.lucene.analysis.en.EnglishAnalyzer;
import conductor.org.apache.lucene.analysis.util.ResourceLoader;
import conductor.org.apache.lucene.analysis.util.ResourceLoaderAware;
import conductor.org.apache.lucene.analysis.util.TokenFilterFactory;
import java.io.IOException;
import java.util.Map;

public class CommonGramsFilterFactory
extends TokenFilterFactory
implements ResourceLoaderAware {
    private CharArraySet commonWords;
    private final String commonWordFiles;
    private final String format;
    private final boolean ignoreCase;

    public CommonGramsFilterFactory(Map<String, String> args) {
        super(args);
        this.commonWordFiles = this.get(args, "words");
        this.format = this.get(args, "format");
        this.ignoreCase = this.getBoolean(args, "ignoreCase", false);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    @Override
    public void inform(ResourceLoader loader) throws IOException {
        this.commonWords = this.commonWordFiles != null ? ("snowball".equalsIgnoreCase(this.format) ? this.getSnowballWordSet(loader, this.commonWordFiles, this.ignoreCase) : this.getWordSet(loader, this.commonWordFiles, this.ignoreCase)) : EnglishAnalyzer.ENGLISH_STOP_WORDS_SET;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public CharArraySet getCommonWords() {
        return this.commonWords;
    }

    @Override
    public TokenFilter create(TokenStream input) {
        CommonGramsFilter commonGrams = new CommonGramsFilter(input, this.commonWords);
        return commonGrams;
    }
}

