/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.document;

import conductor.org.apache.lucene.document.Field;
import conductor.org.apache.lucene.document.FieldType;
import conductor.org.apache.lucene.document.LatLonShapeBoundingBoxQuery;
import conductor.org.apache.lucene.document.LatLonShapePolygonQuery;
import conductor.org.apache.lucene.geo.GeoEncodingUtils;
import conductor.org.apache.lucene.geo.Line;
import conductor.org.apache.lucene.geo.Polygon;
import conductor.org.apache.lucene.geo.Tessellator;
import conductor.org.apache.lucene.search.Query;
import conductor.org.apache.lucene.util.BytesRef;
import conductor.org.apache.lucene.util.NumericUtils;
import java.util.ArrayList;
import java.util.List;

public class LatLonShape {
    public static final int BYTES = 4;
    protected static final FieldType TYPE = new FieldType();

    private LatLonShape() {
    }

    public static Field[] createIndexableFields(String fieldName, Polygon polygon) {
        List<Tessellator.Triangle> tessellation = Tessellator.tessellate(polygon);
        ArrayList<LatLonTriangle> fields = new ArrayList<LatLonTriangle>();
        for (Tessellator.Triangle t : tessellation) {
            fields.add(new LatLonTriangle(fieldName, t.getEncodedX(0), t.getEncodedY(0), t.getEncodedX(1), t.getEncodedY(1), t.getEncodedX(2), t.getEncodedY(2)));
        }
        return fields.toArray(new Field[fields.size()]);
    }

    public static Field[] createIndexableFields(String fieldName, Line line) {
        int numPoints = line.numPoints();
        ArrayList<LatLonTriangle> fields = new ArrayList<LatLonTriangle>(numPoints - 1);
        int[] encodedLats = new int[numPoints];
        int[] encodedLons = new int[numPoints];
        for (int i = 0; i < numPoints; ++i) {
            encodedLats[i] = GeoEncodingUtils.encodeLatitude(line.getLat(i));
            encodedLons[i] = GeoEncodingUtils.encodeLongitude(line.getLon(i));
        }
        int i = 0;
        for (int j = 1; j < numPoints; ++j) {
            int temp;
            int aLat = encodedLats[i];
            int aLon = encodedLons[i];
            int bLat = encodedLats[j];
            int bLon = encodedLons[j];
            if (aLat > bLat) {
                temp = aLat;
                aLat = bLat;
                bLat = temp;
                temp = aLon;
                aLon = bLon;
                bLon = temp;
            } else if (aLat == bLat && aLon > bLon) {
                temp = aLat;
                aLat = bLat;
                bLat = temp;
                temp = aLon;
                aLon = bLon;
                bLon = temp;
            }
            fields.add(new LatLonTriangle(fieldName, aLon, aLat, bLon, bLat, aLon, aLat));
            ++i;
        }
        return fields.toArray(new Field[fields.size()]);
    }

    public static Field[] createIndexableFields(String fieldName, double lat, double lon) {
        int encodedLat = GeoEncodingUtils.encodeLatitude(lat);
        int encodedLon = GeoEncodingUtils.encodeLongitude(lon);
        return new Field[]{new LatLonTriangle(fieldName, encodedLon, encodedLat, encodedLon, encodedLat, encodedLon, encodedLat)};
    }

    public static Query newBoxQuery(String field, QueryRelation queryRelation, double minLatitude, double maxLatitude, double minLongitude, double maxLongitude) {
        return new LatLonShapeBoundingBoxQuery(field, queryRelation, minLatitude, maxLatitude, minLongitude, maxLongitude);
    }

    public static Query newPolygonQuery(String field, QueryRelation queryRelation, Polygon ... polygons) {
        return new LatLonShapePolygonQuery(field, queryRelation, polygons);
    }

    static {
        TYPE.setDimensions(6, 4);
        TYPE.freeze();
    }

    public static enum QueryRelation {
        INTERSECTS,
        WITHIN,
        DISJOINT;

    }

    private static class LatLonTriangle
    extends Field {
        LatLonTriangle(String name, int ax, int ay, int bx, int by, int cx, int cy) {
            super(name, TYPE);
            this.setTriangleValue(ax, ay, bx, by, cx, cy);
        }

        public void setTriangleValue(int aX, int aY, int bX, int bY, int cX, int cY) {
            byte[] bytes;
            if (this.fieldsData == null) {
                bytes = new byte[24];
                this.fieldsData = new BytesRef(bytes);
            } else {
                bytes = ((BytesRef)this.fieldsData).bytes;
            }
            NumericUtils.intToSortableBytes(aY, bytes, 0);
            NumericUtils.intToSortableBytes(aX, bytes, 4);
            NumericUtils.intToSortableBytes(bY, bytes, 8);
            NumericUtils.intToSortableBytes(bX, bytes, 12);
            NumericUtils.intToSortableBytes(cY, bytes, 16);
            NumericUtils.intToSortableBytes(cX, bytes, 20);
        }
    }
}

