/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.queryparser.flexible.standard.builders;

import conductor.org.apache.lucene.queryparser.flexible.core.QueryNodeException;
import conductor.org.apache.lucene.queryparser.flexible.core.builders.QueryTreeBuilder;
import conductor.org.apache.lucene.queryparser.flexible.core.nodes.FieldQueryNode;
import conductor.org.apache.lucene.queryparser.flexible.core.nodes.QueryNode;
import conductor.org.apache.lucene.queryparser.flexible.core.nodes.TokenizedPhraseQueryNode;
import conductor.org.apache.lucene.queryparser.flexible.standard.builders.StandardQueryBuilder;
import conductor.org.apache.lucene.search.PhraseQuery;
import conductor.org.apache.lucene.search.Query;
import conductor.org.apache.lucene.search.TermQuery;
import java.util.List;

public class PhraseQueryNodeBuilder
implements StandardQueryBuilder {
    @Override
    public Query build(QueryNode queryNode) throws QueryNodeException {
        TokenizedPhraseQueryNode phraseNode = (TokenizedPhraseQueryNode)queryNode;
        PhraseQuery.Builder builder = new PhraseQuery.Builder();
        List<QueryNode> children = phraseNode.getChildren();
        if (children != null) {
            for (QueryNode child : children) {
                TermQuery termQuery = (TermQuery)child.getTag(QueryTreeBuilder.QUERY_TREE_BUILDER_TAGID);
                FieldQueryNode termNode = (FieldQueryNode)child;
                builder.add(termQuery.getTerm(), termNode.getPositionIncrement());
            }
        }
        return builder.build();
    }
}

