/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.search;

import conductor.org.apache.lucene.search.BooleanClause;
import conductor.org.apache.lucene.search.BooleanWeight;
import conductor.org.apache.lucene.search.ConjunctionScorer;
import conductor.org.apache.lucene.search.DisjunctionSumScorer;
import conductor.org.apache.lucene.search.FilterScorer;
import conductor.org.apache.lucene.search.MinShouldMatchSumScorer;
import conductor.org.apache.lucene.search.ReqExclScorer;
import conductor.org.apache.lucene.search.ReqOptSumScorer;
import conductor.org.apache.lucene.search.Scorer;
import conductor.org.apache.lucene.search.ScorerSupplier;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.OptionalLong;
import java.util.stream.Stream;

final class Boolean2ScorerSupplier
extends ScorerSupplier {
    private final BooleanWeight weight;
    private final Map<BooleanClause.Occur, Collection<ScorerSupplier>> subs;
    private final boolean needsScores;
    private final int minShouldMatch;
    private long cost = -1L;

    Boolean2ScorerSupplier(BooleanWeight weight, Map<BooleanClause.Occur, Collection<ScorerSupplier>> subs, boolean needsScores, int minShouldMatch) {
        if (minShouldMatch < 0) {
            throw new IllegalArgumentException("minShouldMatch must be positive, but got: " + minShouldMatch);
        }
        if (minShouldMatch != 0 && minShouldMatch >= subs.get((Object)BooleanClause.Occur.SHOULD).size()) {
            throw new IllegalArgumentException("minShouldMatch must be strictly less than the number of SHOULD clauses");
        }
        if (!needsScores && minShouldMatch == 0 && subs.get((Object)BooleanClause.Occur.SHOULD).size() > 0 && subs.get((Object)BooleanClause.Occur.MUST).size() + subs.get((Object)BooleanClause.Occur.FILTER).size() > 0) {
            throw new IllegalArgumentException("Cannot pass purely optional clauses if scores are not needed");
        }
        if (subs.get((Object)BooleanClause.Occur.SHOULD).size() + subs.get((Object)BooleanClause.Occur.MUST).size() + subs.get((Object)BooleanClause.Occur.FILTER).size() == 0) {
            throw new IllegalArgumentException("There should be at least one positive clause");
        }
        this.weight = weight;
        this.subs = subs;
        this.needsScores = needsScores;
        this.minShouldMatch = minShouldMatch;
    }

    private long computeCost() {
        OptionalLong minRequiredCost = Stream.concat(this.subs.get((Object)BooleanClause.Occur.MUST).stream(), this.subs.get((Object)BooleanClause.Occur.FILTER).stream()).mapToLong(ScorerSupplier::cost).min();
        if (minRequiredCost.isPresent() && this.minShouldMatch == 0) {
            return minRequiredCost.getAsLong();
        }
        Collection<ScorerSupplier> optionalScorers = this.subs.get((Object)BooleanClause.Occur.SHOULD);
        long shouldCost = MinShouldMatchSumScorer.cost(optionalScorers.stream().mapToLong(ScorerSupplier::cost), optionalScorers.size(), this.minShouldMatch);
        return Math.min(minRequiredCost.orElse(Long.MAX_VALUE), shouldCost);
    }

    @Override
    public long cost() {
        if (this.cost == -1L) {
            this.cost = this.computeCost();
        }
        return this.cost;
    }

    @Override
    public Scorer get(long leadCost) throws IOException {
        leadCost = Math.min(leadCost, this.cost());
        if (this.subs.get((Object)BooleanClause.Occur.SHOULD).isEmpty()) {
            return this.excl(this.req(this.subs.get((Object)BooleanClause.Occur.FILTER), this.subs.get((Object)BooleanClause.Occur.MUST), leadCost), this.subs.get((Object)BooleanClause.Occur.MUST_NOT), leadCost);
        }
        if (this.subs.get((Object)BooleanClause.Occur.FILTER).isEmpty() && this.subs.get((Object)BooleanClause.Occur.MUST).isEmpty()) {
            return this.excl(this.opt(this.subs.get((Object)BooleanClause.Occur.SHOULD), this.minShouldMatch, this.needsScores, leadCost), this.subs.get((Object)BooleanClause.Occur.MUST_NOT), leadCost);
        }
        if (this.minShouldMatch > 0) {
            Scorer req = this.excl(this.req(this.subs.get((Object)BooleanClause.Occur.FILTER), this.subs.get((Object)BooleanClause.Occur.MUST), leadCost), this.subs.get((Object)BooleanClause.Occur.MUST_NOT), leadCost);
            Scorer opt = this.opt(this.subs.get((Object)BooleanClause.Occur.SHOULD), this.minShouldMatch, this.needsScores, leadCost);
            return new ConjunctionScorer(this.weight, Arrays.asList(req, opt), Arrays.asList(req, opt));
        }
        assert (this.needsScores);
        return new ReqOptSumScorer(this.excl(this.req(this.subs.get((Object)BooleanClause.Occur.FILTER), this.subs.get((Object)BooleanClause.Occur.MUST), leadCost), this.subs.get((Object)BooleanClause.Occur.MUST_NOT), leadCost), this.opt(this.subs.get((Object)BooleanClause.Occur.SHOULD), this.minShouldMatch, this.needsScores, leadCost));
    }

    private Scorer req(Collection<ScorerSupplier> requiredNoScoring, Collection<ScorerSupplier> requiredScoring, long leadCost) throws IOException {
        if (requiredNoScoring.size() + requiredScoring.size() == 1) {
            Scorer req = (requiredNoScoring.isEmpty() ? requiredScoring : requiredNoScoring).iterator().next().get(leadCost);
            if (!this.needsScores) {
                return req;
            }
            if (requiredScoring.isEmpty()) {
                return new FilterScorer(req){

                    @Override
                    public float score() throws IOException {
                        return 0.0f;
                    }
                };
            }
            return req;
        }
        ArrayList<Scorer> requiredScorers = new ArrayList<Scorer>();
        ArrayList<Scorer> scoringScorers = new ArrayList<Scorer>();
        for (ScorerSupplier s : requiredNoScoring) {
            requiredScorers.add(s.get(leadCost));
        }
        for (ScorerSupplier s : requiredScoring) {
            Scorer scorer = s.get(leadCost);
            requiredScorers.add(scorer);
            scoringScorers.add(scorer);
        }
        return new ConjunctionScorer(this.weight, requiredScorers, scoringScorers);
    }

    private Scorer excl(Scorer main, Collection<ScorerSupplier> prohibited, long leadCost) throws IOException {
        if (prohibited.isEmpty()) {
            return main;
        }
        return new ReqExclScorer(main, this.opt(prohibited, 1, false, leadCost));
    }

    private Scorer opt(Collection<ScorerSupplier> optional, int minShouldMatch, boolean needsScores, long leadCost) throws IOException {
        if (optional.size() == 1) {
            return optional.iterator().next().get(leadCost);
        }
        ArrayList<Scorer> optionalScorers = new ArrayList<Scorer>();
        for (ScorerSupplier scorer : optional) {
            optionalScorers.add(scorer.get(leadCost));
        }
        if (minShouldMatch > 1) {
            return new MinShouldMatchSumScorer(this.weight, optionalScorers, minShouldMatch);
        }
        return new DisjunctionSumScorer(this.weight, optionalScorers, needsScores);
    }
}

