/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.client.transport;

import conductor.org.elasticsearch.action.Action;
import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.action.ActionModule;
import conductor.org.elasticsearch.action.ActionRequest;
import conductor.org.elasticsearch.action.ActionRequestBuilder;
import conductor.org.elasticsearch.action.ActionResponse;
import conductor.org.elasticsearch.action.GenericAction;
import conductor.org.elasticsearch.client.support.AbstractClient;
import conductor.org.elasticsearch.client.transport.TransportClientNodesService;
import conductor.org.elasticsearch.client.transport.TransportProxyClient;
import conductor.org.elasticsearch.cluster.ClusterModule;
import conductor.org.elasticsearch.cluster.node.DiscoveryNode;
import conductor.org.elasticsearch.common.UUIDs;
import conductor.org.elasticsearch.common.component.LifecycleComponent;
import conductor.org.elasticsearch.common.inject.Injector;
import conductor.org.elasticsearch.common.inject.Module;
import conductor.org.elasticsearch.common.inject.ModulesBuilder;
import conductor.org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import conductor.org.elasticsearch.common.network.NetworkModule;
import conductor.org.elasticsearch.common.network.NetworkService;
import conductor.org.elasticsearch.common.settings.Setting;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.common.settings.SettingsModule;
import conductor.org.elasticsearch.common.transport.TransportAddress;
import conductor.org.elasticsearch.common.unit.TimeValue;
import conductor.org.elasticsearch.common.util.BigArrays;
import conductor.org.elasticsearch.common.util.PageCacheRecycler;
import conductor.org.elasticsearch.common.xcontent.NamedXContentRegistry;
import conductor.org.elasticsearch.core.internal.io.IOUtils;
import conductor.org.elasticsearch.indices.IndicesModule;
import conductor.org.elasticsearch.indices.breaker.CircuitBreakerService;
import conductor.org.elasticsearch.node.InternalSettingsPreparer;
import conductor.org.elasticsearch.node.Node;
import conductor.org.elasticsearch.plugins.ActionPlugin;
import conductor.org.elasticsearch.plugins.NetworkPlugin;
import conductor.org.elasticsearch.plugins.Plugin;
import conductor.org.elasticsearch.plugins.PluginsService;
import conductor.org.elasticsearch.plugins.SearchPlugin;
import conductor.org.elasticsearch.search.SearchModule;
import conductor.org.elasticsearch.threadpool.ExecutorBuilder;
import conductor.org.elasticsearch.threadpool.ThreadPool;
import conductor.org.elasticsearch.transport.TcpTransport;
import conductor.org.elasticsearch.transport.Transport;
import conductor.org.elasticsearch.transport.TransportService;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class TransportClient
extends AbstractClient {
    public static final Setting<TimeValue> CLIENT_TRANSPORT_NODES_SAMPLER_INTERVAL = Setting.positiveTimeSetting("client.transport.nodes_sampler_interval", TimeValue.timeValueSeconds(5L), Setting.Property.NodeScope);
    public static final Setting<TimeValue> CLIENT_TRANSPORT_PING_TIMEOUT = Setting.positiveTimeSetting("client.transport.ping_timeout", TimeValue.timeValueSeconds(5L), Setting.Property.NodeScope);
    public static final Setting<Boolean> CLIENT_TRANSPORT_IGNORE_CLUSTER_NAME = Setting.boolSetting("client.transport.ignore_cluster_name", false, Setting.Property.NodeScope);
    public static final Setting<Boolean> CLIENT_TRANSPORT_SNIFF = Setting.boolSetting("client.transport.sniff", false, Setting.Property.NodeScope);
    public static final String TRANSPORT_CLIENT_FEATURE = "transport_client";
    public static final String CLIENT_TYPE = "transport";
    final Injector injector;
    protected final NamedWriteableRegistry namedWriteableRegistry;
    private final List<LifecycleComponent> pluginLifecycleComponents;
    private final TransportClientNodesService nodesService;
    private final TransportProxyClient proxy;

    private static PluginsService newPluginService(Settings settings, Collection<Class<? extends Plugin>> plugins) {
        Settings.Builder settingsBuilder = Settings.builder().put(TcpTransport.PING_SCHEDULE.getKey(), "5s").put(InternalSettingsPreparer.prepareSettings(settings)).put(NetworkService.NETWORK_SERVER.getKey(), false).put(CLIENT_TYPE_SETTING_S.getKey(), CLIENT_TYPE);
        return new PluginsService(settingsBuilder.build(), null, null, null, plugins);
    }

    protected static Collection<Class<? extends Plugin>> addPlugins(Collection<Class<? extends Plugin>> collection, Class<? extends Plugin> ... plugins) {
        return TransportClient.addPlugins(collection, Arrays.asList(plugins));
    }

    protected static Collection<Class<? extends Plugin>> addPlugins(Collection<Class<? extends Plugin>> collection, Collection<Class<? extends Plugin>> plugins) {
        ArrayList<Class<? extends Plugin>> list = new ArrayList<Class<? extends Plugin>>(collection);
        for (Class<? extends Plugin> p : plugins) {
            if (list.contains(p)) {
                throw new IllegalArgumentException("plugin already exists: " + p);
            }
            list.add(p);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ClientTemplate buildTemplate(Settings providedSettings, Settings defaultSettings, Collection<Class<? extends Plugin>> plugins, HostFailureListener failureListner) {
        if (!Node.NODE_NAME_SETTING.exists(providedSettings)) {
            providedSettings = Settings.builder().put(providedSettings).put(Node.NODE_NAME_SETTING.getKey(), "_client_").build();
        }
        PluginsService pluginsService = TransportClient.newPluginService(providedSettings, plugins);
        Settings settings = Settings.builder().put(defaultSettings).put(pluginsService.updatedSettings()).put("transport.features.transport_client", true).build();
        ArrayList<Closeable> resourcesToClose = new ArrayList<Closeable>();
        ThreadPool threadPool = new ThreadPool(settings, new ExecutorBuilder[0]);
        resourcesToClose.add(() -> ThreadPool.terminate(threadPool, 10L, TimeUnit.SECONDS));
        NetworkService networkService = new NetworkService(Collections.emptyList());
        try {
            ArrayList additionalSettings = new ArrayList(pluginsService.getPluginSettings());
            ArrayList<String> additionalSettingsFilter = new ArrayList<String>(pluginsService.getPluginSettingsFilter());
            for (ExecutorBuilder builder : threadPool.builders()) {
                additionalSettings.addAll(builder.getRegisteredSettings());
            }
            SettingsModule settingsModule = new SettingsModule(settings, additionalSettings, additionalSettingsFilter, Collections.emptySet());
            SearchModule searchModule = new SearchModule(settings, true, pluginsService.filterPlugins(SearchPlugin.class));
            IndicesModule indicesModule = new IndicesModule(Collections.emptyList());
            ArrayList<NamedWriteableRegistry.Entry> entries = new ArrayList<NamedWriteableRegistry.Entry>();
            entries.addAll(NetworkModule.getNamedWriteables());
            entries.addAll(searchModule.getNamedWriteables());
            entries.addAll(indicesModule.getNamedWriteables());
            entries.addAll(ClusterModule.getNamedWriteables());
            entries.addAll(pluginsService.filterPlugins(Plugin.class).stream().flatMap(p -> p.getNamedWriteables().stream()).collect(Collectors.toList()));
            NamedWriteableRegistry namedWriteableRegistry = new NamedWriteableRegistry(entries);
            NamedXContentRegistry xContentRegistry = new NamedXContentRegistry(Stream.of(searchModule.getNamedXContents().stream(), pluginsService.filterPlugins(Plugin.class).stream().flatMap(p -> p.getNamedXContent().stream())).flatMap(Function.identity()).collect(Collectors.toList()));
            ModulesBuilder modules = new ModulesBuilder();
            for (Module pluginModule : pluginsService.createGuiceModules()) {
                modules.add(pluginModule);
            }
            modules.add(b -> b.bind(ThreadPool.class).toInstance(threadPool));
            ActionModule actionModule = new ActionModule(true, settings, null, settingsModule.getIndexScopedSettings(), settingsModule.getClusterSettings(), settingsModule.getSettingsFilter(), threadPool, pluginsService.filterPlugins(ActionPlugin.class), null, null, null);
            modules.add(actionModule);
            CircuitBreakerService circuitBreakerService = Node.createCircuitBreakerService(settingsModule.getSettings(), settingsModule.getClusterSettings());
            resourcesToClose.add(circuitBreakerService);
            PageCacheRecycler pageCacheRecycler = new PageCacheRecycler(settings);
            BigArrays bigArrays = new BigArrays(pageCacheRecycler, circuitBreakerService);
            resourcesToClose.add(bigArrays);
            modules.add(settingsModule);
            NetworkModule networkModule = new NetworkModule(settings, true, pluginsService.filterPlugins(NetworkPlugin.class), threadPool, bigArrays, pageCacheRecycler, circuitBreakerService, namedWriteableRegistry, xContentRegistry, networkService, null);
            Transport transport = networkModule.getTransportSupplier().get();
            TransportService transportService = new TransportService(settings, transport, threadPool, networkModule.getTransportInterceptor(), boundTransportAddress -> DiscoveryNode.createLocal(settings, new TransportAddress(TransportAddress.META_ADDRESS, 0), UUIDs.randomBase64UUID()), null, Collections.emptySet());
            modules.add(b -> {
                b.bind(BigArrays.class).toInstance(bigArrays);
                b.bind(PluginsService.class).toInstance(pluginsService);
                b.bind(CircuitBreakerService.class).toInstance(circuitBreakerService);
                b.bind(NamedWriteableRegistry.class).toInstance(namedWriteableRegistry);
                b.bind(Transport.class).toInstance(transport);
                b.bind(TransportService.class).toInstance(transportService);
                b.bind(NetworkService.class).toInstance(networkService);
            });
            Injector injector = modules.createInjector();
            TransportClientNodesService nodesService = new TransportClientNodesService(settings, transportService, threadPool, failureListner == null ? (t, e) -> {} : failureListner);
            List<ActionPlugin> actionPlugins = pluginsService.filterPlugins(ActionPlugin.class);
            List<GenericAction> clientActions = actionPlugins.stream().flatMap(p -> p.getClientActions().stream()).collect(Collectors.toList());
            List baseActions = actionModule.getActions().values().stream().map(ActionPlugin.ActionHandler::getAction).collect(Collectors.toList());
            clientActions.addAll(baseActions);
            TransportProxyClient proxy = new TransportProxyClient(settings, transportService, nodesService, clientActions);
            ArrayList pluginLifecycleComponents = new ArrayList(pluginsService.getGuiceServiceClasses().stream().map(injector::getInstance).collect(Collectors.toList()));
            resourcesToClose.addAll(pluginLifecycleComponents);
            transportService.start();
            transportService.acceptIncomingRequests();
            ClientTemplate transportClient = new ClientTemplate(injector, pluginLifecycleComponents, nodesService, proxy, namedWriteableRegistry);
            resourcesToClose.clear();
            ClientTemplate clientTemplate = transportClient;
            return clientTemplate;
        }
        finally {
            IOUtils.closeWhileHandlingException(resourcesToClose);
        }
    }

    public TransportClient(Settings settings, Collection<Class<? extends Plugin>> plugins) {
        this(TransportClient.buildTemplate(settings, Settings.EMPTY, plugins, null));
    }

    protected TransportClient(Settings settings, Settings defaultSettings, Collection<Class<? extends Plugin>> plugins, HostFailureListener hostFailureListener) {
        this(TransportClient.buildTemplate(settings, defaultSettings, plugins, hostFailureListener));
    }

    private TransportClient(ClientTemplate template) {
        super(template.getSettings(), template.getThreadPool());
        this.injector = template.injector;
        this.pluginLifecycleComponents = Collections.unmodifiableList(template.pluginLifecycleComponents);
        this.nodesService = template.nodesService;
        this.proxy = template.proxy;
        this.namedWriteableRegistry = template.namedWriteableRegistry;
    }

    public List<TransportAddress> transportAddresses() {
        return this.nodesService.transportAddresses();
    }

    public List<DiscoveryNode> connectedNodes() {
        return this.nodesService.connectedNodes();
    }

    public List<DiscoveryNode> filteredNodes() {
        return this.nodesService.filteredNodes();
    }

    public List<DiscoveryNode> listedNodes() {
        return this.nodesService.listedNodes();
    }

    public TransportClient addTransportAddress(TransportAddress transportAddress) {
        this.nodesService.addTransportAddresses(transportAddress);
        return this;
    }

    public TransportClient addTransportAddresses(TransportAddress ... transportAddress) {
        this.nodesService.addTransportAddresses(transportAddress);
        return this;
    }

    public TransportClient removeTransportAddress(TransportAddress transportAddress) {
        this.nodesService.removeTransportAddress(transportAddress);
        return this;
    }

    @Override
    public void close() {
        ArrayList<Closeable> closeables = new ArrayList<Closeable>();
        closeables.add(this.nodesService);
        closeables.add(this.injector.getInstance(TransportService.class));
        for (LifecycleComponent plugin : this.pluginLifecycleComponents) {
            closeables.add(plugin);
        }
        closeables.add(() -> ThreadPool.terminate(this.injector.getInstance(ThreadPool.class), 10L, TimeUnit.SECONDS));
        closeables.add(this.injector.getInstance(BigArrays.class));
        IOUtils.closeWhileHandlingException(closeables);
    }

    @Override
    protected <Request extends ActionRequest, Response extends ActionResponse, RequestBuilder extends ActionRequestBuilder<Request, Response, RequestBuilder>> void doExecute(Action<Request, Response, RequestBuilder> action, Request request, ActionListener<Response> listener) {
        this.proxy.execute(action, request, listener);
    }

    TransportClientNodesService getNodesService() {
        return this.nodesService;
    }

    @FunctionalInterface
    public static interface HostFailureListener {
        public void onNodeDisconnected(DiscoveryNode var1, Exception var2);
    }

    private static final class ClientTemplate {
        final Injector injector;
        private final List<LifecycleComponent> pluginLifecycleComponents;
        private final TransportClientNodesService nodesService;
        private final TransportProxyClient proxy;
        private final NamedWriteableRegistry namedWriteableRegistry;

        private ClientTemplate(Injector injector, List<LifecycleComponent> pluginLifecycleComponents, TransportClientNodesService nodesService, TransportProxyClient proxy, NamedWriteableRegistry namedWriteableRegistry) {
            this.injector = injector;
            this.pluginLifecycleComponents = pluginLifecycleComponents;
            this.nodesService = nodesService;
            this.proxy = proxy;
            this.namedWriteableRegistry = namedWriteableRegistry;
        }

        Settings getSettings() {
            return this.injector.getInstance(Settings.class);
        }

        ThreadPool getThreadPool() {
            return this.injector.getInstance(ThreadPool.class);
        }
    }
}

