/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.analysis;

import conductor.org.elasticsearch.Version;
import conductor.org.elasticsearch.index.analysis.CharFilterFactory;
import conductor.org.elasticsearch.index.analysis.MultiTermAwareComponent;
import conductor.org.elasticsearch.index.analysis.PreConfiguredAnalysisComponent;
import conductor.org.elasticsearch.indices.analysis.PreBuiltCacheFactory;
import java.io.Reader;
import java.util.function.BiFunction;
import java.util.function.Function;

public class PreConfiguredCharFilter
extends PreConfiguredAnalysisComponent<CharFilterFactory> {
    private final boolean useFilterForMultitermQueries;
    private final BiFunction<Reader, Version, Reader> create;

    public static PreConfiguredCharFilter singleton(String name, boolean useFilterForMultitermQueries, Function<Reader, Reader> create) {
        return new PreConfiguredCharFilter(name, PreBuiltCacheFactory.CachingStrategy.ONE, useFilterForMultitermQueries, (reader, version) -> (Reader)create.apply((Reader)reader));
    }

    public static PreConfiguredCharFilter singletonWithVersion(String name, boolean useFilterForMultitermQueries, BiFunction<Reader, Version, Reader> create) {
        return new PreConfiguredCharFilter(name, PreBuiltCacheFactory.CachingStrategy.ONE, useFilterForMultitermQueries, (reader, version) -> (Reader)create.apply((Reader)reader, (Version)version));
    }

    public static PreConfiguredCharFilter luceneVersion(String name, boolean useFilterForMultitermQueries, BiFunction<Reader, conductor.org.apache.lucene.util.Version, Reader> create) {
        return new PreConfiguredCharFilter(name, PreBuiltCacheFactory.CachingStrategy.LUCENE, useFilterForMultitermQueries, (reader, version) -> (Reader)create.apply((Reader)reader, version.luceneVersion));
    }

    public static PreConfiguredCharFilter elasticsearchVersion(String name, boolean useFilterForMultitermQueries, BiFunction<Reader, Version, Reader> create) {
        return new PreConfiguredCharFilter(name, PreBuiltCacheFactory.CachingStrategy.ELASTICSEARCH, useFilterForMultitermQueries, create);
    }

    protected PreConfiguredCharFilter(String name, PreBuiltCacheFactory.CachingStrategy cache, boolean useFilterForMultitermQueries, BiFunction<Reader, Version, Reader> create) {
        super(name, cache);
        this.useFilterForMultitermQueries = useFilterForMultitermQueries;
        this.create = create;
    }

    public boolean shouldUseFilterForMultitermQueries() {
        return this.useFilterForMultitermQueries;
    }

    @Override
    protected CharFilterFactory create(final Version version) {
        if (this.useFilterForMultitermQueries) {
            return new MultiTermAwareCharFilterFactory(){

                @Override
                public String name() {
                    return PreConfiguredCharFilter.this.getName();
                }

                @Override
                public Reader create(Reader reader) {
                    return (Reader)PreConfiguredCharFilter.this.create.apply(reader, version);
                }

                @Override
                public Object getMultiTermComponent() {
                    return this;
                }
            };
        }
        return new CharFilterFactory(){

            @Override
            public Reader create(Reader reader) {
                return (Reader)PreConfiguredCharFilter.this.create.apply(reader, version);
            }

            @Override
            public String name() {
                return PreConfiguredCharFilter.this.getName();
            }
        };
    }

    private static interface MultiTermAwareCharFilterFactory
    extends CharFilterFactory,
    MultiTermAwareComponent {
    }
}

