/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.mapper;

import conductor.org.elasticsearch.index.mapper.FieldAliasMapper;
import conductor.org.elasticsearch.index.mapper.FieldMapper;
import conductor.org.elasticsearch.index.mapper.Mapper;
import conductor.org.elasticsearch.index.mapper.ObjectMapper;
import conductor.org.elasticsearch.index.mapper.RootObjectMapper;
import java.util.Collection;

enum MapperUtils {


    public static void collect(Mapper mapper, Collection<ObjectMapper> objectMappers, Collection<FieldMapper> fieldMappers, Collection<FieldAliasMapper> fieldAliasMappers) {
        if (!(mapper instanceof RootObjectMapper)) {
            if (mapper instanceof ObjectMapper) {
                objectMappers.add((ObjectMapper)mapper);
            } else if (mapper instanceof FieldMapper) {
                fieldMappers.add((FieldMapper)mapper);
            } else if (mapper instanceof FieldAliasMapper) {
                fieldAliasMappers.add((FieldAliasMapper)mapper);
            } else {
                throw new IllegalStateException("Unrecognized mapper type [" + mapper.getClass().getSimpleName() + "].");
            }
        }
        for (Mapper child : mapper) {
            MapperUtils.collect(child, objectMappers, fieldMappers, fieldAliasMappers);
        }
    }
}

