/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.rankeval;

import conductor.org.elasticsearch.common.ParseField;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import conductor.org.elasticsearch.index.rankeval.EvalQueryQuality;
import conductor.org.elasticsearch.index.rankeval.EvaluationMetric;
import conductor.org.elasticsearch.index.rankeval.MetricDetail;
import conductor.org.elasticsearch.index.rankeval.RatedDocument;
import conductor.org.elasticsearch.index.rankeval.RatedSearchHit;
import conductor.org.elasticsearch.search.SearchHit;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class MeanReciprocalRank
implements EvaluationMetric {
    public static final String NAME = "mean_reciprocal_rank";
    private static final int DEFAULT_RATING_THRESHOLD = 1;
    private static final int DEFAULT_K = 10;
    private final int k;
    private final int relevantRatingThreshhold;
    private static final ParseField RELEVANT_RATING_FIELD = new ParseField("relevant_rating_threshold", new String[0]);
    private static final ParseField K_FIELD = new ParseField("k", new String[0]);
    private static final ConstructingObjectParser<MeanReciprocalRank, Void> PARSER = new ConstructingObjectParser("reciprocal_rank", args -> {
        Integer optionalThreshold = (Integer)args[0];
        Integer optionalK = (Integer)args[1];
        return new MeanReciprocalRank(optionalThreshold == null ? 1 : optionalThreshold, optionalK == null ? 10 : optionalK);
    });

    public MeanReciprocalRank() {
        this(1, 10);
    }

    MeanReciprocalRank(StreamInput in) throws IOException {
        this.relevantRatingThreshhold = in.readVInt();
        this.k = in.readVInt();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.relevantRatingThreshhold);
        out.writeVInt(this.k);
    }

    public MeanReciprocalRank(int relevantRatingThreshold, int k) {
        if (relevantRatingThreshold < 0) {
            throw new IllegalArgumentException("Relevant rating threshold for precision must be positive integer.");
        }
        if (k <= 0) {
            throw new IllegalArgumentException("Window size k must be positive.");
        }
        this.k = k;
        this.relevantRatingThreshhold = relevantRatingThreshold;
    }

    int getK() {
        return this.k;
    }

    @Override
    public Optional<Integer> forcedSearchSize() {
        return Optional.of(this.k);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    public int getRelevantRatingThreshold() {
        return this.relevantRatingThreshhold;
    }

    @Override
    public EvalQueryQuality evaluate(String taskId, SearchHit[] hits, List<RatedDocument> ratedDocs) {
        List<RatedSearchHit> ratedHits = EvaluationMetric.joinHitsWithRatings(hits, ratedDocs);
        int firstRelevant = -1;
        int rank = 1;
        for (RatedSearchHit hit : ratedHits) {
            Optional<Integer> rating = hit.getRating();
            if (rating.isPresent() && rating.get() >= this.relevantRatingThreshhold) {
                firstRelevant = rank;
                break;
            }
            ++rank;
        }
        double reciprocalRank = firstRelevant == -1 ? 0.0 : 1.0 / (double)firstRelevant;
        EvalQueryQuality evalQueryQuality = new EvalQueryQuality(taskId, reciprocalRank);
        evalQueryQuality.setMetricDetails(new Detail(firstRelevant));
        evalQueryQuality.addHitsAndRatings(ratedHits);
        return evalQueryQuality;
    }

    public static MeanReciprocalRank fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject(NAME);
        builder.field(RELEVANT_RATING_FIELD.getPreferredName(), this.relevantRatingThreshhold);
        builder.field(K_FIELD.getPreferredName(), this.k);
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MeanReciprocalRank other = (MeanReciprocalRank)obj;
        return Objects.equals(this.relevantRatingThreshhold, other.relevantRatingThreshhold) && Objects.equals(this.k, other.k);
    }

    public final int hashCode() {
        return Objects.hash(this.relevantRatingThreshhold, this.k);
    }

    static {
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), RELEVANT_RATING_FIELD);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), K_FIELD);
    }

    public static final class Detail
    implements MetricDetail {
        private final int firstRelevantRank;
        private static ParseField FIRST_RELEVANT_RANK_FIELD = new ParseField("first_relevant", new String[0]);
        private static final ConstructingObjectParser<Detail, Void> PARSER = new ConstructingObjectParser("mean_reciprocal_rank", true, args -> new Detail((Integer)args[0]));

        Detail(int firstRelevantRank) {
            this.firstRelevantRank = firstRelevantRank;
        }

        Detail(StreamInput in) throws IOException {
            this.firstRelevantRank = in.readVInt();
        }

        @Override
        public String getMetricName() {
            return MeanReciprocalRank.NAME;
        }

        @Override
        public XContentBuilder innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.field(FIRST_RELEVANT_RANK_FIELD.getPreferredName(), this.firstRelevantRank);
        }

        public static Detail fromXContent(XContentParser parser) {
            return PARSER.apply(parser, null);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.firstRelevantRank);
        }

        @Override
        public String getWriteableName() {
            return MeanReciprocalRank.NAME;
        }

        public int getFirstRelevantRank() {
            return this.firstRelevantRank;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Detail other = (Detail)obj;
            return Objects.equals(this.firstRelevantRank, other.firstRelevantRank);
        }

        public int hashCode() {
            return Objects.hash(this.firstRelevantRank);
        }

        static {
            PARSER.declareInt(ConstructingObjectParser.constructorArg(), FIRST_RELEVANT_RANK_FIELD);
        }
    }
}

