/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.indices;

import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.apache.lucene.index.Term;
import conductor.org.apache.lucene.search.BulkScorer;
import conductor.org.apache.lucene.search.Explanation;
import conductor.org.apache.lucene.search.LRUQueryCache;
import conductor.org.apache.lucene.search.Query;
import conductor.org.apache.lucene.search.QueryCache;
import conductor.org.apache.lucene.search.QueryCachingPolicy;
import conductor.org.apache.lucene.search.Scorer;
import conductor.org.apache.lucene.search.ScorerSupplier;
import conductor.org.apache.lucene.search.Weight;
import conductor.org.elasticsearch.common.component.AbstractComponent;
import conductor.org.elasticsearch.common.lucene.ShardCoreKeyMap;
import conductor.org.elasticsearch.common.settings.Setting;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.common.unit.ByteSizeValue;
import conductor.org.elasticsearch.index.cache.query.QueryCacheStats;
import conductor.org.elasticsearch.index.shard.ShardId;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;

public class IndicesQueryCache
extends AbstractComponent
implements QueryCache,
Closeable {
    public static final Setting<ByteSizeValue> INDICES_CACHE_QUERY_SIZE_SETTING = Setting.memorySizeSetting("indices.queries.cache.size", "10%", Setting.Property.NodeScope);
    public static final Setting<Integer> INDICES_CACHE_QUERY_COUNT_SETTING = Setting.intSetting("indices.queries.cache.count", 10000, 1, Setting.Property.NodeScope);
    public static final Setting<Boolean> INDICES_QUERIES_CACHE_ALL_SEGMENTS_SETTING = Setting.boolSetting("indices.queries.cache.all_segments", false, Setting.Property.NodeScope);
    private final LRUQueryCache cache;
    private final ShardCoreKeyMap shardKeyMap = new ShardCoreKeyMap();
    private final Map<ShardId, Stats> shardStats = new ConcurrentHashMap<ShardId, Stats>();
    private volatile long sharedRamBytesUsed;
    private final Map<Object, StatsAndCount> stats2 = new IdentityHashMap<Object, StatsAndCount>();

    public IndicesQueryCache(Settings settings) {
        super(settings);
        ByteSizeValue size = INDICES_CACHE_QUERY_SIZE_SETTING.get(settings);
        int count = INDICES_CACHE_QUERY_COUNT_SETTING.get(settings);
        this.logger.debug("using [node] query cache with size [{}] max filter count [{}]", (Object)size, (Object)count);
        this.cache = INDICES_QUERIES_CACHE_ALL_SEGMENTS_SETTING.get(settings) != false ? new ElasticsearchLRUQueryCache(count, size.getBytes(), context -> true) : new ElasticsearchLRUQueryCache(count, size.getBytes());
        this.sharedRamBytesUsed = 0L;
    }

    public QueryCacheStats getStats(ShardId shard) {
        HashMap<ShardId, QueryCacheStats> stats = new HashMap<ShardId, QueryCacheStats>();
        for (Map.Entry<ShardId, Stats> entry : this.shardStats.entrySet()) {
            stats.put(entry.getKey(), entry.getValue().toQueryCacheStats());
        }
        QueryCacheStats shardStats = new QueryCacheStats();
        QueryCacheStats info = (QueryCacheStats)stats.get(shard);
        if (info == null) {
            info = new QueryCacheStats();
        }
        shardStats.add(info);
        long totalSize = 0L;
        for (QueryCacheStats s : stats.values()) {
            totalSize += s.getCacheSize();
        }
        double weight = totalSize == 0L ? 1.0 / (double)stats.size() : (double)shardStats.getCacheSize() / (double)totalSize;
        long additionalRamBytesUsed = Math.round(weight * (double)this.sharedRamBytesUsed);
        shardStats.add(new QueryCacheStats(additionalRamBytesUsed, 0L, 0L, 0L, 0L));
        return shardStats;
    }

    @Override
    public Weight doCache(Weight weight, QueryCachingPolicy policy) {
        while (weight instanceof CachingWeightWrapper) {
            weight = ((CachingWeightWrapper)weight).in;
        }
        Weight in = this.cache.doCache(weight, policy);
        return new CachingWeightWrapper(in);
    }

    public void clearIndex(String index) {
        Set<Object> coreCacheKeys = this.shardKeyMap.getCoreKeysForIndex(index);
        for (Object coreKey : coreCacheKeys) {
            this.cache.clearCoreCacheKey(coreKey);
        }
        if (this.cache.getCacheSize() == 0L) {
            this.cache.clear();
        }
    }

    @Override
    public void close() {
        assert (this.shardKeyMap.size() == 0) : this.shardKeyMap.size();
        assert (this.shardStats.isEmpty()) : this.shardStats.keySet();
        assert (this.stats2.isEmpty()) : this.stats2;
        this.cache.clear();
    }

    private boolean empty(Stats stats) {
        if (stats == null) {
            return true;
        }
        return stats.cacheSize == 0L && stats.ramBytesUsed == 0L;
    }

    public void onClose(ShardId shardId) {
        assert (this.empty(this.shardStats.get(shardId)));
        this.shardStats.remove(shardId);
    }

    private class ElasticsearchLRUQueryCache
    extends LRUQueryCache {
        ElasticsearchLRUQueryCache(int maxSize, long maxRamBytesUsed, Predicate<LeafReaderContext> leavesToCache) {
            super(maxSize, maxRamBytesUsed, leavesToCache);
        }

        ElasticsearchLRUQueryCache(int maxSize, long maxRamBytesUsed) {
            super(maxSize, maxRamBytesUsed);
        }

        private Stats getStats(Object coreKey) {
            ShardId shardId = IndicesQueryCache.this.shardKeyMap.getShardId(coreKey);
            if (shardId == null) {
                return null;
            }
            return (Stats)IndicesQueryCache.this.shardStats.get(shardId);
        }

        private Stats getOrCreateStats(Object coreKey) {
            ShardId shardId = IndicesQueryCache.this.shardKeyMap.getShardId(coreKey);
            Stats stats = (Stats)IndicesQueryCache.this.shardStats.get(shardId);
            if (stats == null) {
                stats = new Stats();
                IndicesQueryCache.this.shardStats.put(shardId, stats);
            }
            return stats;
        }

        @Override
        protected void onClear() {
            super.onClear();
            for (Stats stats : IndicesQueryCache.this.shardStats.values()) {
                stats.cacheSize = 0L;
                stats.ramBytesUsed = 0L;
            }
            IndicesQueryCache.this.sharedRamBytesUsed = 0L;
        }

        @Override
        protected void onQueryCache(Query filter, long ramBytesUsed) {
            super.onQueryCache(filter, ramBytesUsed);
            IndicesQueryCache.this.sharedRamBytesUsed += ramBytesUsed;
        }

        @Override
        protected void onQueryEviction(Query filter, long ramBytesUsed) {
            super.onQueryEviction(filter, ramBytesUsed);
            IndicesQueryCache.this.sharedRamBytesUsed -= ramBytesUsed;
        }

        @Override
        protected void onDocIdSetCache(Object readerCoreKey, long ramBytesUsed) {
            super.onDocIdSetCache(readerCoreKey, ramBytesUsed);
            Stats shardStats = this.getOrCreateStats(readerCoreKey);
            ++shardStats.cacheSize;
            ++shardStats.cacheCount;
            shardStats.ramBytesUsed += ramBytesUsed;
            StatsAndCount statsAndCount = (StatsAndCount)IndicesQueryCache.this.stats2.get(readerCoreKey);
            if (statsAndCount == null) {
                statsAndCount = new StatsAndCount(shardStats);
                IndicesQueryCache.this.stats2.put(readerCoreKey, statsAndCount);
            }
            ++statsAndCount.count;
        }

        @Override
        protected void onDocIdSetEviction(Object readerCoreKey, int numEntries, long sumRamBytesUsed) {
            super.onDocIdSetEviction(readerCoreKey, numEntries, sumRamBytesUsed);
            if (numEntries > 0) {
                StatsAndCount statsAndCount = (StatsAndCount)IndicesQueryCache.this.stats2.get(readerCoreKey);
                Stats shardStats = statsAndCount.stats;
                shardStats.cacheSize -= (long)numEntries;
                shardStats.ramBytesUsed -= sumRamBytesUsed;
                statsAndCount.count -= numEntries;
                if (statsAndCount.count == 0) {
                    IndicesQueryCache.this.stats2.remove(readerCoreKey);
                }
            }
        }

        @Override
        protected void onHit(Object readerCoreKey, Query filter) {
            super.onHit(readerCoreKey, filter);
            Stats shardStats = this.getStats(readerCoreKey);
            ++shardStats.hitCount;
        }

        @Override
        protected void onMiss(Object readerCoreKey, Query filter) {
            super.onMiss(readerCoreKey, filter);
            Stats shardStats = this.getOrCreateStats(readerCoreKey);
            ++shardStats.missCount;
        }
    }

    private static class StatsAndCount {
        int count;
        final Stats stats;

        StatsAndCount(Stats stats) {
            this.stats = stats;
            this.count = 0;
        }
    }

    private static class Stats
    implements Cloneable {
        volatile long ramBytesUsed;
        volatile long hitCount;
        volatile long missCount;
        volatile long cacheCount;
        volatile long cacheSize;

        private Stats() {
        }

        QueryCacheStats toQueryCacheStats() {
            return new QueryCacheStats(this.ramBytesUsed, this.hitCount, this.missCount, this.cacheCount, this.cacheSize);
        }
    }

    private class CachingWeightWrapper
    extends Weight {
        private final Weight in;

        protected CachingWeightWrapper(Weight in) {
            super(in.getQuery());
            this.in = in;
        }

        @Override
        public void extractTerms(Set<Term> terms) {
            this.in.extractTerms(terms);
        }

        @Override
        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            IndicesQueryCache.this.shardKeyMap.add(context.reader());
            return this.in.explain(context, doc);
        }

        @Override
        public Scorer scorer(LeafReaderContext context) throws IOException {
            IndicesQueryCache.this.shardKeyMap.add(context.reader());
            return this.in.scorer(context);
        }

        @Override
        public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
            IndicesQueryCache.this.shardKeyMap.add(context.reader());
            return this.in.scorerSupplier(context);
        }

        @Override
        public BulkScorer bulkScorer(LeafReaderContext context) throws IOException {
            IndicesQueryCache.this.shardKeyMap.add(context.reader());
            return this.in.bulkScorer(context);
        }

        @Override
        public boolean isCacheable(LeafReaderContext ctx) {
            return this.in.isCacheable(ctx);
        }
    }
}

