/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.rest.action.admin.cluster;

import conductor.org.elasticsearch.action.admin.cluster.repositories.put.PutRepositoryRequest;
import conductor.org.elasticsearch.action.support.master.AcknowledgedResponse;
import conductor.org.elasticsearch.client.Requests;
import conductor.org.elasticsearch.client.node.NodeClient;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import conductor.org.elasticsearch.rest.BaseRestHandler;
import conductor.org.elasticsearch.rest.RestChannel;
import conductor.org.elasticsearch.rest.RestController;
import conductor.org.elasticsearch.rest.RestRequest;
import conductor.org.elasticsearch.rest.action.RestToXContentListener;
import java.io.IOException;

public class RestPutRepositoryAction
extends BaseRestHandler {
    public RestPutRepositoryAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.PUT, "/_snapshot/{repository}", this);
        controller.registerHandler(RestRequest.Method.POST, "/_snapshot/{repository}", this);
    }

    @Override
    public String getName() {
        return "put_repository_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        PutRepositoryRequest putRepositoryRequest = Requests.putRepositoryRequest(request.param("repository"));
        try (XContentParser parser = request.contentParser();){
            putRepositoryRequest.source(parser.mapOrdered());
        }
        putRepositoryRequest.verify(request.paramAsBoolean("verify", true));
        putRepositoryRequest.masterNodeTimeout(request.paramAsTime("master_timeout", putRepositoryRequest.masterNodeTimeout()));
        putRepositoryRequest.timeout(request.paramAsTime("timeout", putRepositoryRequest.timeout()));
        return channel -> client.admin().cluster().putRepository(putRepositoryRequest, new RestToXContentListener<AcknowledgedResponse>((RestChannel)channel));
    }
}

