/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.fetch.subphase;

import conductor.org.elasticsearch.Version;
import conductor.org.elasticsearch.common.Nullable;
import conductor.org.elasticsearch.common.ParseField;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.io.stream.Writeable;
import conductor.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

public class DocValueFieldsContext {
    public static final String USE_DEFAULT_FORMAT = "use_field_mapping";
    private final List<FieldAndFormat> fields;

    public DocValueFieldsContext(List<FieldAndFormat> fields) {
        this.fields = fields;
    }

    public List<FieldAndFormat> fields() {
        return this.fields;
    }

    public static final class FieldAndFormat
    implements Writeable {
        private static final ConstructingObjectParser<FieldAndFormat, Void> PARSER = new ConstructingObjectParser("script", a -> new FieldAndFormat((String)a[0], (String)a[1]));
        public final String field;
        public final String format;

        public static FieldAndFormat fromXContent(XContentParser parser) throws IOException {
            XContentParser.Token token = parser.currentToken();
            if (token.isValue()) {
                return new FieldAndFormat(parser.text(), null);
            }
            return PARSER.apply(parser, null);
        }

        public FieldAndFormat(String field, @Nullable String format) {
            this.field = Objects.requireNonNull(field);
            this.format = format;
        }

        public FieldAndFormat(StreamInput in) throws IOException {
            this.field = in.readString();
            this.format = in.getVersion().onOrAfter(Version.V_6_4_0) ? in.readOptionalString() : null;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.field);
            if (out.getVersion().onOrAfter(Version.V_6_4_0)) {
                out.writeOptionalString(this.format);
            }
        }

        public int hashCode() {
            int h = this.field.hashCode();
            h = 31 * h + Objects.hashCode(this.format);
            return h;
        }

        public boolean equals(Object obj) {
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            FieldAndFormat other = (FieldAndFormat)obj;
            return this.field.equals(other.field) && Objects.equals(this.format, other.format);
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("field", new String[0]));
            PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), new ParseField("format", new String[0]));
        }
    }
}

