/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.snapshots;

import conductor.com.carrotsearch.hppc.IntHashSet;
import conductor.com.carrotsearch.hppc.IntSet;
import conductor.com.carrotsearch.hppc.cursors.ObjectCursor;
import conductor.com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import conductor.org.apache.logging.log4j.Logger;
import conductor.org.apache.logging.log4j.message.ParameterizedMessage;
import conductor.org.elasticsearch.Version;
import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.action.support.IndicesOptions;
import conductor.org.elasticsearch.cluster.ClusterChangedEvent;
import conductor.org.elasticsearch.cluster.ClusterState;
import conductor.org.elasticsearch.cluster.ClusterStateApplier;
import conductor.org.elasticsearch.cluster.ClusterStateTaskConfig;
import conductor.org.elasticsearch.cluster.ClusterStateTaskExecutor;
import conductor.org.elasticsearch.cluster.ClusterStateTaskListener;
import conductor.org.elasticsearch.cluster.ClusterStateUpdateTask;
import conductor.org.elasticsearch.cluster.RestoreInProgress;
import conductor.org.elasticsearch.cluster.SnapshotDeletionsInProgress;
import conductor.org.elasticsearch.cluster.block.ClusterBlocks;
import conductor.org.elasticsearch.cluster.metadata.AliasMetaData;
import conductor.org.elasticsearch.cluster.metadata.IndexMetaData;
import conductor.org.elasticsearch.cluster.metadata.IndexTemplateMetaData;
import conductor.org.elasticsearch.cluster.metadata.MetaData;
import conductor.org.elasticsearch.cluster.metadata.MetaDataCreateIndexService;
import conductor.org.elasticsearch.cluster.metadata.MetaDataIndexUpgradeService;
import conductor.org.elasticsearch.cluster.routing.RecoverySource;
import conductor.org.elasticsearch.cluster.routing.RoutingChangesObserver;
import conductor.org.elasticsearch.cluster.routing.RoutingTable;
import conductor.org.elasticsearch.cluster.routing.ShardRouting;
import conductor.org.elasticsearch.cluster.routing.UnassignedInfo;
import conductor.org.elasticsearch.cluster.routing.allocation.AllocationService;
import conductor.org.elasticsearch.cluster.service.ClusterService;
import conductor.org.elasticsearch.common.Priority;
import conductor.org.elasticsearch.common.UUIDs;
import conductor.org.elasticsearch.common.collect.ImmutableOpenMap;
import conductor.org.elasticsearch.common.component.AbstractComponent;
import conductor.org.elasticsearch.common.inject.Inject;
import conductor.org.elasticsearch.common.lucene.Lucene;
import conductor.org.elasticsearch.common.regex.Regex;
import conductor.org.elasticsearch.common.settings.ClusterSettings;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.common.unit.TimeValue;
import conductor.org.elasticsearch.common.util.set.Sets;
import conductor.org.elasticsearch.index.Index;
import conductor.org.elasticsearch.index.IndexSettings;
import conductor.org.elasticsearch.index.shard.ShardId;
import conductor.org.elasticsearch.repositories.IndexId;
import conductor.org.elasticsearch.repositories.RepositoriesService;
import conductor.org.elasticsearch.repositories.Repository;
import conductor.org.elasticsearch.repositories.RepositoryData;
import conductor.org.elasticsearch.snapshots.ConcurrentSnapshotExecutionException;
import conductor.org.elasticsearch.snapshots.RestoreInfo;
import conductor.org.elasticsearch.snapshots.Snapshot;
import conductor.org.elasticsearch.snapshots.SnapshotId;
import conductor.org.elasticsearch.snapshots.SnapshotInfo;
import conductor.org.elasticsearch.snapshots.SnapshotRestoreException;
import conductor.org.elasticsearch.snapshots.SnapshotShardFailure;
import conductor.org.elasticsearch.snapshots.SnapshotUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class RestoreService
extends AbstractComponent
implements ClusterStateApplier {
    private static final Set<String> UNMODIFIABLE_SETTINGS = Collections.unmodifiableSet(Sets.newHashSet("index.number_of_shards", "index.version.created", "index.uuid", "index.creation_date", IndexSettings.INDEX_SOFT_DELETES_SETTING.getKey()));
    private static final Set<String> UNREMOVABLE_SETTINGS;
    private final ClusterService clusterService;
    private final RepositoriesService repositoriesService;
    private final AllocationService allocationService;
    private final MetaDataCreateIndexService createIndexService;
    private final MetaDataIndexUpgradeService metaDataIndexUpgradeService;
    private final ClusterSettings clusterSettings;
    private final CleanRestoreStateTaskExecutor cleanRestoreStateTaskExecutor;

    @Inject
    public RestoreService(Settings settings, ClusterService clusterService, RepositoriesService repositoriesService, AllocationService allocationService, MetaDataCreateIndexService createIndexService, MetaDataIndexUpgradeService metaDataIndexUpgradeService, ClusterSettings clusterSettings) {
        super(settings);
        this.clusterService = clusterService;
        this.repositoriesService = repositoriesService;
        this.allocationService = allocationService;
        this.createIndexService = createIndexService;
        this.metaDataIndexUpgradeService = metaDataIndexUpgradeService;
        clusterService.addStateApplier(this);
        this.clusterSettings = clusterSettings;
        this.cleanRestoreStateTaskExecutor = new CleanRestoreStateTaskExecutor(this.logger);
    }

    public void restoreSnapshot(final RestoreRequest request, final ActionListener<RestoreCompletionResponse> listener) {
        try {
            Repository repository = this.repositoriesService.repository(request.repositoryName);
            RepositoryData repositoryData = repository.getRepositoryData();
            Optional<SnapshotId> incompatibleSnapshotId = repositoryData.getIncompatibleSnapshotIds().stream().filter(s -> request.snapshotName.equals(s.getName())).findFirst();
            if (incompatibleSnapshotId.isPresent()) {
                throw new SnapshotRestoreException(request.repositoryName, request.snapshotName, "cannot restore incompatible snapshot");
            }
            Optional<SnapshotId> matchingSnapshotId = repositoryData.getSnapshotIds().stream().filter(s -> request.snapshotName.equals(s.getName())).findFirst();
            if (!matchingSnapshotId.isPresent()) {
                throw new SnapshotRestoreException(request.repositoryName, request.snapshotName, "snapshot does not exist");
            }
            final SnapshotId snapshotId = matchingSnapshotId.get();
            final SnapshotInfo snapshotInfo = repository.getSnapshotInfo(snapshotId);
            final Snapshot snapshot = new Snapshot(request.repositoryName, snapshotId);
            this.validateSnapshotRestorable(request.repositoryName, snapshotInfo);
            List<String> indicesInSnapshot = SnapshotUtils.filterIndices(snapshotInfo.indices(), request.indices(), request.indicesOptions());
            MetaData.Builder metaDataBuilder = request.includeGlobalState() ? MetaData.builder(repository.getSnapshotGlobalMetaData(snapshotId)) : MetaData.builder();
            List<IndexId> indexIdsInSnapshot = repositoryData.resolveIndices(indicesInSnapshot);
            for (IndexId indexId : indexIdsInSnapshot) {
                metaDataBuilder.put(repository.getSnapshotIndexMetaData(snapshotId, indexId), false);
            }
            final MetaData metaData = metaDataBuilder.build();
            final Map<String, String> indices = this.renamedIndices(request, indicesInSnapshot);
            this.clusterService.submitStateUpdateTask(request.cause(), new ClusterStateUpdateTask(){
                RestoreInfo restoreInfo = null;

                @Override
                public ClusterState execute(ClusterState currentState) {
                    ImmutableOpenMap<ShardId, RestoreInProgress.ShardRestoreStatus> shards;
                    RestoreInProgress restoreInProgress = (RestoreInProgress)currentState.custom("restore");
                    if (restoreInProgress != null && !restoreInProgress.entries().isEmpty()) {
                        throw new ConcurrentSnapshotExecutionException(snapshot, "Restore process is already running in this cluster");
                    }
                    SnapshotDeletionsInProgress deletionsInProgress = (SnapshotDeletionsInProgress)currentState.custom("snapshot_deletions");
                    if (deletionsInProgress != null && deletionsInProgress.hasDeletionsInProgress()) {
                        throw new ConcurrentSnapshotExecutionException(snapshot, "cannot restore a snapshot while a snapshot deletion is in-progress [" + deletionsInProgress.getEntries().get(0).getSnapshot() + "]");
                    }
                    ClusterState.Builder builder = ClusterState.builder(currentState);
                    MetaData.Builder mdBuilder = MetaData.builder(currentState.metaData());
                    ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(currentState.blocks());
                    RoutingTable.Builder rtBuilder = RoutingTable.builder(currentState.routingTable());
                    HashSet<String> aliases = new HashSet<String>();
                    if (!indices.isEmpty()) {
                        ImmutableOpenMap.Builder<ShardId, RestoreInProgress.ShardRestoreStatus> shardsBuilder = ImmutableOpenMap.builder();
                        Version version = currentState.getNodes().getMaxNodeVersion().minimumIndexCompatibilityVersion();
                        for (Map.Entry indexEntry : indices.entrySet()) {
                            Index renamedIndex;
                            Object updatedIndexMetaData;
                            IndexMetaData.Builder indexMdBuilder;
                            String index = (String)indexEntry.getValue();
                            boolean partial = this.checkPartial(index);
                            RecoverySource.SnapshotRecoverySource recoverySource = new RecoverySource.SnapshotRecoverySource(snapshot, snapshotInfo.version(), index);
                            String renamedIndexName = (String)indexEntry.getKey();
                            IndexMetaData snapshotIndexMetaData = metaData.index(index);
                            snapshotIndexMetaData = this.updateIndexSettings(snapshotIndexMetaData, request.indexSettings, request.ignoreIndexSettings);
                            try {
                                snapshotIndexMetaData = RestoreService.this.metaDataIndexUpgradeService.upgradeIndexMetaData(snapshotIndexMetaData, version);
                            }
                            catch (Exception ex) {
                                throw new SnapshotRestoreException(snapshot, "cannot restore index [" + index + "] because it cannot be upgraded", ex);
                            }
                            IndexMetaData currentIndexMetaData = currentState.metaData().index(renamedIndexName);
                            IntHashSet ignoreShards = new IntHashSet();
                            if (currentIndexMetaData == null) {
                                MetaDataCreateIndexService.validateIndexName(renamedIndexName, currentState);
                                RestoreService.this.createIndexService.validateIndexSettings(renamedIndexName, snapshotIndexMetaData.getSettings(), currentState, false);
                                indexMdBuilder = IndexMetaData.builder(snapshotIndexMetaData).state(IndexMetaData.State.OPEN).index(renamedIndexName);
                                indexMdBuilder.settings(Settings.builder().put(snapshotIndexMetaData.getSettings()).put("index.uuid", UUIDs.randomBase64UUID()));
                                if (!request.includeAliases() && !snapshotIndexMetaData.getAliases().isEmpty()) {
                                    indexMdBuilder.removeAllAliases();
                                } else {
                                    for (ObjectCursor<Object> alias : snapshotIndexMetaData.getAliases().keys()) {
                                        aliases.add((String)alias.value);
                                    }
                                }
                                updatedIndexMetaData = indexMdBuilder.build();
                                if (partial) {
                                    this.populateIgnoredShards(index, ignoreShards);
                                }
                                rtBuilder.addAsNewRestore((IndexMetaData)updatedIndexMetaData, recoverySource, ignoreShards);
                                blocks.addBlocks((IndexMetaData)updatedIndexMetaData);
                                mdBuilder.put((IndexMetaData)updatedIndexMetaData, true);
                                renamedIndex = ((IndexMetaData)updatedIndexMetaData).getIndex();
                            } else {
                                this.validateExistingIndex(currentIndexMetaData, snapshotIndexMetaData, renamedIndexName, partial);
                                indexMdBuilder = IndexMetaData.builder(snapshotIndexMetaData).state(IndexMetaData.State.OPEN);
                                indexMdBuilder.version(Math.max(snapshotIndexMetaData.getVersion(), currentIndexMetaData.getVersion() + 1L));
                                indexMdBuilder.mappingVersion(Math.max(snapshotIndexMetaData.getMappingVersion(), currentIndexMetaData.getMappingVersion() + 1L));
                                indexMdBuilder.settingsVersion(Math.max(snapshotIndexMetaData.getSettingsVersion(), currentIndexMetaData.getSettingsVersion() + 1L));
                                if (!request.includeAliases()) {
                                    if (!snapshotIndexMetaData.getAliases().isEmpty()) {
                                        indexMdBuilder.removeAllAliases();
                                    }
                                    for (ObjectCursor<Object> alias : currentIndexMetaData.getAliases().values()) {
                                        indexMdBuilder.putAlias((AliasMetaData)alias.value);
                                    }
                                } else {
                                    for (ObjectCursor<Object> alias : snapshotIndexMetaData.getAliases().keys()) {
                                        aliases.add((String)alias.value);
                                    }
                                }
                                indexMdBuilder.settings(Settings.builder().put(snapshotIndexMetaData.getSettings()).put("index.uuid", currentIndexMetaData.getIndexUUID()));
                                updatedIndexMetaData = indexMdBuilder.index(renamedIndexName).build();
                                rtBuilder.addAsRestore((IndexMetaData)updatedIndexMetaData, recoverySource);
                                blocks.updateBlocks((IndexMetaData)updatedIndexMetaData);
                                mdBuilder.put((IndexMetaData)updatedIndexMetaData, true);
                                renamedIndex = ((IndexMetaData)updatedIndexMetaData).getIndex();
                            }
                            for (int shard = 0; shard < snapshotIndexMetaData.getNumberOfShards(); ++shard) {
                                if (!ignoreShards.contains(shard)) {
                                    shardsBuilder.put(new ShardId(renamedIndex, shard), new RestoreInProgress.ShardRestoreStatus(RestoreService.this.clusterService.state().nodes().getLocalNodeId()));
                                    continue;
                                }
                                shardsBuilder.put(new ShardId(renamedIndex, shard), new RestoreInProgress.ShardRestoreStatus(RestoreService.this.clusterService.state().nodes().getLocalNodeId(), RestoreInProgress.State.FAILURE));
                            }
                        }
                        shards = shardsBuilder.build();
                        RestoreInProgress.Entry restoreEntry = new RestoreInProgress.Entry(snapshot, RestoreService.overallState(RestoreInProgress.State.INIT, shards), Collections.unmodifiableList(new ArrayList(indices.keySet())), shards);
                        builder.putCustom("restore", new RestoreInProgress(restoreEntry));
                    } else {
                        shards = ImmutableOpenMap.of();
                    }
                    this.checkAliasNameConflicts(indices, aliases);
                    if (request.includeGlobalState()) {
                        if (metaData.persistentSettings() != null) {
                            Iterator<ObjectObjectCursor<String, MetaData.Custom>> settings = metaData.persistentSettings();
                            RestoreService.this.clusterSettings.validateUpdate((Settings)((Object)settings));
                            mdBuilder.persistentSettings((Settings)((Object)settings));
                        }
                        if (metaData.templates() != null) {
                            for (ObjectCursor objectCursor : metaData.templates().values()) {
                                mdBuilder.put((IndexTemplateMetaData)objectCursor.value);
                            }
                        }
                        if (metaData.customs() != null) {
                            for (ObjectObjectCursor<String, MetaData.Custom> objectObjectCursor : metaData.customs()) {
                                if ("repositories".equals(objectObjectCursor.key)) continue;
                                mdBuilder.putCustom((String)objectObjectCursor.key, (MetaData.Custom)objectObjectCursor.value);
                            }
                        }
                    }
                    if (RestoreService.completed(shards)) {
                        this.restoreInfo = new RestoreInfo(snapshotId.getName(), Collections.unmodifiableList(new ArrayList(indices.keySet())), shards.size(), shards.size() - RestoreService.failedShards(shards));
                    }
                    RoutingTable rt = rtBuilder.build();
                    ClusterState clusterState = builder.metaData(mdBuilder).blocks(blocks).routingTable(rt).build();
                    return RestoreService.this.allocationService.reroute(clusterState, "restored snapshot [" + snapshot + "]");
                }

                private void checkAliasNameConflicts(Map<String, String> renamedIndices, Set<String> aliases) {
                    for (Map.Entry<String, String> renamedIndex : renamedIndices.entrySet()) {
                        if (!aliases.contains(renamedIndex.getKey())) continue;
                        throw new SnapshotRestoreException(snapshot, "cannot rename index [" + renamedIndex.getValue() + "] into [" + renamedIndex.getKey() + "] because of conflict with an alias with the same name");
                    }
                }

                private void populateIgnoredShards(String index, IntSet ignoreShards) {
                    for (SnapshotShardFailure failure : snapshotInfo.shardFailures()) {
                        if (!index.equals(failure.index())) continue;
                        ignoreShards.add(failure.shardId());
                    }
                }

                private boolean checkPartial(String index) {
                    if (RestoreService.this.failed(snapshotInfo, index)) {
                        if (request.partial()) {
                            return true;
                        }
                        throw new SnapshotRestoreException(snapshot, "index [" + index + "] wasn't fully snapshotted - cannot restore");
                    }
                    return false;
                }

                private void validateExistingIndex(IndexMetaData currentIndexMetaData, IndexMetaData snapshotIndexMetaData, String renamedIndex, boolean partial) {
                    if (currentIndexMetaData.getState() != IndexMetaData.State.CLOSE) {
                        throw new SnapshotRestoreException(snapshot, "cannot restore index [" + renamedIndex + "] because an open index with same name already exists in the cluster. Either close or delete the existing index or restore the index under a different name by providing a rename pattern and replacement name");
                    }
                    if (partial) {
                        throw new SnapshotRestoreException(snapshot, "cannot restore partial index [" + renamedIndex + "] because such index already exists");
                    }
                    if (currentIndexMetaData.getNumberOfShards() != snapshotIndexMetaData.getNumberOfShards()) {
                        throw new SnapshotRestoreException(snapshot, "cannot restore index [" + renamedIndex + "] with [" + currentIndexMetaData.getNumberOfShards() + "] shards from a snapshot of index [" + snapshotIndexMetaData.getIndex().getName() + "] with [" + snapshotIndexMetaData.getNumberOfShards() + "] shards");
                    }
                }

                private IndexMetaData updateIndexSettings(IndexMetaData indexMetaData, Settings changeSettings, String[] ignoreSettings) {
                    if (changeSettings.names().isEmpty() && ignoreSettings.length == 0) {
                        return indexMetaData;
                    }
                    Settings normalizedChangeSettings = Settings.builder().put(changeSettings).normalizePrefix("index.").build();
                    IndexMetaData.Builder builder = IndexMetaData.builder(indexMetaData);
                    Settings settings = indexMetaData.getSettings();
                    HashSet<String> keyFilters = new HashSet<String>();
                    ArrayList<String> simpleMatchPatterns = new ArrayList<String>();
                    for (String ignoredSetting : ignoreSettings) {
                        if (!Regex.isSimpleMatchPattern(ignoredSetting)) {
                            if (UNREMOVABLE_SETTINGS.contains(ignoredSetting)) {
                                throw new SnapshotRestoreException(snapshot, "cannot remove setting [" + ignoredSetting + "] on restore");
                            }
                            keyFilters.add(ignoredSetting);
                            continue;
                        }
                        simpleMatchPatterns.add(ignoredSetting);
                    }
                    Predicate<String> settingsFilter = k -> {
                        if (!UNREMOVABLE_SETTINGS.contains(k)) {
                            for (String filterKey : keyFilters) {
                                if (!k.equals(filterKey)) continue;
                                return false;
                            }
                            for (String pattern : simpleMatchPatterns) {
                                if (!Regex.simpleMatch(pattern, k)) continue;
                                return false;
                            }
                        }
                        return true;
                    };
                    Settings.Builder settingsBuilder = Settings.builder().put(settings.filter(settingsFilter)).put(normalizedChangeSettings.filter(k -> {
                        if (UNMODIFIABLE_SETTINGS.contains(k)) {
                            throw new SnapshotRestoreException(snapshot, "cannot modify setting [" + k + "] on restore");
                        }
                        return true;
                    }));
                    return builder.settings(settingsBuilder).build();
                }

                @Override
                public void onFailure(String source, Exception e) {
                    RestoreService.this.logger.warn(() -> new ParameterizedMessage("[{}] failed to restore snapshot", (Object)snapshotId), (Throwable)e);
                    listener.onFailure(e);
                }

                @Override
                public TimeValue timeout() {
                    return request.masterNodeTimeout();
                }

                @Override
                public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                    listener.onResponse(new RestoreCompletionResponse(snapshot, this.restoreInfo));
                }
            });
        }
        catch (Exception e) {
            this.logger.warn(() -> new ParameterizedMessage("[{}] failed to restore snapshot", (Object)(request.repositoryName + ":" + request.snapshotName)), (Throwable)e);
            listener.onFailure(e);
        }
    }

    public static RestoreInProgress updateRestoreStateWithDeletedIndices(RestoreInProgress oldRestore, Set<Index> deletedIndices) {
        boolean changesMade = false;
        ArrayList<RestoreInProgress.Entry> entries = new ArrayList<RestoreInProgress.Entry>();
        for (RestoreInProgress.Entry entry : oldRestore.entries()) {
            ImmutableOpenMap.Builder<ShardId, RestoreInProgress.ShardRestoreStatus> shardsBuilder = null;
            for (ObjectObjectCursor<ShardId, RestoreInProgress.ShardRestoreStatus> objectObjectCursor : entry.shards()) {
                ShardId shardId = (ShardId)objectObjectCursor.key;
                if (!deletedIndices.contains(shardId.getIndex())) continue;
                changesMade = true;
                if (shardsBuilder == null) {
                    shardsBuilder = ImmutableOpenMap.builder(entry.shards());
                }
                shardsBuilder.put(shardId, new RestoreInProgress.ShardRestoreStatus(null, RestoreInProgress.State.FAILURE, "index was deleted"));
            }
            if (shardsBuilder != null) {
                ImmutableOpenMap<ShardId, RestoreInProgress.ShardRestoreStatus> shards = shardsBuilder.build();
                entries.add(new RestoreInProgress.Entry(entry.snapshot(), RestoreService.overallState(RestoreInProgress.State.STARTED, shards), entry.indices(), shards));
                continue;
            }
            entries.add(entry);
        }
        if (changesMade) {
            return new RestoreInProgress(entries.toArray(new RestoreInProgress.Entry[entries.size()]));
        }
        return oldRestore;
    }

    public static RestoreInProgress.Entry restoreInProgress(ClusterState state, Snapshot snapshot) {
        RestoreInProgress restoreInProgress = (RestoreInProgress)state.custom("restore");
        if (restoreInProgress != null) {
            for (RestoreInProgress.Entry e : restoreInProgress.entries()) {
                if (!e.snapshot().equals(snapshot)) continue;
                return e;
            }
        }
        return null;
    }

    private void cleanupRestoreState(ClusterChangedEvent event) {
        ClusterState state = event.state();
        RestoreInProgress restoreInProgress = (RestoreInProgress)state.custom("restore");
        if (restoreInProgress != null) {
            for (RestoreInProgress.Entry entry : restoreInProgress.entries()) {
                if (!entry.state().completed()) continue;
                assert (RestoreService.completed(entry.shards())) : "state says completed but restore entries are not";
                this.clusterService.submitStateUpdateTask("clean up snapshot restore state", new CleanRestoreStateTaskExecutor.Task(entry.snapshot()), ClusterStateTaskConfig.build(Priority.URGENT), this.cleanRestoreStateTaskExecutor, this.cleanRestoreStateTaskExecutor);
            }
        }
    }

    public static RestoreInProgress.State overallState(RestoreInProgress.State nonCompletedState, ImmutableOpenMap<ShardId, RestoreInProgress.ShardRestoreStatus> shards) {
        boolean hasFailed = false;
        for (ObjectCursor<RestoreInProgress.ShardRestoreStatus> objectCursor : shards.values()) {
            if (!((RestoreInProgress.ShardRestoreStatus)objectCursor.value).state().completed()) {
                return nonCompletedState;
            }
            if (((RestoreInProgress.ShardRestoreStatus)objectCursor.value).state() != RestoreInProgress.State.FAILURE) continue;
            hasFailed = true;
        }
        if (hasFailed) {
            return RestoreInProgress.State.FAILURE;
        }
        return RestoreInProgress.State.SUCCESS;
    }

    public static boolean completed(ImmutableOpenMap<ShardId, RestoreInProgress.ShardRestoreStatus> shards) {
        for (ObjectCursor<RestoreInProgress.ShardRestoreStatus> objectCursor : shards.values()) {
            if (((RestoreInProgress.ShardRestoreStatus)objectCursor.value).state().completed()) continue;
            return false;
        }
        return true;
    }

    public static int failedShards(ImmutableOpenMap<ShardId, RestoreInProgress.ShardRestoreStatus> shards) {
        int failedShards = 0;
        for (ObjectCursor<RestoreInProgress.ShardRestoreStatus> objectCursor : shards.values()) {
            if (((RestoreInProgress.ShardRestoreStatus)objectCursor.value).state() != RestoreInProgress.State.FAILURE) continue;
            ++failedShards;
        }
        return failedShards;
    }

    private Map<String, String> renamedIndices(RestoreRequest request, List<String> filteredIndices) {
        HashMap<String, String> renamedIndices = new HashMap<String, String>();
        Iterator<String> iterator = filteredIndices.iterator();
        while (iterator.hasNext()) {
            String previousIndex;
            String index;
            String renamedIndex = index = iterator.next();
            if (request.renameReplacement() != null && request.renamePattern() != null) {
                renamedIndex = index.replaceAll(request.renamePattern(), request.renameReplacement());
            }
            if ((previousIndex = renamedIndices.put(renamedIndex, index)) == null) continue;
            throw new SnapshotRestoreException(request.repositoryName, request.snapshotName, "indices [" + index + "] and [" + previousIndex + "] are renamed into the same index [" + renamedIndex + "]");
        }
        return Collections.unmodifiableMap(renamedIndices);
    }

    private void validateSnapshotRestorable(String repository, SnapshotInfo snapshotInfo) {
        if (!snapshotInfo.state().restorable()) {
            throw new SnapshotRestoreException(new Snapshot(repository, snapshotInfo.snapshotId()), "unsupported snapshot state [" + (Object)((Object)snapshotInfo.state()) + "]");
        }
        if (Version.CURRENT.before(snapshotInfo.version())) {
            throw new SnapshotRestoreException(new Snapshot(repository, snapshotInfo.snapshotId()), "the snapshot was created with Elasticsearch version [" + snapshotInfo.version() + "] which is higher than the version of this node [" + Version.CURRENT + "]");
        }
    }

    private boolean failed(SnapshotInfo snapshot, String index) {
        for (SnapshotShardFailure failure : snapshot.shardFailures()) {
            if (!index.equals(failure.index())) continue;
            return true;
        }
        return false;
    }

    public static void checkIndexClosing(ClusterState currentState, Set<IndexMetaData> indices) {
        RestoreInProgress restore = (RestoreInProgress)currentState.custom("restore");
        if (restore != null) {
            HashSet<Index> indicesToFail = null;
            for (RestoreInProgress.Entry entry : restore.entries()) {
                for (ObjectObjectCursor<ShardId, RestoreInProgress.ShardRestoreStatus> objectObjectCursor : entry.shards()) {
                    IndexMetaData indexMetaData;
                    if (((RestoreInProgress.ShardRestoreStatus)objectObjectCursor.value).state().completed() || (indexMetaData = currentState.metaData().index(((ShardId)objectObjectCursor.key).getIndex())) == null || !indices.contains(indexMetaData)) continue;
                    if (indicesToFail == null) {
                        indicesToFail = new HashSet<Index>();
                    }
                    indicesToFail.add(((ShardId)objectObjectCursor.key).getIndex());
                }
            }
            if (indicesToFail != null) {
                throw new IllegalArgumentException("Cannot close indices that are being restored: " + indicesToFail);
            }
        }
    }

    @Override
    public void applyClusterState(ClusterChangedEvent event) {
        try {
            if (event.localNodeMaster()) {
                this.cleanupRestoreState(event);
            }
        }
        catch (Exception t) {
            this.logger.warn("Failed to update restore state ", (Throwable)t);
        }
    }

    public static boolean isRepositoryInUse(ClusterState clusterState, String repository) {
        RestoreInProgress snapshots = (RestoreInProgress)clusterState.custom("restore");
        if (snapshots != null) {
            for (RestoreInProgress.Entry snapshot : snapshots.entries()) {
                if (!repository.equals(snapshot.snapshot().getRepository())) continue;
                return true;
            }
        }
        return false;
    }

    static {
        HashSet<String> unremovable = new HashSet<String>(UNMODIFIABLE_SETTINGS.size() + 4);
        unremovable.addAll(UNMODIFIABLE_SETTINGS);
        unremovable.add("index.number_of_replicas");
        unremovable.add("index.auto_expand_replicas");
        unremovable.add("index.version.upgraded");
        UNREMOVABLE_SETTINGS = Collections.unmodifiableSet(unremovable);
    }

    public static class RestoreRequest {
        private final String cause;
        private final String repositoryName;
        private final String snapshotName;
        private final String[] indices;
        private final String renamePattern;
        private final String renameReplacement;
        private final IndicesOptions indicesOptions;
        private final Settings settings;
        private final TimeValue masterNodeTimeout;
        private final boolean includeGlobalState;
        private final boolean partial;
        private final boolean includeAliases;
        private final Settings indexSettings;
        private final String[] ignoreIndexSettings;

        public RestoreRequest(String repositoryName, String snapshotName, String[] indices, IndicesOptions indicesOptions, String renamePattern, String renameReplacement, Settings settings, TimeValue masterNodeTimeout, boolean includeGlobalState, boolean partial, boolean includeAliases, Settings indexSettings, String[] ignoreIndexSettings, String cause) {
            this.repositoryName = Objects.requireNonNull(repositoryName);
            this.snapshotName = Objects.requireNonNull(snapshotName);
            this.indices = indices;
            this.renamePattern = renamePattern;
            this.renameReplacement = renameReplacement;
            this.indicesOptions = indicesOptions;
            this.settings = settings;
            this.masterNodeTimeout = masterNodeTimeout;
            this.includeGlobalState = includeGlobalState;
            this.partial = partial;
            this.includeAliases = includeAliases;
            this.indexSettings = indexSettings;
            this.ignoreIndexSettings = ignoreIndexSettings;
            this.cause = cause;
        }

        public String cause() {
            return this.cause;
        }

        public String repositoryName() {
            return this.repositoryName;
        }

        public String snapshotName() {
            return this.snapshotName;
        }

        public String[] indices() {
            return this.indices;
        }

        public IndicesOptions indicesOptions() {
            return this.indicesOptions;
        }

        public String renamePattern() {
            return this.renamePattern;
        }

        public String renameReplacement() {
            return this.renameReplacement;
        }

        public Settings settings() {
            return this.settings;
        }

        public boolean includeGlobalState() {
            return this.includeGlobalState;
        }

        public boolean partial() {
            return this.partial;
        }

        public boolean includeAliases() {
            return this.includeAliases;
        }

        public Settings indexSettings() {
            return this.indexSettings;
        }

        public String[] ignoreIndexSettings() {
            return this.ignoreIndexSettings;
        }

        public TimeValue masterNodeTimeout() {
            return this.masterNodeTimeout;
        }
    }

    static class CleanRestoreStateTaskExecutor
    implements ClusterStateTaskExecutor<Task>,
    ClusterStateTaskListener {
        private final Logger logger;

        CleanRestoreStateTaskExecutor(Logger logger) {
            this.logger = logger;
        }

        @Override
        public ClusterStateTaskExecutor.ClusterTasksResult<Task> execute(ClusterState currentState, List<Task> tasks) throws Exception {
            ClusterStateTaskExecutor.ClusterTasksResult.Builder<Task> resultBuilder = ClusterStateTaskExecutor.ClusterTasksResult.builder().successes(tasks);
            Set completedSnapshots = tasks.stream().map(e -> e.snapshot).collect(Collectors.toSet());
            ArrayList<RestoreInProgress.Entry> entries = new ArrayList<RestoreInProgress.Entry>();
            RestoreInProgress restoreInProgress = (RestoreInProgress)currentState.custom("restore");
            boolean changed = false;
            if (restoreInProgress != null) {
                for (RestoreInProgress.Entry entry : restoreInProgress.entries()) {
                    if (!completedSnapshots.contains(entry.snapshot())) {
                        entries.add(entry);
                        continue;
                    }
                    changed = true;
                }
            }
            if (!changed) {
                return resultBuilder.build(currentState);
            }
            RestoreInProgress updatedRestoreInProgress = new RestoreInProgress(entries.toArray(new RestoreInProgress.Entry[entries.size()]));
            ImmutableOpenMap.Builder<String, ClusterState.Custom> builder = ImmutableOpenMap.builder(currentState.getCustoms());
            builder.put("restore", updatedRestoreInProgress);
            ImmutableOpenMap<String, ClusterState.Custom> customs = builder.build();
            return resultBuilder.build(ClusterState.builder(currentState).customs(customs).build());
        }

        @Override
        public void onFailure(String source, Exception e) {
            this.logger.error(() -> new ParameterizedMessage("unexpected failure during [{}]", (Object)source), (Throwable)e);
        }

        @Override
        public void onNoLongerMaster(String source) {
            this.logger.debug("no longer master while processing restore state update [{}]", (Object)source);
        }

        static class Task {
            final Snapshot snapshot;

            Task(Snapshot snapshot) {
                this.snapshot = snapshot;
            }

            public String toString() {
                return "clean restore state for restoring snapshot " + this.snapshot;
            }
        }
    }

    public static class RestoreInProgressUpdater
    extends RoutingChangesObserver.AbstractRoutingChangesObserver {
        private final Map<Snapshot, Updates> shardChanges = new HashMap<Snapshot, Updates>();

        @Override
        public void shardStarted(ShardRouting initializingShard, ShardRouting startedShard) {
            RecoverySource recoverySource;
            if (initializingShard.primary() && (recoverySource = initializingShard.recoverySource()).getType() == RecoverySource.Type.SNAPSHOT) {
                Snapshot snapshot = ((RecoverySource.SnapshotRecoverySource)recoverySource).snapshot();
                this.changes(snapshot).shards.put(initializingShard.shardId(), new RestoreInProgress.ShardRestoreStatus(initializingShard.currentNodeId(), RestoreInProgress.State.SUCCESS));
            }
        }

        @Override
        public void shardFailed(ShardRouting failedShard, UnassignedInfo unassignedInfo) {
            RecoverySource recoverySource;
            if (failedShard.primary() && failedShard.initializing() && (recoverySource = failedShard.recoverySource()).getType() == RecoverySource.Type.SNAPSHOT) {
                Snapshot snapshot = ((RecoverySource.SnapshotRecoverySource)recoverySource).snapshot();
                if (unassignedInfo.getFailure() != null && Lucene.isCorruptionException(unassignedInfo.getFailure().getCause())) {
                    this.changes(snapshot).shards.put(failedShard.shardId(), new RestoreInProgress.ShardRestoreStatus(failedShard.currentNodeId(), RestoreInProgress.State.FAILURE, unassignedInfo.getFailure().getCause().getMessage()));
                }
            }
        }

        @Override
        public void shardInitialized(ShardRouting unassignedShard, ShardRouting initializedShard) {
            if (unassignedShard.recoverySource().getType() == RecoverySource.Type.SNAPSHOT && initializedShard.recoverySource().getType() != RecoverySource.Type.SNAPSHOT) {
                Snapshot snapshot = ((RecoverySource.SnapshotRecoverySource)unassignedShard.recoverySource()).snapshot();
                this.changes(snapshot).shards.put(unassignedShard.shardId(), new RestoreInProgress.ShardRestoreStatus(null, RestoreInProgress.State.FAILURE, "recovery source type changed from snapshot to " + initializedShard.recoverySource()));
            }
        }

        @Override
        public void unassignedInfoUpdated(ShardRouting unassignedShard, UnassignedInfo newUnassignedInfo) {
            RecoverySource recoverySource = unassignedShard.recoverySource();
            if (recoverySource.getType() == RecoverySource.Type.SNAPSHOT && newUnassignedInfo.getLastAllocationStatus() == UnassignedInfo.AllocationStatus.DECIDERS_NO) {
                Snapshot snapshot = ((RecoverySource.SnapshotRecoverySource)recoverySource).snapshot();
                String reason = "shard could not be allocated to any of the nodes";
                this.changes(snapshot).shards.put(unassignedShard.shardId(), new RestoreInProgress.ShardRestoreStatus(unassignedShard.currentNodeId(), RestoreInProgress.State.FAILURE, reason));
            }
        }

        private Updates changes(Snapshot snapshot) {
            return this.shardChanges.computeIfAbsent(snapshot, k -> new Updates());
        }

        public RestoreInProgress applyChanges(RestoreInProgress oldRestore) {
            if (!this.shardChanges.isEmpty()) {
                ArrayList<RestoreInProgress.Entry> entries = new ArrayList<RestoreInProgress.Entry>();
                for (RestoreInProgress.Entry entry : oldRestore.entries()) {
                    Snapshot snapshot = entry.snapshot();
                    Updates updates = this.shardChanges.get(snapshot);
                    if (!updates.shards.isEmpty()) {
                        ImmutableOpenMap.Builder<ShardId, RestoreInProgress.ShardRestoreStatus> shardsBuilder = ImmutableOpenMap.builder(entry.shards());
                        for (Map.Entry shard : updates.shards.entrySet()) {
                            shardsBuilder.put((ShardId)shard.getKey(), (RestoreInProgress.ShardRestoreStatus)shard.getValue());
                        }
                        ImmutableOpenMap<ShardId, RestoreInProgress.ShardRestoreStatus> shards = shardsBuilder.build();
                        RestoreInProgress.State newState = RestoreService.overallState(RestoreInProgress.State.STARTED, shards);
                        entries.add(new RestoreInProgress.Entry(entry.snapshot(), newState, entry.indices(), shards));
                        continue;
                    }
                    entries.add(entry);
                }
                return new RestoreInProgress(entries.toArray(new RestoreInProgress.Entry[entries.size()]));
            }
            return oldRestore;
        }

        private static class Updates {
            private Map<ShardId, RestoreInProgress.ShardRestoreStatus> shards = new HashMap<ShardId, RestoreInProgress.ShardRestoreStatus>();

            private Updates() {
            }
        }
    }

    public static final class RestoreCompletionResponse {
        private final Snapshot snapshot;
        private final RestoreInfo restoreInfo;

        private RestoreCompletionResponse(Snapshot snapshot, RestoreInfo restoreInfo) {
            this.snapshot = snapshot;
            this.restoreInfo = restoreInfo;
        }

        public Snapshot getSnapshot() {
            return this.snapshot;
        }

        public RestoreInfo getRestoreInfo() {
            return this.restoreInfo;
        }
    }
}

