/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.transport.netty4;

import conductor.io.netty.buffer.ByteBuf;
import conductor.io.netty.channel.Channel;
import conductor.io.netty.channel.ChannelDuplexHandler;
import conductor.io.netty.channel.ChannelHandlerContext;
import conductor.io.netty.util.Attribute;
import conductor.org.elasticsearch.ExceptionsHelper;
import conductor.org.elasticsearch.common.bytes.BytesReference;
import conductor.org.elasticsearch.transport.Transports;
import conductor.org.elasticsearch.transport.netty4.Netty4Transport;
import conductor.org.elasticsearch.transport.netty4.Netty4Utils;
import conductor.org.elasticsearch.transport.netty4.NettyTcpChannel;
import java.net.InetSocketAddress;

final class Netty4MessageChannelHandler
extends ChannelDuplexHandler {
    private final Netty4Transport transport;
    private final String profileName;

    Netty4MessageChannelHandler(Netty4Transport transport, String profileName) {
        this.transport = transport;
        this.profileName = profileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        Transports.assertTransportThread();
        if (!(msg instanceof ByteBuf)) {
            ctx.fireChannelRead(msg);
            return;
        }
        ByteBuf buffer = (ByteBuf)msg;
        int remainingMessageSize = buffer.getInt(buffer.readerIndex() - 4);
        int expectedReaderIndex = buffer.readerIndex() + remainingMessageSize;
        try {
            Channel channel = ctx.channel();
            InetSocketAddress remoteAddress = (InetSocketAddress)channel.remoteAddress();
            BytesReference reference = Netty4Utils.toBytesReference(buffer, remainingMessageSize);
            Attribute<NettyTcpChannel> channelAttribute = channel.attr(Netty4Transport.CHANNEL_KEY);
            this.transport.messageReceived(reference, channelAttribute.get(), this.profileName, remoteAddress, remainingMessageSize);
        }
        finally {
            buffer.readerIndex(expectedReaderIndex);
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        ExceptionsHelper.maybeDieOnAnotherThread(cause);
        this.transport.exceptionCaught(ctx, cause);
    }
}

