/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.transport.netty4;

import conductor.io.netty.channel.Channel;
import conductor.io.netty.channel.ChannelFuture;
import conductor.io.netty.channel.ChannelFutureListener;
import conductor.io.netty.channel.ChannelHandler;
import conductor.io.netty.channel.ChannelHandlerContext;
import conductor.io.netty.channel.ChannelInboundHandlerAdapter;
import conductor.org.apache.logging.log4j.Logger;
import conductor.org.elasticsearch.common.lease.Releasable;
import conductor.org.elasticsearch.common.metrics.CounterMetric;
import conductor.org.elasticsearch.transport.netty4.Netty4Utils;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

@ChannelHandler.Sharable
public class Netty4OpenChannelsHandler
extends ChannelInboundHandlerAdapter
implements Releasable {
    final Set<Channel> openChannels = Collections.newSetFromMap(new ConcurrentHashMap());
    final CounterMetric openChannelsMetric = new CounterMetric();
    final CounterMetric totalChannelsMetric = new CounterMetric();
    final Logger logger;
    final ChannelFutureListener remover = new ChannelFutureListener(){

        @Override
        public void operationComplete(ChannelFuture future) throws Exception {
            boolean removed = Netty4OpenChannelsHandler.this.openChannels.remove(future.channel());
            if (removed) {
                Netty4OpenChannelsHandler.this.openChannelsMetric.dec();
            }
            if (Netty4OpenChannelsHandler.this.logger.isTraceEnabled()) {
                Netty4OpenChannelsHandler.this.logger.trace("channel closed: {}", (Object)future.channel());
            }
        }
    };

    public Netty4OpenChannelsHandler(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        boolean added;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("channel opened: {}", (Object)ctx.channel());
        }
        if (added = this.openChannels.add(ctx.channel())) {
            this.openChannelsMetric.inc();
            this.totalChannelsMetric.inc();
            ctx.channel().closeFuture().addListener(this.remover);
        }
        super.channelActive(ctx);
    }

    public long numberOfOpenChannels() {
        return this.openChannelsMetric.count();
    }

    public long totalChannels() {
        return this.totalChannelsMetric.count();
    }

    @Override
    public void close() {
        try {
            Netty4Utils.closeChannels(this.openChannels);
        }
        catch (IOException e) {
            this.logger.trace("exception while closing channels", (Throwable)e);
        }
        this.openChannels.clear();
    }
}

