/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.elasticsearch.query.parser;

import com.netflix.conductor.elasticsearch.query.parser.AbstractNode;
import com.netflix.conductor.elasticsearch.query.parser.ParserException;
import java.io.InputStream;

public class BooleanOp
extends AbstractNode {
    private String value;

    public BooleanOp(InputStream is) throws ParserException {
        super(is);
    }

    @Override
    protected void _parse() throws Exception {
        byte[] buffer = this.peek(3);
        if (buffer.length > 1 && buffer[0] == 79 && buffer[1] == 82) {
            this.value = "OR";
        } else if (buffer.length > 2 && buffer[0] == 65 && buffer[1] == 78 && buffer[2] == 68) {
            this.value = "AND";
        } else {
            throw new ParserException("No valid boolean operator found...");
        }
        this.read(this.value.length());
    }

    public String toString() {
        return " " + this.value + " ";
    }

    public String getOperator() {
        return this.value;
    }

    public boolean isAnd() {
        return "AND".equals(this.value);
    }

    public boolean isOr() {
        return "OR".equals(this.value);
    }
}

