/*
 * Decompiled with CFR 0.152.
 */
package conductor.com.carrotsearch.hppc;

import conductor.com.carrotsearch.hppc.BitMixer;
import conductor.com.carrotsearch.hppc.HashOrderMixing;
import conductor.com.carrotsearch.hppc.ShortLongHashMap;

public class ShortLongScatterMap
extends ShortLongHashMap {
    public ShortLongScatterMap() {
        this(4);
    }

    public ShortLongScatterMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public ShortLongScatterMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor, HashOrderMixing.none());
    }

    @Override
    protected int hashKey(short key) {
        return BitMixer.mixPhi(key);
    }

    public static ShortLongScatterMap from(short[] keys, long[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        ShortLongScatterMap map = new ShortLongScatterMap(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }
}

