/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.http.impl.nio.codecs;

import conductor.org.apache.http.HttpResponse;
import conductor.org.apache.http.HttpResponseFactory;
import conductor.org.apache.http.annotation.Contract;
import conductor.org.apache.http.annotation.ThreadingBehavior;
import conductor.org.apache.http.config.MessageConstraints;
import conductor.org.apache.http.impl.DefaultHttpResponseFactory;
import conductor.org.apache.http.impl.nio.codecs.DefaultHttpResponseParser;
import conductor.org.apache.http.message.BasicLineParser;
import conductor.org.apache.http.message.LineParser;
import conductor.org.apache.http.nio.NHttpMessageParser;
import conductor.org.apache.http.nio.NHttpMessageParserFactory;
import conductor.org.apache.http.nio.reactor.SessionInputBuffer;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultHttpResponseParserFactory
implements NHttpMessageParserFactory<HttpResponse> {
    public static final DefaultHttpResponseParserFactory INSTANCE = new DefaultHttpResponseParserFactory();
    private final LineParser lineParser;
    private final HttpResponseFactory responseFactory;

    public DefaultHttpResponseParserFactory(LineParser lineParser, HttpResponseFactory responseFactory) {
        this.lineParser = lineParser != null ? lineParser : BasicLineParser.INSTANCE;
        this.responseFactory = responseFactory != null ? responseFactory : DefaultHttpResponseFactory.INSTANCE;
    }

    public DefaultHttpResponseParserFactory() {
        this(null, null);
    }

    @Override
    public NHttpMessageParser<HttpResponse> create(SessionInputBuffer buffer, MessageConstraints constraints) {
        return new DefaultHttpResponseParser(buffer, this.lineParser, this.responseFactory, constraints);
    }
}

