/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.http.impl.nio.conn;

import conductor.org.apache.commons.logging.Log;
import conductor.org.apache.commons.logging.LogFactory;
import conductor.org.apache.http.annotation.Contract;
import conductor.org.apache.http.annotation.ThreadingBehavior;
import conductor.org.apache.http.conn.routing.HttpRoute;
import conductor.org.apache.http.impl.nio.conn.CPoolEntry;
import conductor.org.apache.http.nio.NHttpClientConnection;
import conductor.org.apache.http.nio.conn.ManagedNHttpClientConnection;
import conductor.org.apache.http.nio.pool.AbstractNIOConnPool;
import conductor.org.apache.http.nio.pool.NIOConnFactory;
import conductor.org.apache.http.nio.pool.SocketAddressResolver;
import conductor.org.apache.http.nio.reactor.ConnectingIOReactor;
import java.util.concurrent.TimeUnit;

@Contract(threading=ThreadingBehavior.SAFE)
class CPool
extends AbstractNIOConnPool<HttpRoute, ManagedNHttpClientConnection, CPoolEntry> {
    private final Log log = LogFactory.getLog(CPool.class);
    private final long timeToLive;
    private final TimeUnit tunit;

    public CPool(ConnectingIOReactor ioreactor, NIOConnFactory<HttpRoute, ManagedNHttpClientConnection> connFactory, SocketAddressResolver<HttpRoute> addressResolver, int defaultMaxPerRoute, int maxTotal, long timeToLive, TimeUnit tunit) {
        super(ioreactor, connFactory, addressResolver, defaultMaxPerRoute, maxTotal);
        this.timeToLive = timeToLive;
        this.tunit = tunit;
    }

    @Override
    protected CPoolEntry createEntry(HttpRoute route, ManagedNHttpClientConnection conn) {
        CPoolEntry entry = new CPoolEntry(this.log, conn.getId(), route, conn, this.timeToLive, this.tunit);
        entry.setSocketTimeout(conn.getSocketTimeout());
        return entry;
    }

    @Override
    protected void onLease(CPoolEntry entry) {
        NHttpClientConnection conn = (NHttpClientConnection)entry.getConnection();
        conn.setSocketTimeout(entry.getSocketTimeout());
    }

    @Override
    protected void onRelease(CPoolEntry entry) {
        NHttpClientConnection conn = (NHttpClientConnection)entry.getConnection();
        conn.setSocketTimeout(0);
    }
}

