/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.analysis.ar;

import conductor.org.apache.lucene.analysis.Analyzer;
import conductor.org.apache.lucene.analysis.CharArraySet;
import conductor.org.apache.lucene.analysis.LowerCaseFilter;
import conductor.org.apache.lucene.analysis.StopFilter;
import conductor.org.apache.lucene.analysis.StopwordAnalyzerBase;
import conductor.org.apache.lucene.analysis.TokenFilter;
import conductor.org.apache.lucene.analysis.TokenStream;
import conductor.org.apache.lucene.analysis.ar.ArabicNormalizationFilter;
import conductor.org.apache.lucene.analysis.ar.ArabicStemFilter;
import conductor.org.apache.lucene.analysis.core.DecimalDigitFilter;
import conductor.org.apache.lucene.analysis.miscellaneous.SetKeywordMarkerFilter;
import conductor.org.apache.lucene.analysis.standard.StandardTokenizer;
import java.io.IOException;

public final class ArabicAnalyzer
extends StopwordAnalyzerBase {
    public static final String DEFAULT_STOPWORD_FILE = "stopwords.txt";
    private final CharArraySet stemExclusionSet;

    public static CharArraySet getDefaultStopSet() {
        return DefaultSetHolder.DEFAULT_STOP_SET;
    }

    public ArabicAnalyzer() {
        this(DefaultSetHolder.DEFAULT_STOP_SET);
    }

    public ArabicAnalyzer(CharArraySet stopwords) {
        this(stopwords, CharArraySet.EMPTY_SET);
    }

    public ArabicAnalyzer(CharArraySet stopwords, CharArraySet stemExclusionSet) {
        super(stopwords);
        this.stemExclusionSet = CharArraySet.unmodifiableSet(CharArraySet.copy(stemExclusionSet));
    }

    @Override
    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        StandardTokenizer source = new StandardTokenizer();
        TokenFilter result = new LowerCaseFilter(source);
        result = new DecimalDigitFilter(result);
        result = new StopFilter(result, this.stopwords);
        result = new ArabicNormalizationFilter(result);
        if (!this.stemExclusionSet.isEmpty()) {
            result = new SetKeywordMarkerFilter(result, this.stemExclusionSet);
        }
        return new Analyzer.TokenStreamComponents(source, new ArabicStemFilter(result));
    }

    @Override
    protected TokenStream normalize(String fieldName, TokenStream in) {
        TokenFilter result = new LowerCaseFilter(in);
        result = new DecimalDigitFilter(result);
        result = new ArabicNormalizationFilter(result);
        return result;
    }

    private static class DefaultSetHolder {
        static final CharArraySet DEFAULT_STOP_SET;

        private DefaultSetHolder() {
        }

        static {
            try {
                DEFAULT_STOP_SET = ArabicAnalyzer.loadStopwordSet(false, ArabicAnalyzer.class, ArabicAnalyzer.DEFAULT_STOPWORD_FILE, "#");
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to load default stopword set");
            }
        }
    }
}

