/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.analysis.bg;

import conductor.org.apache.lucene.analysis.TokenFilter;
import conductor.org.apache.lucene.analysis.TokenStream;
import conductor.org.apache.lucene.analysis.bg.BulgarianStemmer;
import conductor.org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import conductor.org.apache.lucene.analysis.tokenattributes.KeywordAttribute;
import java.io.IOException;

public final class BulgarianStemFilter
extends TokenFilter {
    private final BulgarianStemmer stemmer = new BulgarianStemmer();
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private final KeywordAttribute keywordAttr = this.addAttribute(KeywordAttribute.class);

    public BulgarianStemFilter(TokenStream input) {
        super(input);
    }

    @Override
    public boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            if (!this.keywordAttr.isKeyword()) {
                int newlen = this.stemmer.stem(this.termAtt.buffer(), this.termAtt.length());
                this.termAtt.setLength(newlen);
            }
            return true;
        }
        return false;
    }
}

