/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.analysis.standard;

import conductor.org.apache.lucene.analysis.Analyzer;
import conductor.org.apache.lucene.analysis.CharArraySet;
import conductor.org.apache.lucene.analysis.LowerCaseFilter;
import conductor.org.apache.lucene.analysis.StopFilter;
import conductor.org.apache.lucene.analysis.StopwordAnalyzerBase;
import conductor.org.apache.lucene.analysis.TokenFilter;
import conductor.org.apache.lucene.analysis.TokenStream;
import conductor.org.apache.lucene.analysis.en.EnglishAnalyzer;
import conductor.org.apache.lucene.analysis.standard.ClassicFilter;
import conductor.org.apache.lucene.analysis.standard.ClassicTokenizer;
import java.io.IOException;
import java.io.Reader;

public final class ClassicAnalyzer
extends StopwordAnalyzerBase {
    public static final int DEFAULT_MAX_TOKEN_LENGTH = 255;
    private int maxTokenLength = 255;
    public static final CharArraySet STOP_WORDS_SET = EnglishAnalyzer.ENGLISH_STOP_WORDS_SET;

    public ClassicAnalyzer(CharArraySet stopWords) {
        super(stopWords);
    }

    public ClassicAnalyzer() {
        this(STOP_WORDS_SET);
    }

    public ClassicAnalyzer(Reader stopwords) throws IOException {
        this(ClassicAnalyzer.loadStopwordSet(stopwords));
    }

    public void setMaxTokenLength(int length) {
        this.maxTokenLength = length;
    }

    public int getMaxTokenLength() {
        return this.maxTokenLength;
    }

    @Override
    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        final ClassicTokenizer src = new ClassicTokenizer();
        src.setMaxTokenLength(this.maxTokenLength);
        TokenFilter tok = new ClassicFilter(src);
        tok = new LowerCaseFilter(tok);
        tok = new StopFilter(tok, this.stopwords);
        return new Analyzer.TokenStreamComponents(src, tok){

            @Override
            protected void setReader(Reader reader) {
                src.setMaxTokenLength(ClassicAnalyzer.this.maxTokenLength);
                super.setReader(reader);
            }
        };
    }

    @Override
    protected TokenStream normalize(String fieldName, TokenStream in) {
        return new LowerCaseFilter(in);
    }
}

