/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.document;

import conductor.org.apache.lucene.document.LatLonShape;
import conductor.org.apache.lucene.document.LatLonShapeQuery;
import conductor.org.apache.lucene.geo.GeoEncodingUtils;
import conductor.org.apache.lucene.geo.GeoUtils;
import conductor.org.apache.lucene.geo.Tessellator;
import conductor.org.apache.lucene.index.PointValues;
import conductor.org.apache.lucene.util.NumericUtils;
import java.util.Arrays;

final class LatLonShapeBoundingBoxQuery
extends LatLonShapeQuery {
    final byte[] bbox;
    final int minX;
    final int maxX;
    final int minY;
    final int maxY;

    public LatLonShapeBoundingBoxQuery(String field, LatLonShape.QueryRelation queryRelation, double minLat, double maxLat, double minLon, double maxLon) {
        super(field, queryRelation);
        if (minLon > maxLon) {
            throw new IllegalArgumentException("dateline crossing bounding box queries are not supported for [" + field + "]");
        }
        this.bbox = new byte[16];
        this.minX = GeoEncodingUtils.encodeLongitudeCeil(minLon);
        this.maxX = GeoEncodingUtils.encodeLongitude(maxLon);
        this.minY = GeoEncodingUtils.encodeLatitudeCeil(minLat);
        this.maxY = GeoEncodingUtils.encodeLatitude(maxLat);
        NumericUtils.intToSortableBytes(this.minY, this.bbox, 0);
        NumericUtils.intToSortableBytes(this.minX, this.bbox, 4);
        NumericUtils.intToSortableBytes(this.maxY, this.bbox, 8);
        NumericUtils.intToSortableBytes(this.maxX, this.bbox, 12);
    }

    @Override
    protected PointValues.Relation relateRangeBBoxToQuery(int minXOffset, int minYOffset, byte[] minTriangle, int maxXOffset, int maxYOffset, byte[] maxTriangle) {
        if (Arrays.compareUnsigned(minTriangle, minXOffset, minXOffset + 4, this.bbox, 12, 16) > 0 || Arrays.compareUnsigned(maxTriangle, maxXOffset, maxXOffset + 4, this.bbox, 4, 8) < 0 || Arrays.compareUnsigned(minTriangle, minYOffset, minYOffset + 4, this.bbox, 8, 12) > 0 || Arrays.compareUnsigned(maxTriangle, maxYOffset, maxYOffset + 4, this.bbox, 0, 4) < 0) {
            return PointValues.Relation.CELL_OUTSIDE_QUERY;
        }
        if (Arrays.compareUnsigned(minTriangle, minXOffset, minXOffset + 4, this.bbox, 4, 8) > 0 && Arrays.compareUnsigned(maxTriangle, maxXOffset, maxXOffset + 4, this.bbox, 12, 16) < 0 && Arrays.compareUnsigned(minTriangle, minYOffset, minYOffset + 4, this.bbox, 0, 4) > 0 && Arrays.compareUnsigned(maxTriangle, maxYOffset, maxYOffset + 4, this.bbox, 8, 8) < 0) {
            return PointValues.Relation.CELL_INSIDE_QUERY;
        }
        return PointValues.Relation.CELL_CROSSES_QUERY;
    }

    @Override
    protected boolean queryMatches(byte[] t) {
        if (this.queryRelation == LatLonShape.QueryRelation.WITHIN) {
            return this.queryContains(t, 0) && this.queryContains(t, 1) && this.queryContains(t, 2);
        }
        return this.queryIntersects(t);
    }

    protected boolean queryIntersects(byte[] t) {
        if (this.queryContains(t, 0) || this.queryContains(t, 1) || this.queryContains(t, 2)) {
            return true;
        }
        int aY = NumericUtils.sortableBytesToInt(t, 0);
        int aX = NumericUtils.sortableBytesToInt(t, 4);
        int bY = NumericUtils.sortableBytesToInt(t, 8);
        int bX = NumericUtils.sortableBytesToInt(t, 12);
        int cY = NumericUtils.sortableBytesToInt(t, 16);
        int cX = NumericUtils.sortableBytesToInt(t, 20);
        int tMinX = StrictMath.min(StrictMath.min(aX, bX), cX);
        int tMaxX = StrictMath.max(StrictMath.max(aX, bX), cX);
        int tMinY = StrictMath.min(StrictMath.min(aY, bY), cY);
        int tMaxY = StrictMath.max(StrictMath.max(aY, bY), cY);
        if (tMaxX < this.minX || tMinX > this.maxX || tMinY > this.maxY || tMaxY < this.minY) {
            return false;
        }
        if (Tessellator.pointInTriangle(this.minX, this.minY, aX, aY, bX, bY, cX, cY)) {
            return true;
        }
        if (Tessellator.pointInTriangle(this.maxX, this.minY, aX, aY, bX, bY, cX, cY)) {
            return true;
        }
        if (Tessellator.pointInTriangle(this.maxX, this.maxY, aX, aY, bX, bY, cX, cY)) {
            return true;
        }
        if (Tessellator.pointInTriangle(this.minX, this.maxY, aX, aY, bX, bY, cX, cY)) {
            return true;
        }
        return this.queryIntersects(aX, aY, bX, bY, cX, cY);
    }

    private boolean edgeIntersectsQuery(double ax, double ay, double bx, double by) {
        if (GeoUtils.orient(ax, ay, bx, by, this.minX, this.maxY) * GeoUtils.orient(ax, ay, bx, by, this.maxX, this.maxY) <= 0 && GeoUtils.orient(this.minX, this.maxY, this.maxX, this.maxY, ax, ay) * GeoUtils.orient(this.minX, this.maxY, this.maxX, this.maxY, bx, by) <= 0) {
            return true;
        }
        if (GeoUtils.orient(ax, ay, bx, by, this.maxX, this.maxY) * GeoUtils.orient(ax, ay, bx, by, this.maxX, this.minY) <= 0 && GeoUtils.orient(this.maxX, this.maxY, this.maxX, this.minY, ax, ay) * GeoUtils.orient(this.maxX, this.maxY, this.maxX, this.minY, bx, by) <= 0) {
            return true;
        }
        if (GeoUtils.orient(ax, ay, bx, by, this.maxX, this.minY) * GeoUtils.orient(ax, ay, bx, by, this.minX, this.minY) <= 0 && GeoUtils.orient(this.maxX, this.minY, this.minX, this.minY, ax, ay) * GeoUtils.orient(this.maxX, this.minY, this.minX, this.minY, bx, by) <= 0) {
            return true;
        }
        return GeoUtils.orient(ax, ay, bx, by, this.minX, this.minY) * GeoUtils.orient(ax, ay, bx, by, this.minX, this.maxY) <= 0 && GeoUtils.orient(this.minX, this.minY, this.minX, this.maxY, ax, ay) * GeoUtils.orient(this.minX, this.minY, this.minX, this.maxY, bx, by) <= 0;
    }

    private boolean queryContains(byte[] t, int point) {
        int yIdx = 8 * point;
        int xIdx = yIdx + 4;
        return Arrays.compareUnsigned(t, yIdx, xIdx, this.bbox, 0, 4) >= 0 && Arrays.compareUnsigned(t, yIdx, xIdx, this.bbox, 8, 12) <= 0 && Arrays.compareUnsigned(t, xIdx, xIdx + 4, this.bbox, 4, 8) >= 0 && Arrays.compareUnsigned(t, xIdx, xIdx + 4, this.bbox, 12, this.bbox.length) <= 0;
    }

    private boolean queryIntersects(int ax, int ay, int bx, int by, int cx, int cy) {
        return this.edgeIntersectsQuery(ax, ay, bx, by) || this.edgeIntersectsQuery(bx, by, cx, cy) || this.edgeIntersectsQuery(cx, cy, ax, ay);
    }

    @Override
    public boolean equals(Object o) {
        return this.sameClassAs(o) && this.equalsTo(this.getClass().cast(o));
    }

    @Override
    protected boolean equalsTo(Object o) {
        return super.equalsTo(o) && Arrays.equals(this.bbox, ((LatLonShapeBoundingBoxQuery)o).bbox);
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 31 * hash + Arrays.hashCode(this.bbox);
        return hash;
    }

    @Override
    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(':');
        if (!this.field.equals(field)) {
            sb.append(" field=");
            sb.append(this.field);
            sb.append(':');
        }
        sb.append("Rectangle(lat=");
        sb.append(GeoEncodingUtils.decodeLatitude(this.minY));
        sb.append(" TO ");
        sb.append(GeoEncodingUtils.decodeLatitude(this.maxY));
        sb.append(" lon=");
        sb.append(GeoEncodingUtils.decodeLongitude(this.minX));
        sb.append(" TO ");
        sb.append(GeoEncodingUtils.decodeLongitude(this.maxX));
        sb.append(")");
        return sb.toString();
    }
}

