/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.index;

import conductor.org.apache.lucene.index.DocValuesFieldUpdates;
import conductor.org.apache.lucene.index.DocValuesType;
import conductor.org.apache.lucene.util.BytesRef;
import conductor.org.apache.lucene.util.RamUsageEstimator;
import conductor.org.apache.lucene.util.packed.PagedGrowableWriter;
import conductor.org.apache.lucene.util.packed.PagedMutable;

final class NumericDocValuesFieldUpdates
extends DocValuesFieldUpdates {
    private PagedGrowableWriter values = new PagedGrowableWriter(1L, 1024, 1, 0.5f);

    public NumericDocValuesFieldUpdates(long delGen, String field, int maxDoc) {
        super(maxDoc, delGen, field, DocValuesType.NUMERIC);
    }

    @Override
    void add(int doc, BytesRef value) {
        throw new UnsupportedOperationException();
    }

    @Override
    void add(int docId, DocValuesFieldUpdates.Iterator iterator) {
        this.add(docId, iterator.longValue());
    }

    @Override
    synchronized void add(int doc, long value) {
        int add = this.add(doc);
        this.values.set(add, value);
    }

    @Override
    protected void swap(int i, int j) {
        super.swap(i, j);
        long tmpVal = this.values.get(j);
        this.values.set(j, this.values.get(i));
        this.values.set(i, tmpVal);
    }

    @Override
    protected void grow(int size) {
        super.grow(size);
        this.values = (PagedGrowableWriter)this.values.grow(size);
    }

    @Override
    protected void resize(int size) {
        super.resize(size);
        this.values = (PagedGrowableWriter)this.values.resize(size);
    }

    @Override
    Iterator iterator() {
        this.ensureFinished();
        return new Iterator(this.size, this.values, this.docs, this.delGen);
    }

    @Override
    public long ramBytesUsed() {
        return this.values.ramBytesUsed() + super.ramBytesUsed() + 8L + (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF;
    }

    static final class Iterator
    extends DocValuesFieldUpdates.AbstractIterator {
        private final PagedGrowableWriter values;
        private long value;

        Iterator(int size, PagedGrowableWriter values, PagedMutable docs, long delGen) {
            super(size, docs, delGen);
            this.values = values;
        }

        @Override
        long longValue() {
            return this.value;
        }

        @Override
        BytesRef binaryValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void set(long idx) {
            this.value = this.values.get(idx);
        }
    }
}

