/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.queryparser.xml;

import conductor.org.apache.lucene.analysis.Analyzer;
import conductor.org.apache.lucene.queryparser.classic.QueryParser;
import conductor.org.apache.lucene.queryparser.xml.ParserException;
import conductor.org.apache.lucene.queryparser.xml.QueryBuilder;
import conductor.org.apache.lucene.queryparser.xml.QueryBuilderFactory;
import conductor.org.apache.lucene.queryparser.xml.builders.BooleanQueryBuilder;
import conductor.org.apache.lucene.queryparser.xml.builders.BoostingTermBuilder;
import conductor.org.apache.lucene.queryparser.xml.builders.ConstantScoreQueryBuilder;
import conductor.org.apache.lucene.queryparser.xml.builders.DisjunctionMaxQueryBuilder;
import conductor.org.apache.lucene.queryparser.xml.builders.MatchAllDocsQueryBuilder;
import conductor.org.apache.lucene.queryparser.xml.builders.PointRangeQueryBuilder;
import conductor.org.apache.lucene.queryparser.xml.builders.RangeQueryBuilder;
import conductor.org.apache.lucene.queryparser.xml.builders.SpanFirstBuilder;
import conductor.org.apache.lucene.queryparser.xml.builders.SpanNearBuilder;
import conductor.org.apache.lucene.queryparser.xml.builders.SpanNotBuilder;
import conductor.org.apache.lucene.queryparser.xml.builders.SpanOrBuilder;
import conductor.org.apache.lucene.queryparser.xml.builders.SpanOrTermsBuilder;
import conductor.org.apache.lucene.queryparser.xml.builders.SpanQueryBuilder;
import conductor.org.apache.lucene.queryparser.xml.builders.SpanQueryBuilderFactory;
import conductor.org.apache.lucene.queryparser.xml.builders.SpanTermBuilder;
import conductor.org.apache.lucene.queryparser.xml.builders.TermQueryBuilder;
import conductor.org.apache.lucene.queryparser.xml.builders.TermsQueryBuilder;
import conductor.org.apache.lucene.queryparser.xml.builders.UserInputQueryBuilder;
import conductor.org.apache.lucene.search.Query;
import conductor.org.apache.lucene.search.spans.SpanQuery;
import java.io.InputStream;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class CoreParser
implements QueryBuilder,
SpanQueryBuilder {
    protected String defaultField;
    protected Analyzer analyzer;
    protected QueryParser parser;
    protected QueryBuilderFactory queryFactory;
    protected final SpanQueryBuilderFactory spanFactory;
    public static final EntityResolver DISALLOW_EXTERNAL_ENTITY_RESOLVER = (publicId, systemId) -> {
        throw new SAXException(String.format(Locale.ENGLISH, "External Entity resolving unsupported:  publicId=\"%s\" systemId=\"%s\"", publicId, systemId));
    };

    public CoreParser(Analyzer analyzer, QueryParser parser) {
        this(null, analyzer, parser);
    }

    public CoreParser(String defaultField, Analyzer analyzer) {
        this(defaultField, analyzer, null);
    }

    protected CoreParser(String defaultField, Analyzer analyzer, QueryParser parser) {
        this.defaultField = defaultField;
        this.analyzer = analyzer;
        this.parser = parser;
        this.queryFactory = new QueryBuilderFactory();
        this.spanFactory = new SpanQueryBuilderFactory();
        this.queryFactory.addBuilder("TermQuery", new TermQueryBuilder());
        this.queryFactory.addBuilder("TermsQuery", new TermsQueryBuilder(analyzer));
        this.queryFactory.addBuilder("MatchAllDocsQuery", new MatchAllDocsQueryBuilder());
        this.queryFactory.addBuilder("BooleanQuery", new BooleanQueryBuilder(this.queryFactory));
        this.queryFactory.addBuilder("PointRangeQuery", new PointRangeQueryBuilder());
        this.queryFactory.addBuilder("RangeQuery", new RangeQueryBuilder());
        this.queryFactory.addBuilder("DisjunctionMaxQuery", new DisjunctionMaxQueryBuilder(this.queryFactory));
        if (parser != null) {
            this.queryFactory.addBuilder("UserQuery", new UserInputQueryBuilder(parser));
        } else {
            this.queryFactory.addBuilder("UserQuery", new UserInputQueryBuilder(defaultField, analyzer));
        }
        this.queryFactory.addBuilder("ConstantScoreQuery", new ConstantScoreQueryBuilder(this.queryFactory));
        SpanNearBuilder snb = new SpanNearBuilder(this.spanFactory);
        this.spanFactory.addBuilder("SpanNear", snb);
        this.queryFactory.addBuilder("SpanNear", snb);
        BoostingTermBuilder btb = new BoostingTermBuilder();
        this.spanFactory.addBuilder("BoostingTermQuery", btb);
        this.queryFactory.addBuilder("BoostingTermQuery", btb);
        SpanTermBuilder snt = new SpanTermBuilder();
        this.spanFactory.addBuilder("SpanTerm", snt);
        this.queryFactory.addBuilder("SpanTerm", snt);
        SpanOrBuilder sot = new SpanOrBuilder(this.spanFactory);
        this.spanFactory.addBuilder("SpanOr", sot);
        this.queryFactory.addBuilder("SpanOr", sot);
        SpanOrTermsBuilder sots = new SpanOrTermsBuilder(analyzer);
        this.spanFactory.addBuilder("SpanOrTerms", sots);
        this.queryFactory.addBuilder("SpanOrTerms", sots);
        SpanFirstBuilder sft = new SpanFirstBuilder(this.spanFactory);
        this.spanFactory.addBuilder("SpanFirst", sft);
        this.queryFactory.addBuilder("SpanFirst", sft);
        SpanNotBuilder snot = new SpanNotBuilder(this.spanFactory);
        this.spanFactory.addBuilder("SpanNot", snot);
        this.queryFactory.addBuilder("SpanNot", snot);
    }

    public Query parse(InputStream xmlStream) throws ParserException {
        return this.getQuery(this.parseXML(xmlStream).getDocumentElement());
    }

    SpanQuery parseAsSpanQuery(InputStream xmlStream) throws ParserException {
        return this.getSpanQuery(this.parseXML(xmlStream).getDocumentElement());
    }

    public void addQueryBuilder(String nodeName, QueryBuilder builder) {
        this.queryFactory.addBuilder(nodeName, builder);
    }

    public void addSpanBuilder(String nodeName, SpanQueryBuilder builder) {
        this.spanFactory.addBuilder(nodeName, builder);
    }

    public void addSpanQueryBuilder(String nodeName, SpanQueryBuilder builder) {
        this.queryFactory.addBuilder(nodeName, builder);
        this.spanFactory.addBuilder(nodeName, builder);
    }

    protected EntityResolver getEntityResolver() {
        return DISALLOW_EXTERNAL_ENTITY_RESOLVER;
    }

    protected ErrorHandler getErrorHandler() {
        return null;
    }

    private Document parseXML(InputStream pXmlFile) throws ParserException {
        DocumentBuilder db;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        try {
            dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        try {
            db = dbf.newDocumentBuilder();
        }
        catch (Exception se) {
            throw new ParserException("XML Parser configuration error.", se);
        }
        try {
            db.setEntityResolver(this.getEntityResolver());
            db.setErrorHandler(this.getErrorHandler());
            return db.parse(pXmlFile);
        }
        catch (Exception se) {
            throw new ParserException("Error parsing XML stream: " + se, se);
        }
    }

    @Override
    public Query getQuery(Element e) throws ParserException {
        return this.queryFactory.getQuery(e);
    }

    @Override
    public SpanQuery getSpanQuery(Element e) throws ParserException {
        return this.spanFactory.getSpanQuery(e);
    }
}

