/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.search;

import conductor.org.apache.lucene.index.IndexReader;
import conductor.org.apache.lucene.search.ConstantScoreQuery;
import conductor.org.apache.lucene.search.IndexSearcher;
import conductor.org.apache.lucene.search.Query;
import conductor.org.apache.lucene.search.Weight;
import java.io.IOException;
import java.util.Objects;

public final class BoostQuery
extends Query {
    private final Query query;
    private final float boost;

    public BoostQuery(Query query, float boost) {
        this.query = Objects.requireNonNull(query);
        this.boost = boost;
    }

    public Query getQuery() {
        return this.query;
    }

    public float getBoost() {
        return this.boost;
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((BoostQuery)this.getClass().cast(other));
    }

    private boolean equalsTo(BoostQuery other) {
        return this.query.equals(other.query) && Float.floatToIntBits(this.boost) == Float.floatToIntBits(other.boost);
    }

    @Override
    public int hashCode() {
        int h = this.classHash();
        h = 31 * h + this.query.hashCode();
        h = 31 * h + Float.floatToIntBits(this.boost);
        return h;
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        Query rewritten = this.query.rewrite(reader);
        if (this.boost == 1.0f) {
            return rewritten;
        }
        if (rewritten.getClass() == BoostQuery.class) {
            BoostQuery in = (BoostQuery)rewritten;
            return new BoostQuery(in.query, this.boost * in.boost);
        }
        if (this.boost == 0.0f && rewritten.getClass() != ConstantScoreQuery.class) {
            return new BoostQuery(new ConstantScoreQuery(rewritten), 0.0f);
        }
        if (this.query != rewritten) {
            return new BoostQuery(rewritten, this.boost);
        }
        return super.rewrite(reader);
    }

    @Override
    public String toString(String field) {
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        builder.append(this.query.toString(field));
        builder.append(")");
        builder.append("^");
        builder.append(this.boost);
        return builder.toString();
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores, float boost) throws IOException {
        return this.query.createWeight(searcher, needsScores, this.boost * boost);
    }
}

