/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.search.grouping;

import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.apache.lucene.search.Collector;
import conductor.org.apache.lucene.search.LeafCollector;
import conductor.org.apache.lucene.search.Scorer;
import conductor.org.apache.lucene.search.grouping.SearchGroup;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public abstract class GroupReducer<T, C extends Collector> {
    private final Map<T, GroupCollector<C>> groups = new HashMap<T, GroupCollector<C>>();

    public void setGroups(Collection<SearchGroup<T>> groups) {
        for (SearchGroup<T> group : groups) {
            this.groups.put(group.groupValue, new GroupCollector((Collector)this.newCollector(), null));
        }
    }

    public abstract boolean needsScores();

    protected abstract C newCollector();

    public final C getCollector(T value) {
        return this.groups.get(value).collector;
    }

    public final void collect(T value, int doc) throws IOException {
        GroupCollector<C> collector = this.groups.get(value);
        collector.leafCollector.collect(doc);
    }

    public final void setScorer(Scorer scorer) throws IOException {
        for (GroupCollector<C> collector : this.groups.values()) {
            collector.leafCollector.setScorer(scorer);
        }
    }

    public final void setNextReader(LeafReaderContext ctx) throws IOException {
        for (GroupCollector<C> collector : this.groups.values()) {
            collector.leafCollector = collector.collector.getLeafCollector(ctx);
        }
    }

    private static final class GroupCollector<C extends Collector> {
        final C collector;
        LeafCollector leafCollector;

        private GroupCollector(C collector) {
            this.collector = collector;
        }

        /* synthetic */ GroupCollector(Collector x0, 1 x1) {
            this(x0);
        }
    }
}

