/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.admin.cluster.repositories.delete;

import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.action.admin.cluster.repositories.delete.DeleteRepositoryRequest;
import conductor.org.elasticsearch.action.support.ActionFilters;
import conductor.org.elasticsearch.action.support.master.AcknowledgedResponse;
import conductor.org.elasticsearch.action.support.master.TransportMasterNodeAction;
import conductor.org.elasticsearch.cluster.ClusterState;
import conductor.org.elasticsearch.cluster.ack.ClusterStateUpdateResponse;
import conductor.org.elasticsearch.cluster.block.ClusterBlockException;
import conductor.org.elasticsearch.cluster.block.ClusterBlockLevel;
import conductor.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import conductor.org.elasticsearch.cluster.service.ClusterService;
import conductor.org.elasticsearch.common.inject.Inject;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.repositories.RepositoriesService;
import conductor.org.elasticsearch.threadpool.ThreadPool;
import conductor.org.elasticsearch.transport.TransportService;

public class TransportDeleteRepositoryAction
extends TransportMasterNodeAction<DeleteRepositoryRequest, AcknowledgedResponse> {
    private final RepositoriesService repositoriesService;

    @Inject
    public TransportDeleteRepositoryAction(Settings settings, TransportService transportService, ClusterService clusterService, RepositoriesService repositoriesService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, "cluster:admin/repository/delete", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, DeleteRepositoryRequest::new);
        this.repositoriesService = repositoriesService;
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected AcknowledgedResponse newResponse() {
        return new AcknowledgedResponse();
    }

    @Override
    protected ClusterBlockException checkBlock(DeleteRepositoryRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    @Override
    protected void masterOperation(DeleteRepositoryRequest request, ClusterState state, final ActionListener<AcknowledgedResponse> listener) {
        this.repositoriesService.unregisterRepository((RepositoriesService.UnregisterRepositoryRequest)((RepositoriesService.UnregisterRepositoryRequest)new RepositoriesService.UnregisterRepositoryRequest("delete_repository [" + request.name() + "]", request.name()).masterNodeTimeout(request.masterNodeTimeout())).ackTimeout(request.timeout()), new ActionListener<ClusterStateUpdateResponse>(){

            @Override
            public void onResponse(ClusterStateUpdateResponse unregisterRepositoryResponse) {
                listener.onResponse(new AcknowledgedResponse(unregisterRepositoryResponse.isAcknowledged()));
            }

            @Override
            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }
}

