/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.admin.cluster.snapshots.status;

import conductor.com.carrotsearch.hppc.cursors.ObjectCursor;
import conductor.com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.action.admin.cluster.snapshots.status.SnapshotIndexShardStage;
import conductor.org.elasticsearch.action.admin.cluster.snapshots.status.SnapshotIndexShardStatus;
import conductor.org.elasticsearch.action.admin.cluster.snapshots.status.SnapshotStatus;
import conductor.org.elasticsearch.action.admin.cluster.snapshots.status.SnapshotsStatusRequest;
import conductor.org.elasticsearch.action.admin.cluster.snapshots.status.SnapshotsStatusResponse;
import conductor.org.elasticsearch.action.admin.cluster.snapshots.status.TransportNodesSnapshotsStatus;
import conductor.org.elasticsearch.action.support.ActionFilters;
import conductor.org.elasticsearch.action.support.master.TransportMasterNodeAction;
import conductor.org.elasticsearch.cluster.ClusterState;
import conductor.org.elasticsearch.cluster.SnapshotsInProgress;
import conductor.org.elasticsearch.cluster.block.ClusterBlockException;
import conductor.org.elasticsearch.cluster.block.ClusterBlockLevel;
import conductor.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import conductor.org.elasticsearch.cluster.service.ClusterService;
import conductor.org.elasticsearch.common.Strings;
import conductor.org.elasticsearch.common.inject.Inject;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.common.util.set.Sets;
import conductor.org.elasticsearch.index.shard.ShardId;
import conductor.org.elasticsearch.index.snapshots.IndexShardSnapshotStatus;
import conductor.org.elasticsearch.repositories.RepositoryData;
import conductor.org.elasticsearch.snapshots.Snapshot;
import conductor.org.elasticsearch.snapshots.SnapshotException;
import conductor.org.elasticsearch.snapshots.SnapshotId;
import conductor.org.elasticsearch.snapshots.SnapshotInfo;
import conductor.org.elasticsearch.snapshots.SnapshotMissingException;
import conductor.org.elasticsearch.snapshots.SnapshotsService;
import conductor.org.elasticsearch.threadpool.ThreadPool;
import conductor.org.elasticsearch.transport.TransportService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class TransportSnapshotsStatusAction
extends TransportMasterNodeAction<SnapshotsStatusRequest, SnapshotsStatusResponse> {
    private final SnapshotsService snapshotsService;
    private final TransportNodesSnapshotsStatus transportNodesSnapshotsStatus;

    @Inject
    public TransportSnapshotsStatusAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, SnapshotsService snapshotsService, TransportNodesSnapshotsStatus transportNodesSnapshotsStatus, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, "cluster:admin/snapshot/status", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, SnapshotsStatusRequest::new);
        this.snapshotsService = snapshotsService;
        this.transportNodesSnapshotsStatus = transportNodesSnapshotsStatus;
    }

    @Override
    protected String executor() {
        return "generic";
    }

    @Override
    protected ClusterBlockException checkBlock(SnapshotsStatusRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    @Override
    protected SnapshotsStatusResponse newResponse() {
        return new SnapshotsStatusResponse();
    }

    @Override
    protected void masterOperation(final SnapshotsStatusRequest request, ClusterState state, final ActionListener<SnapshotsStatusResponse> listener) throws Exception {
        List<SnapshotsInProgress.Entry> currentSnapshots = this.snapshotsService.currentSnapshots(request.repository(), Arrays.asList(request.snapshots()));
        if (currentSnapshots.isEmpty()) {
            listener.onResponse(this.buildResponse(request, currentSnapshots, null));
            return;
        }
        HashSet<String> nodesIds = new HashSet<String>();
        for (SnapshotsInProgress.Entry entry : currentSnapshots) {
            for (ObjectCursor<SnapshotsInProgress.ShardSnapshotStatus> objectCursor : entry.shards().values()) {
                if (((SnapshotsInProgress.ShardSnapshotStatus)objectCursor.value).nodeId() == null) continue;
                nodesIds.add(((SnapshotsInProgress.ShardSnapshotStatus)objectCursor.value).nodeId());
            }
        }
        if (!nodesIds.isEmpty()) {
            Snapshot[] snapshots = new Snapshot[currentSnapshots.size()];
            for (int i = 0; i < currentSnapshots.size(); ++i) {
                snapshots[i] = currentSnapshots.get(i).snapshot();
            }
            TransportNodesSnapshotsStatus.Request nodesRequest = (TransportNodesSnapshotsStatus.Request)new TransportNodesSnapshotsStatus.Request(nodesIds.toArray(new String[nodesIds.size()])).snapshots(snapshots).timeout(request.masterNodeTimeout());
            this.transportNodesSnapshotsStatus.execute(nodesRequest, new ActionListener<TransportNodesSnapshotsStatus.NodesSnapshotStatus>(){

                @Override
                public void onResponse(TransportNodesSnapshotsStatus.NodesSnapshotStatus nodeSnapshotStatuses) {
                    try {
                        List<SnapshotsInProgress.Entry> currentSnapshots = TransportSnapshotsStatusAction.this.snapshotsService.currentSnapshots(request.repository(), Arrays.asList(request.snapshots()));
                        listener.onResponse(TransportSnapshotsStatusAction.this.buildResponse(request, currentSnapshots, nodeSnapshotStatuses));
                    }
                    catch (Exception e) {
                        listener.onFailure(e);
                    }
                }

                @Override
                public void onFailure(Exception e) {
                    listener.onFailure(e);
                }
            });
        } else {
            listener.onResponse(this.buildResponse(request, currentSnapshots, null));
        }
    }

    private SnapshotsStatusResponse buildResponse(SnapshotsStatusRequest request, List<SnapshotsInProgress.Entry> currentSnapshotEntries, TransportNodesSnapshotsStatus.NodesSnapshotStatus nodeSnapshotStatuses) throws IOException {
        String repositoryName;
        ArrayList<SnapshotStatus> builder = new ArrayList<SnapshotStatus>();
        HashSet<String> currentSnapshotNames = new HashSet<String>();
        if (!currentSnapshotEntries.isEmpty()) {
            Map nodeSnapshotStatusMap = nodeSnapshotStatuses != null ? nodeSnapshotStatuses.getNodesMap() : new HashMap();
            for (SnapshotsInProgress.Entry entry : currentSnapshotEntries) {
                currentSnapshotNames.add(entry.snapshot().getSnapshotId().getName());
                ArrayList<SnapshotIndexShardStatus> shardStatusBuilder = new ArrayList<SnapshotIndexShardStatus>();
                for (ObjectObjectCursor<ShardId, SnapshotsInProgress.ShardSnapshotStatus> objectObjectCursor : entry.shards()) {
                    SnapshotIndexShardStage stage;
                    SnapshotIndexShardStatus shardStatus;
                    Map<ShardId, SnapshotIndexShardStatus> shardStatues;
                    TransportNodesSnapshotsStatus.NodeSnapshotStatus nodeStatus;
                    SnapshotsInProgress.ShardSnapshotStatus status = (SnapshotsInProgress.ShardSnapshotStatus)objectObjectCursor.value;
                    if (status.nodeId() != null && (nodeStatus = (TransportNodesSnapshotsStatus.NodeSnapshotStatus)nodeSnapshotStatusMap.get(status.nodeId())) != null && (shardStatues = nodeStatus.status().get(entry.snapshot())) != null && (shardStatus = shardStatues.get(objectObjectCursor.key)) != null) {
                        shardStatusBuilder.add(shardStatus);
                        continue;
                    }
                    switch (((SnapshotsInProgress.ShardSnapshotStatus)objectObjectCursor.value).state()) {
                        case FAILED: 
                        case ABORTED: 
                        case MISSING: {
                            stage = SnapshotIndexShardStage.FAILURE;
                            break;
                        }
                        case INIT: 
                        case WAITING: 
                        case STARTED: {
                            stage = SnapshotIndexShardStage.STARTED;
                            break;
                        }
                        case SUCCESS: {
                            stage = SnapshotIndexShardStage.DONE;
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown snapshot state " + (Object)((Object)((SnapshotsInProgress.ShardSnapshotStatus)objectObjectCursor.value).state()));
                        }
                    }
                    SnapshotIndexShardStatus shardStatus2 = new SnapshotIndexShardStatus((ShardId)objectObjectCursor.key, stage);
                    shardStatusBuilder.add(shardStatus2);
                }
                builder.add(new SnapshotStatus(entry.snapshot(), entry.state(), Collections.unmodifiableList(shardStatusBuilder), entry.includeGlobalState()));
            }
        }
        if (Strings.hasText(repositoryName = request.repository()) && request.snapshots() != null && request.snapshots().length > 0) {
            HashSet<String> requestedSnapshotNames = Sets.newHashSet(request.snapshots());
            RepositoryData repositoryData = this.snapshotsService.getRepositoryData(repositoryName);
            Map matchedSnapshotIds = repositoryData.getAllSnapshotIds().stream().filter(s -> requestedSnapshotNames.contains(s.getName())).collect(Collectors.toMap(SnapshotId::getName, Function.identity()));
            for (String snapshotName : request.snapshots()) {
                SnapshotsInProgress.State state;
                if (currentSnapshotNames.contains(snapshotName)) continue;
                SnapshotId snapshotId = (SnapshotId)matchedSnapshotIds.get(snapshotName);
                if (snapshotId == null) {
                    if (request.ignoreUnavailable()) {
                        this.logger.debug("snapshot status request ignoring snapshot [{}], not found in repository [{}]", (Object)snapshotName, (Object)repositoryName);
                        continue;
                    }
                    throw new SnapshotMissingException(repositoryName, snapshotName);
                }
                if (repositoryData.getIncompatibleSnapshotIds().contains(snapshotId)) {
                    throw new SnapshotException(repositoryName, snapshotName, "cannot get the status for an incompatible snapshot");
                }
                SnapshotInfo snapshotInfo = this.snapshotsService.snapshot(repositoryName, snapshotId);
                ArrayList<SnapshotIndexShardStatus> shardStatusBuilder = new ArrayList<SnapshotIndexShardStatus>();
                if (!snapshotInfo.state().completed()) continue;
                Map<ShardId, IndexShardSnapshotStatus> shardStatuses = this.snapshotsService.snapshotShards(repositoryName, repositoryData, snapshotInfo);
                for (Map.Entry<ShardId, IndexShardSnapshotStatus> shardStatus : shardStatuses.entrySet()) {
                    IndexShardSnapshotStatus.Copy lastSnapshotStatus = shardStatus.getValue().asCopy();
                    shardStatusBuilder.add(new SnapshotIndexShardStatus(shardStatus.getKey(), lastSnapshotStatus));
                }
                switch (snapshotInfo.state()) {
                    case FAILED: {
                        state = SnapshotsInProgress.State.FAILED;
                        break;
                    }
                    case SUCCESS: 
                    case PARTIAL: {
                        state = SnapshotsInProgress.State.SUCCESS;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown snapshot state " + (Object)((Object)snapshotInfo.state()));
                    }
                }
                builder.add(new SnapshotStatus(new Snapshot(repositoryName, snapshotId), state, Collections.unmodifiableList(shardStatusBuilder), snapshotInfo.includeGlobalState()));
            }
        }
        return new SnapshotsStatusResponse(Collections.unmodifiableList(builder));
    }
}

